package Google::Ads::AdWords::v201605::TrialAsyncError;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201605' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %trialId_of :ATTR(:get<trialId>);
my %asyncError_of :ATTR(:get<asyncError>);
my %trialCampaignId_of :ATTR(:get<trialCampaignId>);
my %trialAdGroupId_of :ATTR(:get<trialAdGroupId>);
my %baseCampaignId_of :ATTR(:get<baseCampaignId>);
my %baseAdGroupId_of :ATTR(:get<baseAdGroupId>);

__PACKAGE__->_factory(
    [ qw(        trialId
        asyncError
        trialCampaignId
        trialAdGroupId
        baseCampaignId
        baseAdGroupId

    ) ],
    {
        'trialId' => \%trialId_of,
        'asyncError' => \%asyncError_of,
        'trialCampaignId' => \%trialCampaignId_of,
        'trialAdGroupId' => \%trialAdGroupId_of,
        'baseCampaignId' => \%baseCampaignId_of,
        'baseAdGroupId' => \%baseAdGroupId_of,
    },
    {
        'trialId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'asyncError' => 'Google::Ads::AdWords::v201605::ApiError',
        'trialCampaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'trialAdGroupId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'baseCampaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'baseAdGroupId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'trialId' => 'trialId',
        'asyncError' => 'asyncError',
        'trialCampaignId' => 'trialCampaignId',
        'trialAdGroupId' => 'trialAdGroupId',
        'baseCampaignId' => 'baseCampaignId',
        'baseAdGroupId' => 'baseAdGroupId',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201605::TrialAsyncError

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TrialAsyncError from the namespace https://adwords.google.com/api/adwords/cm/v201605.

An error that has occurred while asynchronously processing the creation or promotion of a trial. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * trialId


=item * asyncError


=item * trialCampaignId


=item * trialAdGroupId


=item * baseCampaignId


=item * baseAdGroupId




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

