package Google::Ads::AdWords::v201708::UserIdentifier;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201708' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %userIdentifierType_of :ATTR(:get<userIdentifierType>);
my %value_of :ATTR(:get<value>);

__PACKAGE__->_factory(
    [ qw(        userIdentifierType
        value

    ) ],
    {
        'userIdentifierType' => \%userIdentifierType_of,
        'value' => \%value_of,
    },
    {
        'userIdentifierType' => 'Google::Ads::AdWords::v201708::OfflineDataUploadUserIdentifierType',
        'value' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'userIdentifierType' => 'userIdentifierType',
        'value' => 'value',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201708::UserIdentifier

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
UserIdentifier from the namespace https://adwords.google.com/api/adwords/rm/v201708.

Hashed user identifying information. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * userIdentifierType


=item * value




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

