package Google::Ads::AdWords::v201705::RemarketingSettings;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201705' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %snippet_of :ATTR(:get<snippet>);

__PACKAGE__->_factory(
    [ qw(        snippet

    ) ],
    {
        'snippet' => \%snippet_of,
    },
    {
        'snippet' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'snippet' => 'snippet',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201705::RemarketingSettings

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RemarketingSettings from the namespace https://adwords.google.com/api/adwords/mcm/v201705.

Customer-wide settings related to AdWords remarketing. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * snippet




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

