package Google::Ads::AdWords::v201609::UniversalAppCampaignAdsPolicyDecisions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201609' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %universalAppCampaignAsset_of :ATTR(:get<universalAppCampaignAsset>);
my %assetId_of :ATTR(:get<assetId>);
my %policyTopicEntries_of :ATTR(:get<policyTopicEntries>);

__PACKAGE__->_factory(
    [ qw(        universalAppCampaignAsset
        assetId
        policyTopicEntries

    ) ],
    {
        'universalAppCampaignAsset' => \%universalAppCampaignAsset_of,
        'assetId' => \%assetId_of,
        'policyTopicEntries' => \%policyTopicEntries_of,
    },
    {
        'universalAppCampaignAsset' => 'Google::Ads::AdWords::v201609::UniversalAppCampaignAsset',
        'assetId' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'policyTopicEntries' => 'Google::Ads::AdWords::v201609::PolicyTopicEntry',
    },
    {

        'universalAppCampaignAsset' => 'universalAppCampaignAsset',
        'assetId' => 'assetId',
        'policyTopicEntries' => 'policyTopicEntries',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201609::UniversalAppCampaignAdsPolicyDecisions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
UniversalAppCampaignAdsPolicyDecisions from the namespace https://adwords.google.com/api/adwords/cm/v201609.

Contains Universal App Campaign Ads Policy decisions with asset identifier information, where available. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * universalAppCampaignAsset


=item * assetId


=item * policyTopicEntries




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

