use warnings;
use strict;
use feature 'say';

use Data::Dumper;
use IPC::Shareable;
use Test::More;

my %hash;

my $s = tie %hash, 'IPC::Shareable', {
    key => 1111,
    create => 1,
    destroy => 1,
    persist => 1
};

is $hash{a}, 1, "hash key 'a' ok";
is $hash{b}, 'blah', "hash key 'b' ok";

is ref $hash{c}, 'HASH', "hash key 'c' is a HASH ok";
is $hash{c}->{a}, 1, "hash{c}->{a} is 1 ok";

$hash{d} = {m => 2, x => 3};

done_testing();
