use warnings;
use strict;

use Data::Dumper;
use Test::More;

BEGIN { use_ok('IPC::Shareable') };
use IPC::SysV qw(IPC_PRIVATE SEM_UNDO IPC_RMID);

my $id = shmget(IPC_PRIVATE, 1024, 0666);

is defined $id, 1, "shmget() create ok";

my $var  = 'foobar';
my $copy = '';
is shmwrite($id, $var, 0, length('foobar')), 1, "shmwrite() ok";

is shmread($id, $copy, 0, length('foobar')), 1, "shmread() ok";
is $var, $copy, "what was written is the same as what was read";

is shmctl($id, IPC_RMID, 0), '0 but true', "shmctl remove ok";

$id = semget(IPC_PRIVATE, 1, 0666);
is defined $id, 1, "semget() ok";

my $semop = pack('sss', 0, 1, SEM_UNDO);
is semop($id, $semop), 1, "semop() ok";

is semctl($id, 0, IPC_RMID, 0), '0 but true', "semctl() remove ok";

# --- Argument parsing
my %nothing;

my $s = tie %nothing, 'IPC::Shareable';
for my $k (keys %IPC::Shareable::default_options) {
    is $s->{_opts}->{$k}, $IPC::Shareable::default_options{$k}, "default opt $k ok";
}

$s->{_shm}->remove;
$s->{_sem}->remove;

my $opts = {
    key       => 1234,
    create    => 1,
    exclusive => 1,
    destroy   => 1,
    persist   => 1,
    mode      => 0600,
    size      => 999,
};

$s = tie my %opt_test => 'IPC::Shareable', $opts;
$opt_test{a} = 1;

for my $k (keys %$opts) {
    is $s->{_opts}->{$k}, $opts->{$k}, "sent in opt $k matches";
}

$s->clean_up_all;

is %opt_test, 1, "with persist, hash still exists after clean_up_all()";

$s->erase;
is %opt_test, '', "after erase, it's gone";

done_testing();
