/*
** platform.c [win32 version]
**
*/

#include "parrot/parrot.h"


/*
** Parrot_intval_time()
*/

INTVAL Parrot_intval_time (void)
{
  return time(NULL);
}


/*
** Parrot_floatval_time()
*/

FLOATVAL Parrot_floatval_time (void)
{
  SYSTEMTIME sysTime;
  FILETIME fileTime;  /* 100ns == 1 */
  LARGE_INTEGER i;

  GetSystemTime(&sysTime);
  SystemTimeToFileTime(&sysTime, &fileTime);
  /* Documented as the way to get a 64 bit from a FILETIME. */
  memcpy(&i, &fileTime, sizeof(LARGE_INTEGER));

  return (FLOATVAL)i.QuadPart / 10000000.0; /*1e7*/
}


/*
** Parrot_sleep()
*/

void Parrot_sleep(unsigned int seconds)
{
  Sleep(seconds * 1000);
}


/*
** Parrot_setenv()
*/

void Parrot_setenv(const char * name, const char * value)
{
  SetEnvironmentVariable(name, value);
}


/*
** Parrot_dlopen()
*/

void * Parrot_dlopen (const char * filename, int flag)
{
  return LoadLibrary(filename);
}


/*
** Parrot_dlerror()
*/

const char * Parrot_dlerror(void)
{
  return NULL;
}


/*
** Parrot_dlsym()
*/

void * Parrot_dlsym(void * handle, char * symbol)
{
  return GetProcAddress(handle, symbol);
}


/*
** Parrot_dlclose()
*/

int Parrot_dlclose (void * handle)
{
  return FreeLibrary(handle);
}
