# AsyncLogWatcher

## Description

`AsyncLogWatcher` is a Perl module that watches a log file for lines matching a given set of patterns. When a line matches one of the patterns and does not match any of the exclude patterns, a callback function is called with the matched line as an argument.

## Usage

```perl
use AsyncLogWatcher;

my $watcher = AsyncLogWatcher->new({
    log_dir       => "/var/log",
    log_file_name => "messages",
    patterns_file => "patterns.txt",
    exclude_file  => "exclude.txt",
});

$watcher->watch();
```

## Installation

Copy the `AsyncLogWatcher.pm` file to your Perl library directory, or you can use the standard Perl module build and install commands:

```shell
perl Makefile.PL
make
make test
make install
```

Note: You may need superuser permissions to install.

## Author

Kawamura Shingo <pannakoota@gmail.com>

## License

This library is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

## Copyright

Copyright (C) 2023 by Kawamura Shingo
