use Unicode::Collate::CJK::Stroke;
+{
   locale_version => 1.08,
   overrideCJK => \&Unicode::Collate::CJK::Stroke::weightStroke,
   entry => <<'ENTRY', # for DUCET v7.0.0
0101      ; [.190C.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.190C.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.190C.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.190C.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.190C.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.190C.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.190C.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.190C.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.190C.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.190C.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.190C.001E.0002] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.190C.001E.0002] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.190C.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.190C.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.190C.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.190C.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.190C.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.190C.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.190C.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.190C.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.196E.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.196E.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.196E.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.196E.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.196E.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.196E.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.196E.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.196E.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.196E.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.196E.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.196E.001E.0002] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.196E.001E.0002] # LATIN SMALL LETTER E WITH CARON
011A      ; [.196E.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.196E.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.196E.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.196E.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.196E.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.196E.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.196E.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.196E.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.196E.0021.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.196E.0021.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.196E.0021.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.196E.0021.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.196E.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.196E.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.196E.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.196E.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.196E.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.196E.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.196E.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.196E.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.196E.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.196E.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.196E.0023.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.196E.0023.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.196E.0023.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.196E.0023.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.196E.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.196E.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.196E.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.196E.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.196E.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.196E.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.196E.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.196E.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.196E.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.196E.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.196E.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.196E.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.196E.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.196E.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.196E.0025.0002][.0000.002D.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.196E.0025.0008][.0000.002D.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.196E.0025.0002][.0000.003B.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.196E.0025.0008][.0000.003B.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.196E.0025.0002][.0000.0042.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.196E.0025.0008][.0000.0042.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.19F6.001C.0002] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.19F6.001C.0002] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.19F6.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.19F6.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.19F6.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.19F6.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.19F6.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.19F6.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.19F6.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.19F6.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.19F6.001E.0002] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.19F6.001E.0002] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.19F6.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.19F6.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.19F6.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.19F6.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.19F6.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.19F6.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.19F6.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.19F6.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.1A6E.001C.0002] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.1A6E.001C.0008] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.1A6E.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.1A6E.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.1A6E.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.1A6E.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.1A6E.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.1A6E.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.1A6E.001E.0002] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.1A6E.001E.0008] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.1A6E.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.1A6E.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.1A6E.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.1A6E.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.1A7D.001C.0002] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.1A7D.001C.0008] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.1A7D.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.1A7D.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.1A7D.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.1A7D.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.1A7D.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.1A7D.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.1A7D.001E.0002] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.1A7D.001E.0002] # LATIN SMALL LETTER N WITH CARON
0147      ; [.1A7D.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.1A7D.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.1A7D.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.1A7D.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.1A7D.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.1A7D.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.1A7D.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.1A7D.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.1AA1.001C.0002] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.1AA1.001C.0002] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.1AA1.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.1AA1.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.1AA1.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.1AA1.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.1AA1.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.1AA1.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.1AA1.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.1AA1.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.1AA1.001E.0002] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.1AA1.001E.0002] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.1AA1.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.1AA1.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.1AA1.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.1AA1.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.1AA1.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.1AA1.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.1AA1.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.1AA1.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.1B77.001C.0002] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.1B77.001C.0002] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.1B77.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.1B77.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.1B77.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.1B77.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.1B77.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.1B77.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.1B77.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.1B77.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.1B77.001E.0002] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.1B77.001E.0002] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.1B77.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.1B77.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.1B77.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.1B77.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.1B77.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.1B77.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.1B77.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.1B77.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.1B77.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.1B77.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.1B77.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.1B77.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.1B77.0021.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.1B77.0021.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.1B77.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.1B77.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.1B77.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.1B77.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.1B77.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.1B77.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.1B77.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.1B77.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.1B77.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.1B77.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.1B77.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.1B77.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.1B77.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.1B77.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.1B77.0023.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.1B77.0023.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.1B77.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.1B77.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.1B77.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.1B77.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.1B77.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.1B77.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.1B77.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.1B77.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.1B77.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.1B77.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.1B77.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.1B77.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.1B77.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.1B77.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
FDD0 2801 ; [.8000.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1>
2E84      ; [.8007.0020.0002] # CJK RADICAL SECOND THREE
3006      ; [.8012.0020.0002] # IDEOGRAPHIC CLOSING MARK
3007      ; [.8013.0020.0002] # IDEOGRAPHIC NUMBER ZERO
3021      ; [.8014.0020.0002] # HANGZHOU NUMERAL ONE
3025      ; [.8015.0020.0002] # HANGZHOU NUMERAL FIVE
303B      ; [.8016.0020.0002] # VERTICAL IDEOGRAPHIC ITERATION MARK
FDD0 2802 ; [.8017.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-2>
2E86      ; [.8031.0020.0002] # CJK RADICAL BOX
2E87      ; [.8035.0020.0002] # CJK RADICAL TABLE
2E88      ; [.8038.0020.0002] # CJK RADICAL KNIFE ONE
2E8A      ; [.8042.0020.0002] # CJK RADICAL DIVINATION
2E80      ; [.8047.0020.0002] # CJK RADICAL REPEAT
2ECF      ; [.804B.0020.0002] # CJK RADICAL CITY
2ED6      ; [.804C.0020.0002] # CJK RADICAL MOUND TWO
3022      ; [.804E.0020.0002] # HANGZHOU NUMERAL TWO
3024      ; [.804F.0020.0002] # HANGZHOU NUMERAL FOUR
3026      ; [.8050.0020.0002] # HANGZHOU NUMERAL SIX
FDD0 2803 ; [.8051.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-12>
2E8C      ; [.808F.0020.0002] # CJK RADICAL SMALL ONE
2E8D      ; [.8090.0020.0002] # CJK RADICAL SMALL TWO
2E95      ; [.80A8.0020.0002] # CJK RADICAL SNOUT TWO
2EBE      ; [.80B3.0020.0002] # CJK RADICAL GRASS ONE
2ECC      ; [.80B5.0020.0002] # CJK RADICAL SIMPLIFIED WALK
3005      ; [.80BB.0020.0002] # IDEOGRAPHIC ITERATION MARK
3023      ; [.80BC.0020.0002] # HANGZHOU NUMERAL THREE
3027      ; [.80BD.0020.0002] # HANGZHOU NUMERAL SEVEN
FDD0 2804 ; [.80BE.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-3>
2E9C      ; [.815B.0020.0002] # CJK RADICAL SUN
2E9D      ; [.815E.0020.0002] # CJK RADICAL MOON
2EA5      ; [.8170.0020.0002] # CJK RADICAL PAW TWO
2EA7      ; [.817A.0020.0002] # CJK RADICAL COW
2EBC      ; [.8185.0020.0002] # CJK RADICAL MEAT
2ECD      ; [.818E.0020.0002] # CJK RADICAL WALK ONE
3028      ; [.8193.0020.0002] # HANGZHOU NUMERAL EIGHT
3029      ; [.8194.0020.0002] # HANGZHOU NUMERAL NINE
FDD0 2805 ; [.8195.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-13>
2EAA      ; [.82B3.0020.0002] # CJK RADICAL BOLT OF CLOTH
2EAC      ; [.82BF.0020.0002] # CJK RADICAL SPIRIT ONE
FDD0 2806 ; [.82E7.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-23>
2EAE      ; [.84B2.0020.0002] # CJK RADICAL BAMBOO
2EB6      ; [.84C6.0020.0002] # CJK RADICAL SHEEP
FDD0 2807 ; [.8529.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-123>
2EC6      ; [.887A.0020.0002] # CJK RADICAL SIMPLIFIED HORN
2ECA      ; [.889A.0020.0002] # CJK RADICAL FOOT
FDD0 2808 ; [.88FA.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-4>
FA24      ; [.8E20.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA24
2ED7      ; [.8E5B.0020.0002] # CJK RADICAL RAIN
FDD0 2809 ; [.8E7C.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-14>
2EDE      ; [.94AC.0020.0002] # CJK RADICAL EAT TWO
2EE3      ; [.94C3.0020.0002] # CJK RADICAL BONE
FDD0 280A ; [.94CA.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-24>
FA0F      ; [.95F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0F
FDD0 280B ; [.9C16.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-124>
FA21      ; [.A279.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA21
FA23      ; [.A312.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA23
FDD0 280C ; [.A41D.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-34>
FA11      ; [.A5A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA11
FDD0 280D ; [.AC7F.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-134>
FA0E      ; [.ACD0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0E
FA13      ; [.AEF8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA13
FA29      ; [.B3B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA29
FDD0 280E ; [.B44A.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-234>
FA14      ; [.B690.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA14
FDD0 280F ; [.BB5A.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1234>
FA27      ; [.C173.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA27
FDD0 2810 ; [.C276.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-5>
FA28      ; [.C748.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA28
FDD0 2811 ; [.C860.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-15>
FDD0 2812 ; [.CD3D.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-25>
FDD0 2813 ; [.D0E6.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-125>
FA1F      ; [.D23D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1F
FDD0 2814 ; [.D41B.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-35>
FDD0 2815 ; [.D68C.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-135>
FDD0 2816 ; [.D846.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-235>
FDD0 2817 ; [.D993.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1235>
FDD0 2818 ; [.DA95.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-45>
FDD0 2819 ; [.DB3D.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-145>
FDD0 281A ; [.DBB4.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-245>
FDD0 281B ; [.DBF1.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1245>
FDD0 281C ; [.DC29.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-345>
FDD0 281D ; [.DC4D.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1345>
FDD0 281E ; [.DC5C.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-2345>
FDD0 281F ; [.DC6C.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-12345>
FDD0 2820 ; [.DC71.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-6>
FDD0 2821 ; [.DC76.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-16>
FDD0 2823 ; [.DC7C.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-126>
FDD0 2824 ; [.DC7E.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-36>
FDD0 2827 ; [.DC80.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1236>
FDD0 2830 ; [.DC82.0020.0002] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-56>
3220      ; [*030A.0020.0004][.8001.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH ONE
3226      ; [*030A.0020.0004][.801A.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH SEVEN
3222      ; [*030A.0020.0004][.8054.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH THREE
3228      ; [*030A.0020.0004][.8027.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH NINE
3221      ; [*030A.0020.0004][.802A.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH TWO
3224      ; [*030A.0020.0004][.80D7.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH FIVE
3239      ; [*030A.0020.0004][.81C2.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH REPRESENT
323D      ; [*030A.0020.0004][.831C.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH ENTERPRISE
3241      ; [*030A.0020.0004][.832C.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH REST
3227      ; [*030A.0020.0004][.8030.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH EIGHT
3225      ; [*030A.0020.0004][.80F5.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH SIX
3238      ; [*030A.0020.0004][.85A8.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH LABOR
3229      ; [*030A.0020.0004][.8041.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH TEN
323F      ; [*030A.0020.0004][.899D.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH ALLIANCE
3234      ; [*030A.0020.0004][.839D.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH NAME
323A      ; [*030A.0020.0004][.89D5.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH CALL
3223      ; [*030A.0020.0004][.822D.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH FOUR
322F      ; [*030A.0020.0004][.8081.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH EARTH
323B      ; [*030A.0020.0004][.8A8D.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH STUDY
3230      ; [*030A.0020.0004][.815C.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH SUN
322A      ; [*030A.0020.0004][.815F.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH MOON
3232      ; [*030A.0020.0004][.845A.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH HAVE
322D      ; [*030A.0020.0004][.8160.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH WOOD
3231      ; [*030A.0020.0004][.979F.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH STOCK
322C      ; [*030A.0020.0004][.816D.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH WATER
322B      ; [*030A.0020.0004][.816E.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH FIRE
3235      ; [*030A.0020.0004][.9895.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH SPECIAL
323C      ; [*030A.0020.0004][.B79A.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH SUPERVISE
3233      ; [*030A.0020.0004][.8D2E.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH SOCIETY
3237      ; [*030A.0020.0004][.9970.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH CONGRATULATION
3240      ; [*030A.0020.0004][.A100.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH FESTIVAL
3242      ; [*030A.0020.0004][.84D8.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH SELF
3243      ; [*030A.0020.0004][.84D9.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH REACH
3236      ; [*030A.0020.0004][.9B3B.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH FINANCIAL
323E      ; [*030A.0020.0004][.B2A5.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH RESOURCE
322E      ; [*030A.0020.0004][.8E33.0020.0004][*030B.0020.0004] # PARENTHESIZED IDEOGRAPH METAL
3358      ; [.1902.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
33E9      ; [.1903.0020.0004][.1902.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
32C9      ; [.1903.0020.0004][.1902.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
3362      ; [.1903.0020.0004][.1902.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
33EA      ; [.1903.0020.0004][.1903.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
32CA      ; [.1903.0020.0004][.1903.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
3363      ; [.1903.0020.0004][.1903.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
33EB      ; [.1903.0020.0004][.1904.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
32CB      ; [.1903.0020.0004][.1904.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
3364      ; [.1903.0020.0004][.1904.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
33EC      ; [.1903.0020.0004][.1905.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
3365      ; [.1903.0020.0004][.1905.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
33ED      ; [.1903.0020.0004][.1906.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
3366      ; [.1903.0020.0004][.1906.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
33EE      ; [.1903.0020.0004][.1907.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
3367      ; [.1903.0020.0004][.1907.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
33EF      ; [.1903.0020.0004][.1908.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
3368      ; [.1903.0020.0004][.1908.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
33F0      ; [.1903.0020.0004][.1909.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
3369      ; [.1903.0020.0004][.1909.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
33F1      ; [.1903.0020.0004][.190A.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
336A      ; [.1903.0020.0004][.190A.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
33F2      ; [.1903.0020.0004][.190B.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
336B      ; [.1903.0020.0004][.190B.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
33E0      ; [.1903.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
32C0      ; [.1903.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
3359      ; [.1903.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
33F3      ; [.1904.0020.0004][.1902.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
336C      ; [.1904.0020.0004][.1902.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
33F4      ; [.1904.0020.0004][.1903.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
336D      ; [.1904.0020.0004][.1903.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
33F5      ; [.1904.0020.0004][.1904.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
336E      ; [.1904.0020.0004][.1904.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
33F6      ; [.1904.0020.0004][.1905.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
336F      ; [.1904.0020.0004][.1905.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
33F7      ; [.1904.0020.0004][.1906.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
3370      ; [.1904.0020.0004][.1906.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
33F8      ; [.1904.0020.0004][.1907.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
33F9      ; [.1904.0020.0004][.1908.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
33FA      ; [.1904.0020.0004][.1909.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
33FB      ; [.1904.0020.0004][.190A.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
33FC      ; [.1904.0020.0004][.190B.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
33E1      ; [.1904.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
32C1      ; [.1904.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
335A      ; [.1904.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
33FD      ; [.1905.0020.0004][.1902.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
33FE      ; [.1905.0020.0004][.1903.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
33E2      ; [.1905.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
32C2      ; [.1905.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
335B      ; [.1905.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
33E3      ; [.1906.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
32C3      ; [.1906.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
335C      ; [.1906.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
33E4      ; [.1907.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
32C4      ; [.1907.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
335D      ; [.1907.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
33E5      ; [.1908.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
32C5      ; [.1908.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
335E      ; [.1908.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
33E6      ; [.1909.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
32C6      ; [.1909.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
335F      ; [.1909.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
33E7      ; [.190A.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
32C7      ; [.190A.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
3360      ; [.190A.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
33E8      ; [.190B.0020.0004][.815C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
32C8      ; [.190B.0020.0004][.815F.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
3361      ; [.190B.0020.0004][.9216.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
1F241     ; [*036C.0020.0004][.8054.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E09
1F242     ; [*036C.0020.0004][.802A.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E8C
1F247     ; [*036C.0020.0004][.A465.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-52DD
1F243     ; [*036C.0020.0004][.83F0.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-5B89
1F245     ; [*036C.0020.0004][.8277.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6253
1F248     ; [*036C.0020.0004][.9EDA.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
1F240     ; [*036C.0020.0004][.8283.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C
1F244     ; [*036C.0020.0004][.9216.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-70B9
1F246     ; [*036C.0020.0004][.A0BD.0020.0004][*036D.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-76D7
2F00      ; [.8001.0020.0004] # KANGXI RADICAL ONE
3192      ; [.8001.0020.0014] # IDEOGRAPHIC ANNOTATION ONE MARK
3280      ; [.8001.0020.0006] # CIRCLED IDEOGRAPH ONE
1F229     ; [.8001.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E00
319C      ; [.8018.0020.0014] # IDEOGRAPHIC ANNOTATION FOURTH MARK
3286      ; [.801A.0020.0006] # CIRCLED IDEOGRAPH SEVEN
3194      ; [.8054.0020.0014] # IDEOGRAPHIC ANNOTATION THREE MARK
3282      ; [.8054.0020.0006] # CIRCLED IDEOGRAPH THREE
1F22A     ; [.8054.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E09
3196      ; [.8055.0020.0014] # IDEOGRAPHIC ANNOTATION TOP MARK
32A4      ; [.8055.0020.0006] # CIRCLED IDEOGRAPH HIGH
3198      ; [.8056.0020.0014] # IDEOGRAPHIC ANNOTATION BOTTOM MARK
32A6      ; [.8056.0020.0006] # CIRCLED IDEOGRAPH LOW
319B      ; [.819C.0020.0014] # IDEOGRAPHIC ANNOTATION THIRD MARK
2F01      ; [.8002.0020.0004] # KANGXI RADICAL LINE
3197      ; [.80C6.0020.0014] # IDEOGRAPHIC ANNOTATION MIDDLE MARK
32A5      ; [.80C6.0020.0006] # CIRCLED IDEOGRAPH CENTRE
1F22D     ; [.80C6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E2D
2F02      ; [.8003.0020.0004] # KANGXI RADICAL DOT
2F03      ; [.8004.0020.0004] # KANGXI RADICAL SLASH
2F04      ; [.8008.0020.0004] # KANGXI RADICAL SECOND
319A      ; [.8008.0020.0014] # IDEOGRAPHIC ANNOTATION SECOND MARK
3288      ; [.8027.0020.0006] # CIRCLED IDEOGRAPH NINE
2F05      ; [.8010.0020.0004] # KANGXI RADICAL HOOK
2F06      ; [.802A.0020.0004] # KANGXI RADICAL TWO
3193      ; [.802A.0020.0014] # IDEOGRAPHIC ANNOTATION TWO MARK
3281      ; [.802A.0020.0006] # CIRCLED IDEOGRAPH TWO
1F214     ; [.802A.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E8C
3284      ; [.80D7.0020.0006] # CIRCLED IDEOGRAPH FIVE
2F07      ; [.802B.0020.0004] # KANGXI RADICAL LID
1F218     ; [.8300.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4EA4
2F08      ; [.802C.0020.0004] # KANGXI RADICAL MAN
319F      ; [.802C.0020.0014] # IDEOGRAPHIC ANNOTATION MAN MARK
32AD      ; [.831C.0020.0006] # CIRCLED IDEOGRAPH ENTERPRISE
32A1      ; [.832C.0020.0006] # CIRCLED IDEOGRAPH REST
329D      ; [.C86C.0020.0006] # CIRCLED IDEOGRAPH EXCELLENT
2F09      ; [.802E.0020.0004] # KANGXI RADICAL LEGS
2F0A      ; [.802F.0020.0004] # KANGXI RADICAL ENTER
2F0B      ; [.8030.0020.0004] # KANGXI RADICAL EIGHT
3287      ; [.8030.0020.0006] # CIRCLED IDEOGRAPH EIGHT
3285      ; [.80F5.0020.0006] # CIRCLED IDEOGRAPH SIX
2F0C      ; [.8032.0020.0004] # KANGXI RADICAL DOWN BOX
1F21E     ; [.8356.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-518D
2F0D      ; [.8033.0020.0004] # KANGXI RADICAL COVER
32A2      ; [.81D8.0020.0006] # CIRCLED IDEOGRAPH COPY
2F0E      ; [.8034.0020.0004] # KANGXI RADICAL ICE
2F0F      ; [.8036.0020.0004] # KANGXI RADICAL TABLE
2F10      ; [.8037.0020.0004] # KANGXI RADICAL OPEN BOX
2F11      ; [.8039.0020.0004] # KANGXI RADICAL KNIFE
1F220     ; [.858C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-521D
1F21C     ; [.8EE7.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-524D
1F239     ; [.A45F.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5272
2F12      ; [.803C.0020.0004] # KANGXI RADICAL POWER
3298      ; [.85A8.0020.0006] # CIRCLED IDEOGRAPH LABOR
2F13      ; [.803D.0020.0004] # KANGXI RADICAL WRAP
2F14      ; [.803E.0020.0004] # KANGXI RADICAL SPOON
2F15      ; [.803F.0020.0004] # KANGXI RADICAL RIGHT OPEN BOX
2F16      ; [.8040.0020.0004] # KANGXI RADICAL HIDING ENCLOSURE
32A9      ; [.85B0.0020.0006] # CIRCLED IDEOGRAPH MEDICINE
2F17      ; [.8041.0020.0004] # KANGXI RADICAL TEN
3038      ; [.8041.0020.0004] # HANGZHOU NUMERAL TEN
3289      ; [.8041.0020.0006] # CIRCLED IDEOGRAPH TEN
3039      ; [.8059.0020.0004] # HANGZHOU NUMERAL TWENTY
303A      ; [.8118.0020.0004] # HANGZHOU NUMERAL THIRTY
32AF      ; [.899D.0020.0006] # CIRCLED IDEOGRAPH ALLIANCE
2F18      ; [.8043.0020.0004] # KANGXI RADICAL DIVINATION
2F19      ; [.8044.0020.0004] # KANGXI RADICAL SEAL
329E      ; [.8384.0020.0006] # CIRCLED IDEOGRAPH PRINT
2F1A      ; [.8045.0020.0004] # KANGXI RADICAL CLIFF
2F1B      ; [.8046.0020.0004] # KANGXI RADICAL PRIVATE
2F1C      ; [.8048.0020.0004] # KANGXI RADICAL AGAIN
1F212     ; [.8128.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-53CC
2F1D      ; [.807F.0020.0004] # KANGXI RADICAL MOUTH
1F251     ; [.8218.0020.0006] # CIRCLED IDEOGRAPH ACCEPT
32A8      ; [.821C.0020.0006] # CIRCLED IDEOGRAPH RIGHT
1F22E     ; [.821C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-53F3
1F234     ; [.8398.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5408
3294      ; [.839D.0020.0006] # CIRCLED IDEOGRAPH NAME
1F225     ; [.85E1.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5439
3244      ; [.9CC0.0020.0006] # CIRCLED IDEOGRAPH QUESTION
1F23A     ; [.9CFD.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-55B6
2F1E      ; [.8080.0020.0004] # KANGXI RADICAL ENCLOSURE
3195      ; [.822D.0020.0014] # IDEOGRAPHIC ANNOTATION FOUR MARK
3283      ; [.822D.0020.0006] # CIRCLED IDEOGRAPH FOUR
2F1F      ; [.8081.0020.0004] # KANGXI RADICAL EARTH
328F      ; [.8081.0020.0006] # CIRCLED IDEOGRAPH EARTH
319E      ; [.83B9.0020.0014] # IDEOGRAPHIC ANNOTATION EARTH MARK
2F20      ; [.8082.0020.0004] # KANGXI RADICAL SCHOLAR
1F224     ; [.8649.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-58F0
2F21      ; [.8083.0020.0004] # KANGXI RADICAL GO
2F22      ; [.8084.0020.0004] # KANGXI RADICAL GO SLOWLY
2F23      ; [.8085.0020.0004] # KANGXI RADICAL EVENING
1F215     ; [.83C8.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-591A
32B0      ; [.8A3E.0020.0006] # CIRCLED IDEOGRAPH NIGHT
2F24      ; [.8086.0020.0004] # KANGXI RADICAL BIG
337D      ; [.8086.0020.001C][.8288.0020.001C] # SQUARE ERA NAME TAISYOU
319D      ; [.8130.0020.0014] # IDEOGRAPHIC ANNOTATION HEAVEN MARK
1F217     ; [.8130.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5929
2F25      ; [.8088.0020.0004] # KANGXI RADICAL WOMAN
329B      ; [.8088.0020.0006] # CIRCLED IDEOGRAPH FEMALE
2F26      ; [.8089.0020.0004] # KANGXI RADICAL CHILD
1F211     ; [.83E8.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5B57
32AB      ; [.8A8D.0020.0006] # CIRCLED IDEOGRAPH STUDY
2F27      ; [.808D.0020.0004] # KANGXI RADICAL ROOF
32AA      ; [.8A94.0020.0006] # CIRCLED IDEOGRAPH RELIGION
2F28      ; [.808E.0020.0004] # KANGXI RADICAL INCH
2F29      ; [.8091.0020.0004] # KANGXI RADICAL SMALL
2F2A      ; [.8092.0020.0004] # KANGXI RADICAL LAME
2F2B      ; [.8095.0020.0004] # KANGXI RADICAL CORPSE
2F2C      ; [.8096.0020.0004] # KANGXI RADICAL SPROUT
2F2D      ; [.8097.0020.0004] # KANGXI RADICAL MOUNTAIN
2F2E      ; [.8098.0020.0004] # KANGXI RADICAL RIVER
2F2F      ; [.809B.0020.0004] # KANGXI RADICAL WORK
32A7      ; [.8256.0020.0006] # CIRCLED IDEOGRAPH LEFT
1F22C     ; [.8256.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5DE6
2F30      ; [.809C.0020.0004] # KANGXI RADICAL ONESELF
2F31      ; [.809F.0020.0004] # KANGXI RADICAL TURBAN
2F32      ; [.80A0.0020.0004] # KANGXI RADICAL DRY
337B      ; [.825F.0020.001C][.8435.0020.001C] # SQUARE ERA NAME HEISEI
2F33      ; [.80A2.0020.0004] # KANGXI RADICAL SHORT THREAD
3245      ; [.8260.0020.0006] # CIRCLED IDEOGRAPH KINDERGARTEN
2F34      ; [.80A3.0020.0004] # KANGXI RADICAL DOTTED CLIFF
2F35      ; [.80A4.0020.0004] # KANGXI RADICAL LONG STRIDE
2F36      ; [.80A5.0020.0004] # KANGXI RADICAL TWO HANDS
2F37      ; [.80A6.0020.0004] # KANGXI RADICAL SHOOT
2F38      ; [.80A7.0020.0004] # KANGXI RADICAL BOW
2F39      ; [.80A9.0020.0004] # KANGXI RADICAL SNOUT
2F3A      ; [.80AB.0020.0004] # KANGXI RADICAL BRISTLE
2F3B      ; [.80AC.0020.0004] # KANGXI RADICAL STEP
1F21D     ; [.9050.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5F8C
1F250     ; [.9E0E.0020.0006] # CIRCLED IDEOGRAPH ADVANTAGE
2F3C      ; [.8149.0020.0004] # KANGXI RADICAL HEART
2F3D      ; [.814B.0020.0004] # KANGXI RADICAL HALBERD
2F3E      ; [.814C.0020.0004] # KANGXI RADICAL DOOR
2F3F      ; [.814F.0020.0004] # KANGXI RADICAL HAND
1F210     ; [.814F.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-624B
1F231     ; [.8277.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6253
1F227     ; [.873A.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6295
1F22F     ; [.90B6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6307
1F228     ; [.9724.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6355
2F40      ; [.8152.0020.0004] # KANGXI RADICAL BRANCH
2F41      ; [.8153.0020.0004] # KANGXI RADICAL RAP
2F42      ; [.8155.0020.0004] # KANGXI RADICAL SCRIPT
3246      ; [.8155.0020.0006] # CIRCLED IDEOGRAPH SCHOOL
2F43      ; [.8156.0020.0004] # KANGXI RADICAL DIPPER
1F21B     ; [.9745.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6599
2F44      ; [.8157.0020.0004] # KANGXI RADICAL AXE
1F21F     ; [.AE69.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-65B0
2F45      ; [.8158.0020.0004] # KANGXI RADICAL SQUARE
2F46      ; [.8159.0020.0004] # KANGXI RADICAL NOT
2F47      ; [.815C.0020.0004] # KANGXI RADICAL SUN
3290      ; [.815C.0020.0006] # CIRCLED IDEOGRAPH SUN
337E      ; [.8BBF.0020.001C][.8C54.0020.001C] # SQUARE ERA NAME MEIZI
1F219     ; [.90F3.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6620
337C      ; [.9100.0020.001C][.89E5.0020.001C] # SQUARE ERA NAME SYOUWA
2F48      ; [.815D.0020.0004] # KANGXI RADICAL SAY
2F49      ; [.815F.0020.0004] # KANGXI RADICAL MOON
328A      ; [.815F.0020.0006] # CIRCLED IDEOGRAPH MOON
1F237     ; [.815F.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6708
3292      ; [.845A.0020.0006] # CIRCLED IDEOGRAPH HAVE
1F236     ; [.845A.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6709
2F4A      ; [.8160.0020.0004] # KANGXI RADICAL TREE
328D      ; [.8160.0020.0006] # CIRCLED IDEOGRAPH WOOD
3291      ; [.979F.0020.0006] # CIRCLED IDEOGRAPH STOCK
337F      ; [.979F.0020.001C][.841D.0020.001C][.8335.0020.001C][.8D2E.0020.001C] # SQUARE CORPORATION
2F4B      ; [.8163.0020.0004] # KANGXI RADICAL LACK
2F4C      ; [.8164.0020.0004] # KANGXI RADICAL STOP
32A3      ; [.8288.0020.0006] # CIRCLED IDEOGRAPH CORRECT
2F4D      ; [.8165.0020.0004] # KANGXI RADICAL DEATH
2F4E      ; [.8166.0020.0004] # KANGXI RADICAL WEAPON
2F4F      ; [.8167.0020.0004] # KANGXI RADICAL DO NOT
2E9F      ; [.828A.0020.0004] # CJK RADICAL MOTHER
2F50      ; [.8169.0020.0004] # KANGXI RADICAL COMPARE
2F51      ; [.816A.0020.0004] # KANGXI RADICAL FUR
2F52      ; [.816B.0020.0004] # KANGXI RADICAL CLAN
2F53      ; [.816C.0020.0004] # KANGXI RADICAL STEAM
2F54      ; [.816D.0020.0004] # KANGXI RADICAL WATER
328C      ; [.816D.0020.0006] # CIRCLED IDEOGRAPH WATER
329F      ; [.8C7F.0020.0006] # CIRCLED IDEOGRAPH ATTENTION
1F235     ; [.A7C6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6E80
1F226     ; [.B6D2.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6F14
2F55      ; [.816E.0020.0004] # KANGXI RADICAL FIRE
328B      ; [.816E.0020.0006] # CIRCLED IDEOGRAPH FIRE
1F21A     ; [.A7EB.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7121
2F56      ; [.8171.0020.0004] # KANGXI RADICAL CLAW
2F57      ; [.8173.0020.0004] # KANGXI RADICAL FATHER
2F58      ; [.8174.0020.0004] # KANGXI RADICAL DOUBLE X
2F59      ; [.8176.0020.0004] # KANGXI RADICAL HALF TREE TRUNK
2F5A      ; [.8177.0020.0004] # KANGXI RADICAL SLICE
2F5B      ; [.8179.0020.0004] # KANGXI RADICAL FANG
2F5C      ; [.817B.0020.0004] # KANGXI RADICAL COW
3295      ; [.9895.0020.0006] # CIRCLED IDEOGRAPH SPECIAL
2F5D      ; [.817D.0020.0004] # KANGXI RADICAL DOG
2F5E      ; [.82A2.0020.0004] # KANGXI RADICAL PROFOUND
2F5F      ; [.82A3.0020.0004] # KANGXI RADICAL JADE
2F60      ; [.82A7.0020.0004] # KANGXI RADICAL MELON
2F61      ; [.82A8.0020.0004] # KANGXI RADICAL TILE
2F62      ; [.82A9.0020.0004] # KANGXI RADICAL SWEET
2F63      ; [.82AA.0020.0004] # KANGXI RADICAL LIFE
1F222     ; [.82AA.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-751F
2F64      ; [.82AB.0020.0004] # KANGXI RADICAL USE
2F65      ; [.82AD.0020.0004] # KANGXI RADICAL FIELD
3199      ; [.82AF.0020.0014] # IDEOGRAPHIC ANNOTATION FIRST MARK
1F238     ; [.82B0.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7533
329A      ; [.8815.0020.0006] # CIRCLED IDEOGRAPH MALE
2F66      ; [.82B4.0020.0004] # KANGXI RADICAL BOLT OF CLOTH
2F67      ; [.82B6.0020.0004] # KANGXI RADICAL SICKNESS
2F68      ; [.82B7.0020.0004] # KANGXI RADICAL DOTTED TENT
2F69      ; [.82B8.0020.0004] # KANGXI RADICAL WHITE
2F6A      ; [.82B9.0020.0004] # KANGXI RADICAL SKIN
2F6B      ; [.82BA.0020.0004] # KANGXI RADICAL DISH
32AC      ; [.B79A.0020.0006] # CIRCLED IDEOGRAPH SUPERVISE
2F6C      ; [.82BB.0020.0004] # KANGXI RADICAL EYE
2F6D      ; [.82BC.0020.0004] # KANGXI RADICAL SPEAR
2F6E      ; [.82BD.0020.0004] # KANGXI RADICAL ARROW
2F6F      ; [.82BE.0020.0004] # KANGXI RADICAL STONE
2F70      ; [.82C0.0020.0004] # KANGXI RADICAL SPIRIT
3293      ; [.8D2E.0020.0006] # CIRCLED IDEOGRAPH SOCIETY
3297      ; [.9970.0020.0006] # CIRCLED IDEOGRAPH CONGRATULATION
1F232     ; [.B0A6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7981
2F71      ; [.82C1.0020.0004] # KANGXI RADICAL TRACK
2F72      ; [.82C2.0020.0004] # KANGXI RADICAL GRAIN
3299      ; [.9977.0020.0006] # CIRCLED IDEOGRAPH SECRET
2F73      ; [.82C3.0020.0004] # KANGXI RADICAL CAVE
1F233     ; [.8D3E.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7A7A
2F74      ; [.82C4.0020.0004] # KANGXI RADICAL STAND
2F75      ; [.84B5.0020.0004] # KANGXI RADICAL BAMBOO
3247      ; [.B822.0020.0006] # CIRCLED IDEOGRAPH KOTO
2F76      ; [.84B6.0020.0004] # KANGXI RADICAL RICE
2F77      ; [.84B7.0020.0004] # KANGXI RADICAL SILK
1F221     ; [.A172.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7D42
2F78      ; [.84C4.0020.0004] # KANGXI RADICAL JAR
2F79      ; [.84C5.0020.0004] # KANGXI RADICAL NET
2F7A      ; [.84C7.0020.0004] # KANGXI RADICAL SHEEP
2F7B      ; [.84CA.0020.0004] # KANGXI RADICAL FEATHER
2F7C      ; [.84CB.0020.0004] # KANGXI RADICAL OLD
2F7D      ; [.84CD.0020.0004] # KANGXI RADICAL AND
2F7E      ; [.84CE.0020.0004] # KANGXI RADICAL PLOW
2F7F      ; [.84CF.0020.0004] # KANGXI RADICAL EAR
2F80      ; [.84D0.0020.0004] # KANGXI RADICAL BRUSH
2F81      ; [.84D2.0020.0004] # KANGXI RADICAL MEAT
2F82      ; [.84D7.0020.0004] # KANGXI RADICAL MINISTER
2F83      ; [.84D8.0020.0004] # KANGXI RADICAL SELF
2F84      ; [.84D9.0020.0004] # KANGXI RADICAL ARRIVE
2F85      ; [.84DA.0020.0004] # KANGXI RADICAL MORTAR
2F86      ; [.84DC.0020.0004] # KANGXI RADICAL TONGUE
2F87      ; [.84DD.0020.0004] # KANGXI RADICAL OPPOSE
2F88      ; [.84DE.0020.0004] # KANGXI RADICAL BOAT
2F89      ; [.84DF.0020.0004] # KANGXI RADICAL STOPPING
2F8A      ; [.84E0.0020.0004] # KANGXI RADICAL COLOR
2F8B      ; [.84E1.0020.0004] # KANGXI RADICAL GRASS
2F8C      ; [.84EA.0020.0004] # KANGXI RADICAL TIGER
2F8D      ; [.84EB.0020.0004] # KANGXI RADICAL INSECT
2F8E      ; [.84EC.0020.0004] # KANGXI RADICAL BLOOD
2F8F      ; [.84ED.0020.0004] # KANGXI RADICAL WALK ENCLOSURE
2F90      ; [.84EE.0020.0004] # KANGXI RADICAL CLOTHES
2F91      ; [.84EF.0020.0004] # KANGXI RADICAL WEST
2F92      ; [.8878.0020.0004] # KANGXI RADICAL SEE
2F93      ; [.887B.0020.0004] # KANGXI RADICAL HORN
1F216     ; [.B258.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-89E3
2F94      ; [.887D.0020.0004] # KANGXI RADICAL SPEECH
2F95      ; [.8891.0020.0004] # KANGXI RADICAL VALLEY
2F96      ; [.8892.0020.0004] # KANGXI RADICAL BEAN
2F97      ; [.8893.0020.0004] # KANGXI RADICAL PIG
2F98      ; [.8894.0020.0004] # KANGXI RADICAL BADGER
2F99      ; [.8895.0020.0004] # KANGXI RADICAL SHELL
3296      ; [.9B3B.0020.0006] # CIRCLED IDEOGRAPH FINANCIAL
1F223     ; [.A2FD.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-8CA9
32AE      ; [.B2A5.0020.0006] # CIRCLED IDEOGRAPH RESOURCE
2F9A      ; [.8898.0020.0004] # KANGXI RADICAL RED
2F9B      ; [.8899.0020.0004] # KANGXI RADICAL RUN
1F230     ; [.8899.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-8D70
2F9C      ; [.889B.0020.0004] # KANGXI RADICAL FOOT
2F9D      ; [.889C.0020.0004] # KANGXI RADICAL BODY
2F9E      ; [.889D.0020.0004] # KANGXI RADICAL CART
2F9F      ; [.88A1.0020.0004] # KANGXI RADICAL BITTER
2FA0      ; [.88A2.0020.0004] # KANGXI RADICAL MORNING
2FA1      ; [.88A3.0020.0004] # KANGXI RADICAL WALK
1F22B     ; [.B30B.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-904A
329C      ; [.C10A.0020.0006] # CIRCLED IDEOGRAPH SUITABLE
2FA2      ; [.88B4.0020.0004] # KANGXI RADICAL CITY
2FA3      ; [.88C5.0020.0004] # KANGXI RADICAL WINE
2FA4      ; [.88C6.0020.0004] # KANGXI RADICAL DISTINGUISH
2FA5      ; [.88C7.0020.0004] # KANGXI RADICAL VILLAGE
2FA6      ; [.8E33.0020.0004] # KANGXI RADICAL GOLD
328E      ; [.8E33.0020.0006] # CIRCLED IDEOGRAPH METAL
2FA7      ; [.8E40.0020.0004] # KANGXI RADICAL LONG
2FA8      ; [.8E42.0020.0004] # KANGXI RADICAL GATE
2FA9      ; [.8E45.0020.0004] # KANGXI RADICAL MOUND
2FAA      ; [.8E59.0020.0004] # KANGXI RADICAL SLAVE
2FAB      ; [.8E5A.0020.0004] # KANGXI RADICAL SHORT TAILED BIRD
2FAC      ; [.8E5C.0020.0004] # KANGXI RADICAL RAIN
2FAD      ; [.8E5D.0020.0004] # KANGXI RADICAL BLUE
2FAE      ; [.8E5F.0020.0004] # KANGXI RADICAL WRONG
2FAF      ; [.949C.0020.0004] # KANGXI RADICAL FACE
2FB0      ; [.949D.0020.0004] # KANGXI RADICAL LEATHER
2FB1      ; [.949E.0020.0004] # KANGXI RADICAL TANNED LEATHER
2FB2      ; [.94A0.0020.0004] # KANGXI RADICAL LEEK
2FB3      ; [.94A1.0020.0004] # KANGXI RADICAL SOUND
2FB4      ; [.94A2.0020.0004] # KANGXI RADICAL LEAF
32A0      ; [.AC44.0020.0006] # CIRCLED IDEOGRAPH ITEM
2FB5      ; [.94A7.0020.0004] # KANGXI RADICAL WIND
2FB6      ; [.94AB.0020.0004] # KANGXI RADICAL FLY
2FB7      ; [.94AD.0020.0004] # KANGXI RADICAL EAT
2FB8      ; [.94B7.0020.0004] # KANGXI RADICAL HEAD
2FB9      ; [.94B9.0020.0004] # KANGXI RADICAL FRAGRANT
2FBA      ; [.9BF9.0020.0004] # KANGXI RADICAL HORSE
2FBB      ; [.9C00.0020.0004] # KANGXI RADICAL BONE
2FBC      ; [.9C01.0020.0004] # KANGXI RADICAL TALL
2FBD      ; [.9C02.0020.0004] # KANGXI RADICAL HAIR
2FBE      ; [.9C03.0020.0004] # KANGXI RADICAL FIGHT
2FBF      ; [.9C04.0020.0004] # KANGXI RADICAL SACRIFICIAL WINE
2FC0      ; [.9C05.0020.0004] # KANGXI RADICAL CAULDRON
2FC1      ; [.9C06.0020.0004] # KANGXI RADICAL GHOST
2FC2      ; [.A408.0020.0004] # KANGXI RADICAL FISH
2FC3      ; [.A40A.0020.0004] # KANGXI RADICAL BIRD
2FC4      ; [.A414.0020.0004] # KANGXI RADICAL SALT
2FC5      ; [.A415.0020.0004] # KANGXI RADICAL DEER
2FC6      ; [.A416.0020.0004] # KANGXI RADICAL WHEAT
2FC7      ; [.A418.0020.0004] # KANGXI RADICAL HEMP
2FC8      ; [.AC78.0020.0004] # KANGXI RADICAL YELLOW
2FC9      ; [.AC7A.0020.0004] # KANGXI RADICAL MILLET
2FCA      ; [.AC7B.0020.0004] # KANGXI RADICAL BLACK
2FCB      ; [.AC7C.0020.0004] # KANGXI RADICAL EMBROIDERY
2FCC      ; [.B440.0020.0004] # KANGXI RADICAL FROG
2FCD      ; [.B442.0020.0004] # KANGXI RADICAL TRIPOD
2FCE      ; [.B443.0020.0004] # KANGXI RADICAL DRUM
2FCF      ; [.B445.0020.0004] # KANGXI RADICAL RAT
2FD0      ; [.BB56.0020.0004] # KANGXI RADICAL NOSE
2FD1      ; [.BB57.0020.0004] # KANGXI RADICAL EVEN
2FD2      ; [.C273.0020.0004] # KANGXI RADICAL TOOTH
2FD3      ; [.C85E.0020.0004] # KANGXI RADICAL DRAGON
2FD4      ; [.C85F.0020.0004] # KANGXI RADICAL TURTLE
2EF3      ; [.88F9.0020.0004] # CJK RADICAL C-SIMPLIFIED TURTLE
2FD5      ; [.CD3C.0020.0004] # KANGXI RADICAL FLUTE
F967      ; [.80BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.88FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.852F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.805D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.80CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
2F800     ; [.852D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F800
2F802     ; [.8006.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F802
F91B      ; [.AC80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.8028.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.8E86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.80DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
2F819     ; [.80E8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F819
F9A8      ; [.81C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
2F804     ; [.856D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F804
FA73      ; [.8928.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA73
F92D      ; [.892E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.8933.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.8E8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.8E8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.8E98.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.8E9C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.94E6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.950F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F808     ; [.9C54.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F808
2F809     ; [.A43E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.B44E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.B459.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.B466.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.B466.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.8070.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.81D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.8578.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.8578.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.895B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80F
2F810     ; [.D692.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F810
2F814     ; [.80F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.8350.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.895F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.80F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.8961.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.C28C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.8356.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.8ED4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.9C63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.80FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.9535.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.81DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
FA71      ; [.8582.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA71
2F81B     ; [.8582.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81B
F92E      ; [.8584.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.953F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.9542.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.BB7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.C28F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81D     ; [.8037.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.8075.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.8107.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.8107.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.836E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.8598.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.897C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.897D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F821     ; [.8986.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F821
2F822     ; [.A45F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.ACB4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.BB84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.803C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.8373.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
2F992     ; [.85A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F992
FA76      ; [.8EF2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.8EF2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.8EF4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.8EF4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.9C76.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.A466.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.ACC2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.ACC2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.C879.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.8078.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.8078.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.81F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.81F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.81F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.81F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.9C89.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.81F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.899A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.899A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.A46C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.85B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.85B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.8F00.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.9569.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.9569.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.9569.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.9C93.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.8126.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.9570.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.820E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.8214.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.821A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
2F83B     ; [.8396.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83B
F9DE      ; [.839F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.85C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.85E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.85EA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.85F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.89C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F83C     ; [.8F0F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83C
2F840     ; [.8F13.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.8F2E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F841     ; [.9589.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F841
2F842     ; [.95A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.9CC4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
FA79      ; [.9CC6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA79
2F844     ; [.9CD2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.A485.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.A485.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.A488.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.A499.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.A499.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.A49D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.A49D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.A4AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
2F849     ; [.A4B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F849
FA0D      ; [.ACD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0D
2F84A     ; [.ACDA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84A
FA7B      ; [.ACF9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.B4AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.B4AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
2F84E     ; [.B4CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84E
FA38      ; [.C2AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.BBCD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.8A04.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.B4DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F84D     ; [.B4DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84D
2F855     ; [.8F63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.8F8E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.9D1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F854     ; [.9D37.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F854
2F857     ; [.A4EB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
2F856     ; [.95F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F856
FA39      ; [.A4F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.AD39.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.AD39.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.AD3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.C26D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
2F858     ; [.BBE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F858
FA7D      ; [.BBEE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.CD66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.D106.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F851     ; [.83C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F851
2F85A     ; [.864B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85A
2F85B     ; [.9D44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85B
2F85C     ; [.864D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.83C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.B513.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.8A41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.8A45.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.8F99.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.8A4B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.9D4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.8088.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F865     ; [.8FA7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F865
2F862     ; [.960A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.961C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.9628.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.9D80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.9D84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.AD61.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.BC16.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.C2FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.D110.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.D110.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.83EC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.9DA6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.AD8F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.B554.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.B554.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.B554.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.BC2E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F870     ; [.D116.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F870
2F872     ; [.868E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F872
2F873     ; [.8FE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F873
2F875     ; [.8092.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.8695.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.9DB7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.B558.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.BC33.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.BC34.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.8096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.8096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F878
2F87A     ; [.86B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87A
2F879     ; [.8AD0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.9DCB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
2F87C     ; [.A589.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87C
F921      ; [.A595.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
2F87F     ; [.A5A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87F
2F87E     ; [.ADAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87E
2F880     ; [.B563.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F880
2F9F4     ; [.C30C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F4
F9AB      ; [.C8D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.88A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.9DE6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.A5AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.9681.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.A5AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
2F887     ; [.BC5D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F887
F98E      ; [.8414.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.9036.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88B     ; [.9038.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88B
2F88C     ; [.9DF7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.9DFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.ADC4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.A5C1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.A5C1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA82      ; [.B587.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA82
FA0B      ; [.B588.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
FA83      ; [.B58E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA83
F982      ; [.D123.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
2F890     ; [.80A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.86D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.8AF8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.8AF8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F874     ; [.8423.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F874
2F899     ; [.86D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.9E0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.9E0B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.904F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
2F89C     ; [.A5CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89C
F966      ; [.A5D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.ADD2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.86E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.86E9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.8B15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
2F89F     ; [.8702.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89F
F960      ; [.9054.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.8B2D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
FA6B      ; [.96BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6B
2F8A0     ; [.96C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.96D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.96D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.9E43.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.9E4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.A5E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.ADDF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.ADFC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.B5A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.AE01.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.AE01.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.AE03.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.AE03.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA8A      ; [.B5B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.A614.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.B5C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.BC8F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.BC8F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.BC8F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.BC91.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.BC9F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.BCA7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.C332.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.C8EF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.D12A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.D12A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.D12A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.D12C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.D12C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.D9A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.8435.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.9E66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.BCAF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.C8FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B4     ; [.843C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B4
2F8B5     ; [.8B64.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.8B7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.9096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.8B85.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.8B86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
2F8BA     ; [.90AC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BA
F973      ; [.90AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.970C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.971F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.9E77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.9E8A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.9E92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.9EAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.9EB5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.A62A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
2F8C0     ; [.AE5E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C0
2F8BD     ; [.9737.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BD
FA8E      ; [.AE2E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.AE34.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
FA8F      ; [.A667.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8F
2F8C3     ; [.BCB3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
2F8C6     ; [.B603.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C6
2F8C4     ; [.B609.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C4
F991      ; [.BCCE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.BCD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.C35E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.9ED2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.9ED2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.9ED9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.AE62.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.BCF5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.9745.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.974C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.90EA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA42
2F8CB     ; [.9EF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.8BC4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.9758.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.A69D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.A69D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.AE80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.A6AC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.A6AC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
2F8D5     ; [.B627.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D5
FA06      ; [.BD0D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.C39E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.875D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.976A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.A454.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.9773.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.9773.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.9773.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.9F11.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.9F11.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
2F8DA     ; [.AE99.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DA
F9E1      ; [.876E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.8773.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.8776.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.877E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.8BEC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
2F8E0     ; [.8BF5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E0
F9F4      ; [.8C07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.9164.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
2F8DF     ; [.9169.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DF
F9DA      ; [.978C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
2F8E5     ; [.9794.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E5
2F8E1     ; [.9181.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E1
F97A      ; [.9F37.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.9F3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.9F3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
2F8E4     ; [.9F44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E4
F9E2      ; [.9F5E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E6     ; [.A716.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E6
2F8E8     ; [.AEAF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8E9     ; [.B650.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E9
2F8EA     ; [.BD23.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.BD3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.BD3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.BD3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.BD4B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
2F8EB     ; [.C959.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EB
F931      ; [.D157.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.C962.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.D6D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.846F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.C403.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.AF0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.C40A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
FA95      ; [.8165.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA95
2F8F4     ; [.B6A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F4
F9A5      ; [.C969.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.9F8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.9F8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.9F8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8F6     ; [.9F8C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F6
2F8FA     ; [.847F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
2F8FE     ; [.879D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FE
F972      ; [.87BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.8C58.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.8C64.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
2F8FD     ; [.8C65.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FD
F9E3      ; [.8C7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
2F8FF     ; [.980A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FF
F915      ; [.91C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.91C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F907     ; [.91D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F907
2F900     ; [.91E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.91E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.91E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.91E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.981E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.981F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.982C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.982C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.982D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.983A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.9FBA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.9FC9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.9FD9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.9FE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.A004.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.A777.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.A7B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.AF31.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.AF4F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
2F90C     ; [.AF5C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90C
FA99      ; [.A7D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.A7D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.AF63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
FA98      ; [.AF6B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA98
F94E      ; [.B6CF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.B6E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.B6E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.B6E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.BDAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.BDE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.C98A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.CDED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.D17C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.D17F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.D17F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F913     ; [.D488.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F913
2F917     ; [.D6DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F917
2F835     ; [.8497.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F919     ; [.87E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F919
2F918     ; [.87E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.8CB0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.920A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.9864.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.9875.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
2F91C     ; [.AF89.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91C
F993      ; [.AF8D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.A80B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.A80B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
2F91E     ; [.BDE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91E
F9C0      ; [.C477.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.C479.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.D496.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.D6E6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.DC4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA49      ; [.8172.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA49
FA9E      ; [.C9BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.C9BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
2F922     ; [.AFC5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F922
F946      ; [.87ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.A81A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
2F925     ; [.B745.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F925
FA9F      ; [.82A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.8CCA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.98A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.A066.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.A066.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.CE18.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.D1A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.A067.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.A067.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.817E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
2F92B     ; [.8CEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92B
F9AD      ; [.924C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.98BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.A07D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.98D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.A852.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92E     ; [.AFF3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92E
2F92F     ; [.B008.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.BE24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.B763.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.B763.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
2F931     ; [.BE35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F931
F994      ; [.BE39.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.C4A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.D1B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
FAA2      ; [.B77A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA2
2F934     ; [.A882.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F934
FAA3      ; [.8D01.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA3
2F936     ; [.8D03.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F936
F9CD      ; [.98E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.A09D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.A0A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.A0A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.A8A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.B047.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA4      ; [.BE59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA4
FAA5      ; [.BE52.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.C9EA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.D6F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.990E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.990E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.A0BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.C4E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.8D1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.8D1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.92B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.9928.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
2F946     ; [.9929.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.9929.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAAA      ; [.A0D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
FAA9      ; [.A8C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA9
2F948     ; [.A8C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F948
2F94A     ; [.BE77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
FA9D      ; [.CA05.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9D
2F94E     ; [.A0E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94E
F9CE      ; [.A8DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.B08B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.B08B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.B090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.BE90.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
FAAB      ; [.BE92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAB
2F950     ; [.BE92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F950
F964      ; [.CA26.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.D4C9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA18      ; [.84B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA18
FA4C      ; [.8D2E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.92EC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.92ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.9963.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.9969.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.9969.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.9970.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.9971.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.A0F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.B0A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.B7DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.B7DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.B7DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.B7DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.CE6D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.8D3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.998A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.B0BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.BEBC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.BEBC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
2F95A     ; [.B7F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95A
2F95B     ; [.C523.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95B
FA55      ; [.930C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
FAAC      ; [.BEC4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAC
F9F7      ; [.82C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
2F95F     ; [.B805.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95F
F9F8      ; [.A12C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.B101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.B101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.BEEF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.C53D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.D1F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.D8B1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
FAAE      ; [.9327.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAE
F9F9      ; [.A14C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.B84B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
2F966     ; [.C563.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F966
FA03      ; [.C567.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
2F969     ; [.CE97.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F969
F97B      ; [.CE9B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F968     ; [.CA8C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F968
2F96A     ; [.9332.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.99CE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.99E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.A15F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.B111.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.A95F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.B85B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.B879.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.B882.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.BF35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.BF35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.BF35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
2F96F     ; [.BF43.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96F
FA58      ; [.C56B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.CA9B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.CAA5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.CAA9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.A98D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.B149.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.C591.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
2F976     ; [.C592.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F976
F90F      ; [.D220.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
2F978     ; [.A19D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F978
F9AF      ; [.A19E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.84CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.CEC9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.84CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.8D66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.8D66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.8D66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.A1BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
2F97D     ; [.A9A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97D
F997      ; [.CAC6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.CAC7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.D8C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.84D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.8D78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.8D7D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F983     ; [.9A39.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F983
2F985     ; [.A9B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.D22E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.CAE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.9A4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.9A50.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.9A50.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
2F98C     ; [.A9E2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98C
FA6D      ; [.C5C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6D
F97C      ; [.885F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
FA5D      ; [.80B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5D
FA5E      ; [.80B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5E
2F990     ; [.8868.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F98F     ; [.886E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98F
2F991     ; [.8D9B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.8DAF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.8DB1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.8DBA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.93A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.93A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.93A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.A1FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.A1FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.9A84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.9A9C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F9A0     ; [.9ABD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A0
2F99A     ; [.9AAB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99A
2F99B     ; [.A24D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99B
2F99D     ; [.A249.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.A9FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.A9FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.AA00.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.AA0F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
2F99E     ; [.AA1A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99E
FAB4      ; [.AA22.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.AA24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.B1A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.B1B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.AA5A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.AA5A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.BF9A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.B208.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
2F9A9     ; [.BF9E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A9
F9C2      ; [.BFA7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AA     ; [.BFC0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AA
2F9AC     ; [.C5F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.CF09.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.D510.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.D51C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
FA20      ; [.D52F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA20
F91F      ; [.D73C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.D9F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.93DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.B20A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.B20A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.CB2D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B6     ; [.CF14.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B6
2F9B8     ; [.AA6B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B8
2F9B7     ; [.9AE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BA     ; [.AA7D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BA
2F9B9     ; [.B227.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B9
2F9BC     ; [.B95E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
2F9BD     ; [.B981.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BD
FAB5      ; [.C612.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB5
2F9BB     ; [.C612.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BB
2F9BE     ; [.C617.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BE
F911      ; [.CB41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
2F9C0     ; [.C027.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C0
2F9C1     ; [.D264.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C1
F927      ; [.D748.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.84ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C3     ; [.C63E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C3
2F9C4     ; [.84EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.AAAA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.B239.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
2F9C6     ; [.AAB2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C6
2F9C7     ; [.B247.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C7
F9E8      ; [.B24A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.B995.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
2F9C9     ; [.B997.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C9
FA60      ; [.C03D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.CB6A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.D53F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.CF49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.8878.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.A103.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.A103.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.B289.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.B9C9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.B9C9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.C06A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.C076.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.C07D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.C081.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.C671.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.C671.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.C08B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.C08B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.C681.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.C681.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.C684.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.C684.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.CF67.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.CF67.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.D2AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.D8E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.DA06.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.DA06.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.9B36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.8893.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.A2FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.AB15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.B2A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.B2A6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.B9E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.D2BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.D2BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.DADB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.9B4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DB     ; [.B2C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DB
2F9DA     ; [.AB38.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.B2D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
2F9DC     ; [.B2D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DC
F902      ; [.889D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
2F9DE     ; [.9B5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DE
F998      ; [.C0FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.C0FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.C6C7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.C6C7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.C6CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.D8FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
2F98D     ; [.B2F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98D
F971      ; [.88A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
FA66      ; [.818F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA66
F99A      ; [.A353.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.AB86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.AB86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.C6D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.C6DE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.DA18.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
2F9E2     ; [.850D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E2
F92C      ; [.945D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92C
FA2E      ; [.9B86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
2F9E3     ; [.9465.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E3
FA26      ; [.A369.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
2F9E4     ; [.B321.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E4
2F9E6     ; [.BA32.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E6
F919      ; [.B32C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
FAC4      ; [.CBE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC4
F9B7      ; [.D582.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.88C7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.ABA9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.8E33.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.B33B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.B33F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
FAC5      ; [.BA52.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC5
2F9EA     ; [.BA91.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.C154.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
2F9E9     ; [.C155.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E9
F93F      ; [.C705.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.CBF2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EB     ; [.D330.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EB
2F9EC     ; [.D5A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EC
2F9EE     ; [.ABFD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.C18F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
2F9F0     ; [.CC4C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F0
F9C6      ; [.88DE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.948F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.9491.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.A3DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.A3E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.A3E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.AC1A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.C19A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.C776.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.CC60.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
2F9F3     ; [.AC28.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F3
F9EA      ; [.D014.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.D345.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.D345.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.B3BD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.B3BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.D017.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.D7AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.DAFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.B3C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.B3C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
FAC9      ; [.D5DE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC9
2F9FA     ; [.D5DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.D5E2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.D5E2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
FACB      ; [.B3D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACB
2F9FE     ; [.B3D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FE
2F9FF     ; [.B3D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FF
F9B4      ; [.BAE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
2FA00     ; [.C1C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA00
FA6A      ; [.C7A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.C7A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.D369.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.9BF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.AC59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.B3F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.C7C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
2FA04     ; [.C7C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA04
2FA05     ; [.D37A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA05
2FA06     ; [.BB13.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA06
F91A      ; [.C7DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
2FA07     ; [.CCB3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA07
F987      ; [.DC56.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.D619.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.D619.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.C225.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
2FA0B     ; [.D645.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0B
F9F2      ; [.DA5D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
2FA0C     ; [.C247.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0C
2FA0F     ; [.CD1A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0F
FA2D      ; [.D80D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.DB1F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.DC69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.A415.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.D407.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.DA80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.A418.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.C26C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.AC7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA18     ; [.8E79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA18
2FA19     ; [.D834.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA19
2FA1A     ; [.C26F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1A
2FA1B     ; [.D0DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1B
2FA1C     ; [.BB56.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
FAD8      ; [.DA8C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD8
F9C4      ; [.C85E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.D0E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.C85F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.C85F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.C85F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
2F81F     ; [.858A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81F
2F888     ; [.C311.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F888
2F8D0     ; [.AE77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D0
2F8CE     ; [.C38A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CE
2F8DE     ; [.8BD3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DE
2F8EE     ; [.D879.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EE
2F90A     ; [.AF20.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90A
2F92C     ; [.98A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92C
2F92D     ; [.98A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92D
FAD4      ; [.A8B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD4
2F949     ; [.A8B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F949
2F960     ; [.B808.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F960
2F96D     ; [.BF14.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96D
2F8D7     ; [.8D6B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D7
2FA0E     ; [.D64A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0E
2F8F9     ; [.B6A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F9
FA6C      ; [.AFBE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6C
2F93C     ; [.D6F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93C
ENTRY
};
