#
#  USAGE: perl -MTest::Harness -e "runtests('class.t')"
#
#  Test of \p{ .. }, \P{ .. }, etc.
#
#  This script uses ShiftJIS::String.
#
my $HARNESS = 0; # true

use ShiftJIS::String qw(mkrange);
use ShiftJIS::Regexp qw(re match);

my $time = time;

my $n  = 0;
my @NG;

my %char = (
 n => [ "\n" ],
 r => [ "\r", "\t", "\f" ],
 s => [ ' '  ],
 S => [ '@' ],
 b => [ "\x7F" ],
 c => [ mkrange("\x00-\x08\x0b\x0e-\x1F") ],
 p => [ mkrange('!-/:-@[-^`{-~') ],
 q => [ '_' ],
 d => [ mkrange("0-9") ],
 0 => [ mkrange("A-F") ],
 1 => [ mkrange("a-f") ],
 u => [ mkrange("G-Z") ],
 l => [ mkrange("g-z") ],
 D => [ mkrange('O-X') ],
 U => [ mkrange('`-y') ],
 L => [ mkrange('-') ],
 G => [ mkrange('-') ],
 Q => [ mkrange('-') ],
 C => [ mkrange('@-`') ],
 R => [ mkrange('p-') ],
 H => [ mkrange('-JKTU') ],
 K => [ mkrange('@-[RS')   ],
 h => [ mkrange('-') ],
 k => [ mkrange('-') ],
 J => [ mkrange('-r') ],
 Z => [ mkrange('-') ],
 Y => [ mkrange('V-Z') ],
 P => [ mkrange('A-IL-Q\---΁--') ],
 B => [ mkrange('-') ],
 X => [ mkrange("\x81\xAD-\x81\xB7\x81\xC0-\x81\xC7\x81\xCF-\x81\xD9"
	.	"\x81\xE9-\x81\xEF\x81\xF8-\x81\xFB\x82\x40-\x82\x4E"
	.	"\x82\x59-\x82\x5F\x82\x7A-\x82\x80\x82\x9B-\x82\x9E"
	.	"\x82\xF2-\x82\xFC\x83\x97-\x83\x9E\x83\xB7-\x83\xBE"
	.	"\x83\xD7-\x83\xFC\x84\x61-\x84\x6F\x84\x92-\x84\x9E"
	.	"\x84\xBF-\x86\xFC\x88\x40-\x88\x9E\x98\x73-\x98\x9E"
	.	"\xEA\xA5-\xEC\xFC") ],
);

sub sp { grep /\w/, split '', shift }

my @cls =		   sp q(nrsSbc-pqd01ulDUL-GQCRHKhk-JZYPB-X);
my %res = (
 '\j'			=>[sp q(111111-1111111111-11111111-11111-1)],
 '[\0-\x{fcfc}]'	=>[sp q(111111-1111111111-11111111-11111-1)],
 '.'			=>[sp q(011111-1111111111-11111111-11111-1)],
 '\J'			=>[sp q(011111-1111111111-11111111-11111-1)],
 '[^\n]'		=>[sp q(011111-1111111111-11111111-11111-1)],
 '\d'			=>[sp q(000000-0010000000-00000000-00000-0)],
 '[\d]'			=>[sp q(000000-0010000000-00000000-00000-0)],
 '\D'			=>[sp q(111111-1101111111-11111111-11111-1)],
 '[\D]'			=>[sp q(111111-1101111111-11111111-11111-1)],
 '\w'			=>[sp q(000000-0111111000-00000000-00000-0)],
 '[\w]'			=>[sp q(000000-0111111000-00000000-00000-0)],
 '\W'			=>[sp q(111111-1000000111-11111111-11111-1)],
 '[\W]'			=>[sp q(111111-1000000111-11111111-11111-1)],
 '\s'			=>[sp q(111000-0000000000-00000000-00000-0)],
 '[\s]'			=>[sp q(111000-0000000000-00000000-00000-0)],
 '\S'			=>[sp q(000111-1111111111-11111111-11111-1)],
 '[\S]'			=>[sp q(000111-1111111111-11111111-11111-1)],

 '\p{Xdigit}'		=>[sp q(000000-0011100000-00000000-00000-0)],
 '[[:xdigit:]]'		=>[sp q(000000-0011100000-00000000-00000-0)],
 '\pX'			=>[sp q(000000-0011100000-00000000-00000-0)],
 '\P^X'			=>[sp q(000000-0011100000-00000000-00000-0)],
 '[0-9A-Fa-f]'		=>[sp q(000000-0011100000-00000000-00000-0)],
 '\P{Xdigit}'		=>[sp q(111111-1100011111-11111111-11111-1)],
 '[[:^xdigit:]]'	=>[sp q(111111-1100011111-11111111-11111-1)],
 '\PX'			=>[sp q(111111-1100011111-11111111-11111-1)],
 '\p^X'			=>[sp q(111111-1100011111-11111111-11111-1)],
 '[^0-9A-Fa-f]'		=>[sp q(111111-1100011111-11111111-11111-1)],

 '\p{Digit}'		=>[sp q(000000-0010000100-00000000-00000-0)],
 '[[:digit:]]'		=>[sp q(000000-0010000100-00000000-00000-0)],
 '[^[:^digit:]]'	=>[sp q(000000-0010000100-00000000-00000-0)],
 '[0-9O-X]'		=>[sp q(000000-0010000100-00000000-00000-0)],
 '\P{Digit}'		=>[sp q(111111-1101111011-11111111-11111-1)],
 '[[:^digit:]]'		=>[sp q(111111-1101111011-11111111-11111-1)],
 '[^[:digit:]]'		=>[sp q(111111-1101111011-11111111-11111-1)],
 '[^0-9O-X]'		=>[sp q(111111-1101111011-11111111-11111-1)],
 '\p{Upper}'		=>[sp q(000000-0001010010-00000000-00000-0)],
 '[[:upper:]]'		=>[sp q(000000-0001010010-00000000-00000-0)],
 '[^[:^upper:]]'	=>[sp q(000000-0001010010-00000000-00000-0)],
 '[A-Z`-y]'		=>[sp q(000000-0001010010-00000000-00000-0)],
 '\P{Upper}'		=>[sp q(111111-1110101101-11111111-11111-1)],
 '[[:^upper:]]'		=>[sp q(111111-1110101101-11111111-11111-1)],
 '[^[:upper:]]'		=>[sp q(111111-1110101101-11111111-11111-1)],
 '[^A-Z`-y]'		=>[sp q(111111-1110101101-11111111-11111-1)],
 '\p{Lower}'		=>[sp q(000000-0000101001-00000000-00000-0)],
 '[[:lower:]]'		=>[sp q(000000-0000101001-00000000-00000-0)],
 '[^[:^lower:]]'	=>[sp q(000000-0000101001-00000000-00000-0)],
 '[a-z-]'		=>[sp q(000000-0000101001-00000000-00000-0)],
 '\P{Lower}'		=>[sp q(111111-1111010110-11111111-11111-1)],
 '[[:^lower:]]'		=>[sp q(111111-1111010110-11111111-11111-1)],
 '[^[:lower:]]'		=>[sp q(111111-1111010110-11111111-11111-1)],
 '[^a-z-]'		=>[sp q(111111-1111010110-11111111-11111-1)],
 '(?i)[A-Z`-y]'	=>[sp q(000000-0001111010-00000000-00000-0)],
 '(?i)[^A-Z`-y]'	=>[sp q(111111-1110000101-11111111-11111-1)],
 '(?i)[a-z-]'	=>[sp q(000000-0001111001-00000000-00000-0)],
 '(?i)[^a-z-]'	=>[sp q(111111-1110000110-11111111-11111-1)],
 '\p{Alpha}'		=>[sp q(000000-0001111011-00000000-00000-0)],
 '[[:alpha:]]'		=>[sp q(000000-0001111011-00000000-00000-0)],
 '[^[:^alpha:]]'	=>[sp q(000000-0001111011-00000000-00000-0)],
 '\P{Alpha}'		=>[sp q(111111-1110000100-11111111-11111-1)],
 '[[:^alpha:]]'		=>[sp q(111111-1110000100-11111111-11111-1)],
 '[^[:alpha:]]'		=>[sp q(111111-1110000100-11111111-11111-1)],
 '[\p{Alpha}\p{Digit}]' =>[sp q(000000-0011111111-00000000-00000-0)],
 '\p{Alnum}'		=>[sp q(000000-0011111111-00000000-00000-0)],
 '[[:alnum:]]'		=>[sp q(000000-0011111111-00000000-00000-0)],
 '[^[:^alnum:]]'	=>[sp q(000000-0011111111-00000000-00000-0)],
 '[^\p{Alpha}\p{Digit}]'=>[sp q(111111-1100000000-11111111-11111-1)],
 '\P{Alnum}'		=>[sp q(111111-1100000000-11111111-11111-1)],
 '[[:^alnum:]]'		=>[sp q(111111-1100000000-11111111-11111-1)],
 '[^[:alnum:]]'		=>[sp q(111111-1100000000-11111111-11111-1)],
 '\p{Word}'		=>[sp q(000000-0111111111-11111101-11100-0)],
 '[[:word:]]'		=>[sp q(000000-0111111111-11111101-11100-0)],
 '[^[:^word:]]'		=>[sp q(000000-0111111111-11111101-11100-0)],
 '\P{Word}'		=>[sp q(111111-1000000000-00000010-00011-1)],
 '[[:^word:]]' 		=>[sp q(111111-1000000000-00000010-00011-1)],
 '[^[:word:]]'		=>[sp q(111111-1000000000-00000010-00011-1)],
 '\p{Punct}'		=>[sp q(000000-1100000000-00000010-00011-0)],
 '[[:punct:]]'		=>[sp q(000000-1100000000-00000010-00011-0)],
 '[^[:^punct:]]'	=>[sp q(000000-1100000000-00000010-00011-0)],
 '\P{Punct}'		=>[sp q(111111-0011111111-11111101-11100-1)],
 '[[:^punct:]]'		=>[sp q(111111-0011111111-11111101-11100-1)],
 '[^[:punct:]]'		=>[sp q(111111-0011111111-11111101-11100-1)],
 '\p{Space}'		=>[sp q(111100-0000000000-00000000-00000-0)],
 '[[:space:]]'		=>[sp q(111100-0000000000-00000000-00000-0)],
 '[^[:^space:]]'	=>[sp q(111100-0000000000-00000000-00000-0)],
 '[\s\x{8140}]'		=>[sp q(111100-0000000000-00000000-00000-0)],
 '\P{Space}'		=>[sp q(000011-1111111111-11111111-11111-1)],
 '[[:^space:]]'		=>[sp q(000011-1111111111-11111111-11111-1)],
 '[^[:space:]]'		=>[sp q(000011-1111111111-11111111-11111-1)],
 '[^\s\x{8140}]'	=>[sp q(000011-1111111111-11111111-11111-1)],
 '\p{Graph}'		=>[sp q(000000-1111111111-11111111-11111-1)],
 '[[:graph:]]'		=>[sp q(000000-1111111111-11111111-11111-1)],
 '[^[:^graph:]]'	=>[sp q(000000-1111111111-11111111-11111-1)],
 '\P{Graph}'		=>[sp q(111111-0000000000-00000000-00000-0)],
 '[[:^graph:]]'		=>[sp q(111111-0000000000-00000000-00000-0)],
 '[^[:graph:]]'		=>[sp q(111111-0000000000-00000000-00000-0)],
 '\p{Print}'		=>[sp q(111100-1111111111-11111111-11111-1)],
 '[[:print:]]'		=>[sp q(111100-1111111111-11111111-11111-1)],
 '[^[:^print:]]'	=>[sp q(111100-1111111111-11111111-11111-1)],
 '\P{Print}'		=>[sp q(000011-0000000000-00000000-00000-0)],
 '[[:^print:]]'		=>[sp q(000011-0000000000-00000000-00000-0)],
 '[^[:print:]]'		=>[sp q(000011-0000000000-00000000-00000-0)],
 '\p{Cntrl}'		=>[sp q(110001-0000000000-00000000-00000-0)],
 '[[:cntrl:]]'		=>[sp q(110001-0000000000-00000000-00000-0)],
 '[^[:^cntrl:]]'	=>[sp q(110001-0000000000-00000000-00000-0)],
 '\P{Cntrl}'		=>[sp q(001110-1111111111-11111111-11111-1)],
 '[[:^cntrl:]]'		=>[sp q(001110-1111111111-11111111-11111-1)],
 '[^[:cntrl:]]'		=>[sp q(001110-1111111111-11111111-11111-1)],

 '\p{ASCII}'		=>[sp q(111011-1111111000-00000000-00000-0)],
 '[[:ascii:]]'		=>[sp q(111011-1111111000-00000000-00000-0)],
 '[^[:^ascii:]]'	=>[sp q(111011-1111111000-00000000-00000-0)],
 '[\0-\c?]'		=>[sp q(111011-1111111000-00000000-00000-0)],
 '\P{ASCII}'		=>[sp q(000100-0000000111-11111111-11111-1)],
 '[[:^ascii:]]'		=>[sp q(000100-0000000111-11111111-11111-1)],
 '[^[:ascii:]]'		=>[sp q(000100-0000000111-11111111-11111-1)],
 '[^\0-\c?]'		=>[sp q(000100-0000000111-11111111-11111-1)],
 '\p{Roman}'		=>[sp q(111011-1111111000-00000000-00000-0)],
 '[[:roman:]]'		=>[sp q(111011-1111111000-00000000-00000-0)],
 '\pR'			=>[sp q(111011-1111111000-00000000-00000-0)],
 '[\pR]'		=>[sp q(111011-1111111000-00000000-00000-0)],
 '\P{Roman}'		=>[sp q(000100-0000000111-11111111-11111-1)],
 '[[:^roman:]]'		=>[sp q(000100-0000000111-11111111-11111-1)],
 '\PR'			=>[sp q(000100-0000000111-11111111-11111-1)],
 '\p^R'			=>[sp q(000100-0000000111-11111111-11111-1)],
 '\p{Hankaku}'		=>[sp q(000000-0000000000-00000011-00000-0)],
 '[[:hankaku:]]'	=>[sp q(000000-0000000000-00000011-00000-0)],
 '[^[:^hankaku:]]'	=>[sp q(000000-0000000000-00000011-00000-0)],
 '[\xA1-\xDF]'		=>[sp q(000000-0000000000-00000011-00000-0)],
 '\P{Hankaku}'		=>[sp q(111111-1111111111-11111100-11111-1)],
 '[[:^hankaku:]]'	=>[sp q(111111-1111111111-11111100-11111-1)],
 '[^[:hankaku:]]'	=>[sp q(111111-1111111111-11111100-11111-1)],
 '[^\xa1-\xdf]'		=>[sp q(111111-1111111111-11111100-11111-1)],
 '\p{Zenkaku}'		=>[sp q(000100-0000000111-11111100-11111-1)],
 '[[:zenkaku:]]'	=>[sp q(000100-0000000111-11111100-11111-1)],
 '[^[:^zenkaku:]]'	=>[sp q(000100-0000000111-11111100-11111-1)],
 '\P{Zenkaku}'		=>[sp q(111011-1111111000-00000011-00000-0)],
 '[[:^zenkaku:]]'	=>[sp q(111011-1111111000-00000011-00000-0)],
 '[^[:zenkaku:]]'	=>[sp q(111011-1111111000-00000011-00000-0)],

 '\p{Latin}'		=>[sp q(000000-0001111000-00000000-00000-0)],
 '[[:latin:]]'		=>[sp q(000000-0001111000-00000000-00000-0)],
 '[^[:^latin:]]'	=>[sp q(000000-0001111000-00000000-00000-0)],
 '[A-Za-z]'		=>[sp q(000000-0001111000-00000000-00000-0)],
 '\P{Latin}'		=>[sp q(111111-1110000111-11111111-11111-1)],
 '[[:^latin:]]'		=>[sp q(111111-1110000111-11111111-11111-1)],
 '[^[:latin:]]'		=>[sp q(111111-1110000111-11111111-11111-1)],
 '[^A-Za-z]'		=>[sp q(111111-1110000111-11111111-11111-1)],
 '\p{FullLatin}'	=>[sp q(000000-0000000011-00000000-00000-0)],
 '[[:fulllatin:]]'	=>[sp q(000000-0000000011-00000000-00000-0)],
 '[^[:^fulllatin:]]'	=>[sp q(000000-0000000011-00000000-00000-0)],
 '[`-y-]'		=>[sp q(000000-0000000011-00000000-00000-0)],
 '\P{FullLatin}'	=>[sp q(111111-1111111100-11111111-11111-1)],
 '[[:^fulllatin:]]'	=>[sp q(111111-1111111100-11111111-11111-1)],
 '[^[:fulllatin:]]'	=>[sp q(111111-1111111100-11111111-11111-1)],
 '[^`-y-]'	=>[sp q(111111-1111111100-11111111-11111-1)],
 '\p{Greek}'		=>[sp q(000000-0000000000-11000000-00000-0)],
 '[[:greek:]]'		=>[sp q(000000-0000000000-11000000-00000-0)],
 '[^[:^greek:]]'	=>[sp q(000000-0000000000-11000000-00000-0)],
 '[--]'		=>[sp q(000000-0000000000-11000000-00000-0)],
 '(?I)[-]'		=>[sp q(000000-0000000000-11000000-00000-0)],
 '[-]'		=>[sp q(000000-0000000000-10000000-00000-0)],
 '[-]'		=>[sp q(000000-0000000000-01000000-00000-0)],
 '\P{Greek}'		=>[sp q(111111-1111111111-00111111-11111-1)],
 '[[:^greek:]]'		=>[sp q(111111-1111111111-00111111-11111-1)],
 '[^[:greek:]]'		=>[sp q(111111-1111111111-00111111-11111-1)],
 '[^--]'	=>[sp q(111111-1111111111-00111111-11111-1)],
 '(?I)[^-]'		=>[sp q(111111-1111111111-00111111-11111-1)],
 '\p{Cyrillic}'		=>[sp q(000000-0000000000-00110000-00000-0)],
 '[[:cyrillic:]]'	=>[sp q(000000-0000000000-00110000-00000-0)],
 '[^[:^cyrillic:]]'	=>[sp q(000000-0000000000-00110000-00000-0)],
 '[@-`p-]'		=>[sp q(000000-0000000000-00110000-00000-0)],
 '(?I)[@-`]'		=>[sp q(000000-0000000000-00110000-00000-0)],
 '[@-`]'		=>[sp q(000000-0000000000-00100000-00000-0)],
 '[p-]'		=>[sp q(000000-0000000000-00010000-00000-0)],
 '\P{Cyrillic}'		=>[sp q(111111-1111111111-11001111-11111-1)],
 '[[:^cyrillic:]]'	=>[sp q(111111-1111111111-11001111-11111-1)],
 '[^[:cyrillic:]]'	=>[sp q(111111-1111111111-11001111-11111-1)],
 '[^@-`p-]'	=>[sp q(111111-1111111111-11001111-11111-1)],

 '\p{HalfKana}'		=>[sp q(000000-0000000000-00000001-00000-0)],
 '[[:halfkana:]]'	=>[sp q(000000-0000000000-00000001-00000-0)],
 '[^[:^halfkana:]]'	=>[sp q(000000-0000000000-00000001-00000-0)],
 '[\xA6-\xDF]'		=>[sp q(000000-0000000000-00000001-00000-0)],
 '\P{HalfKana}'		=>[sp q(111111-1111111111-11111110-11111-1)],
 '[[:^halfkana:]]'	=>[sp q(111111-1111111111-11111110-11111-1)],
 '[^[:halfkana:]]'	=>[sp q(111111-1111111111-11111110-11111-1)],
 '[^\xA6-\xDF]'		=>[sp q(111111-1111111111-11111110-11111-1)],
 '\p{Hiragana}'		=>[sp q(000000-0000000000-00001000-00000-0)],
 '[[:hiragana:]]'	=>[sp q(000000-0000000000-00001000-00000-0)],
 '[^[:^hiragana:]]'	=>[sp q(000000-0000000000-00001000-00000-0)],
 '[-JKTU]'	=>[sp q(000000-0000000000-00001000-00000-0)],
 '\P{Hiragana}'		=>[sp q(111111-1111111111-11110111-11111-1)],
 '[[:^hiragana:]]'	=>[sp q(111111-1111111111-11110111-11111-1)],
 '[^[:hiragana:]]'	=>[sp q(111111-1111111111-11110111-11111-1)],
 '[^-JKTU]'	=>[sp q(111111-1111111111-11110111-11111-1)],
 '\p{Katakana}'		=>[sp q(000000-0000000000-00000100-00000-0)],
 '[[:katakana:]]'	=>[sp q(000000-0000000000-00000100-00000-0)],
 '[^[:^katakana:]]'	=>[sp q(000000-0000000000-00000100-00000-0)],
 '[@-[RS]'	=>[sp q(000000-0000000000-00000100-00000-0)],
 '\P{Katakana}'		=>[sp q(111111-1111111111-11111011-11111-1)],
 '[[:^katakana:]]'	=>[sp q(111111-1111111111-11111011-11111-1)],
 '[^[:katakana:]]'	=>[sp q(111111-1111111111-11111011-11111-1)],
 '[^@-[RS]'	=>[sp q(111111-1111111111-11111011-11111-1)],
 '\p{FullKana}'		=>[sp q(000000-0000000000-00001100-00000-0)],
 '[[:fullkana:]]'	=>[sp q(000000-0000000000-00001100-00000-0)],
 '[^[:^fullkana:]]'	=>[sp q(000000-0000000000-00001100-00000-0)],
 '\P{FullKana}'		=>[sp q(111111-1111111111-11110011-11111-1)],
 '[[:^fullkana:]]'	=>[sp q(111111-1111111111-11110011-11111-1)],
 '[^[:fullkana:]]'	=>[sp q(111111-1111111111-11110011-11111-1)],
 '\p{Kana}'		=>[sp q(000000-0000000000-00001101-00000-0)],
 '[[:kana:]]'		=>[sp q(000000-0000000000-00001101-00000-0)],
 '[^[:^kana:]]'		=>[sp q(000000-0000000000-00001101-00000-0)],
 '\P{Kana}'		=>[sp q(111111-1111111111-11110010-11111-1)],
 '[[:^kana:]]'		=>[sp q(111111-1111111111-11110010-11111-1)],
 '[^[:kana:]]'		=>[sp q(111111-1111111111-11110010-11111-1)],
 '\p{Kanji1}'		=>[sp q(000000-0000000000-00000000-10000-0)],
 '[[:kanji1:]]'		=>[sp q(000000-0000000000-00000000-10000-0)],
 '[^[:^kanji1:]]'	=>[sp q(000000-0000000000-00000000-10000-0)],
 '[-r]'		=>[sp q(000000-0000000000-00000000-10000-0)],
 '\P{Kanji1}'		=>[sp q(111111-1111111111-11111111-01111-1)],
 '[[:^kanji1:]]'	=>[sp q(111111-1111111111-11111111-01111-1)],
 '[^[:kanji1:]]'	=>[sp q(111111-1111111111-11111111-01111-1)],
 '[^-r]'		=>[sp q(111111-1111111111-11111111-01111-1)],
 '\p{Kanji2}'		=>[sp q(000000-0000000000-00000000-01000-0)],
 '[[:kanji2:]]'		=>[sp q(000000-0000000000-00000000-01000-0)],
 '[^[:^kanji2:]]'	=>[sp q(000000-0000000000-00000000-01000-0)],
 '[-]'		=>[sp q(000000-0000000000-00000000-01000-0)],
 '\P{Kanji2}'		=>[sp q(111111-1111111111-11111111-10111-1)],
 '[[:^kanji2:]]'	=>[sp q(111111-1111111111-11111111-10111-1)],
 '[^[:kanji2:]]'	=>[sp q(111111-1111111111-11111111-10111-1)],
 '[^-]'		=>[sp q(111111-1111111111-11111111-10111-1)],
 '\p{Kanji}'		=>[sp q(000000-0000000000-00000000-11100-0)],
 '[[:kanji:]]'		=>[sp q(000000-0000000000-00000000-11100-0)],
 '[^[:^kanji:]]'	=>[sp q(000000-0000000000-00000000-11100-0)],
 '\P{Kanji}'		=>[sp q(111111-1111111111-11111111-00011-1)],
 '[[:^kanji:]]'		=>[sp q(111111-1111111111-11111111-00011-1)],
 '[^[:kanji:]]'		=>[sp q(111111-1111111111-11111111-00011-1)],
 '[V-Z]'		=>[sp q(000000-0000000000-00000000-00100-0)],
 '[^V-Z]'		=>[sp q(111111-1111111111-11111111-11011-1)],
 '\p{BoxDrawing}'	=>[sp q(000000-0000000000-00000000-00001-0)],
 '[[:boxdrawing:]]'	=>[sp q(000000-0000000000-00000000-00001-0)],
 '[^[:^boxdrawing:]]'	=>[sp q(000000-0000000000-00000000-00001-0)],
 '\P{BoxDrawing}'	=>[sp q(111111-1111111111-11111111-11110-1)],
 '[[:^boxdrawing:]]'	=>[sp q(111111-1111111111-11111111-11110-1)],
 '[^[:boxdrawing:]]'	=>[sp q(111111-1111111111-11111111-11110-1)],
);

printf "1..%d\n", keys(%res) * keys(%char);

my($mod,$OK,$r,$cl);
for $r (sort keys %res){
  print "$r\n" unless $HARNESS;

  my $re = "^$r\$";
  for $cl (0..$#cls){
    my $match = grep(match($_, $re, 'o'), @{ $char{ $cls[ $cl ] } });
    my $a = $match == @{ $char{ $cls[ $cl ] } } ? 1 : $match == 0 ? 0 : -1;

    my $msg = $a == $res{ $r }[$cl] ? "ok" : "not ok";
    ++$n;

    print "$msg $n\n";

    push @NG, "$n$r $cls[ $cl ]\n" if $msg ne 'ok';
  }
}

unless($HARNESS){
  printf "version: $]\ntime: %d\n", time - $time;
  print ! @NG
    ? "All tests successful.\n"
    : "Failed ".scalar(@NG).", tests.\n", @NG;
}

__END__
