/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jmx4perl.Config;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.LogHandler;
import org.jmx4perl.backend.LocalRequestDispatcher;
import org.jmx4perl.backend.RequestDispatcher;
import org.jmx4perl.config.DebugStore;
import org.jmx4perl.config.Restrictor;
import org.jmx4perl.config.RestrictorFactory;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.converter.json.ObjectToJsonConverter;
import org.jmx4perl.history.HistoryStore;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendManager {
    private LocalRequestDispatcher localDispatcher;
    private ObjectToJsonConverter objectToJsonConverter;
    private Restrictor restrictor;
    private HistoryStore historyStore;
    private DebugStore debugStore;
    private ObjectName configMBeanName;
    private LogHandler logHandler;
    private List<RequestDispatcher> requestDispatchers;

    public BackendManager(Map<Config, String> pConfig, LogHandler pLogHandler) {
        StringToObjectConverter stringToObjectConverter = new StringToObjectConverter();
        this.objectToJsonConverter = new ObjectToJsonConverter(stringToObjectConverter, pConfig);
        this.restrictor = RestrictorFactory.buildRestrictor();
        this.logHandler = pLogHandler;
        this.localDispatcher = new LocalRequestDispatcher(this.objectToJsonConverter, stringToObjectConverter, this.restrictor);
        this.requestDispatchers = this.createRequestDispatchers(Config.DISPATCHER_CLASSES.getValue(pConfig), this.objectToJsonConverter, stringToObjectConverter, this.restrictor);
        this.requestDispatchers.add(this.localDispatcher);
        this.initStores(pConfig);
        this.registerOwnMBeans();
    }

    private List<RequestDispatcher> createRequestDispatchers(String pClasses, ObjectToJsonConverter pObjectToJsonConverter, StringToObjectConverter pStringToObjectConverter, Restrictor pRestrictor) {
        String[] names;
        ArrayList<RequestDispatcher> ret = new ArrayList<RequestDispatcher>();
        if (pClasses == null || pClasses.length() == 0) {
            return ret;
        }
        for (String name : names = pClasses.split("\\s*,\\s*")) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(name);
                Constructor<?> constructor = clazz.getConstructor(ObjectToJsonConverter.class, StringToObjectConverter.class, Restrictor.class);
                RequestDispatcher dispatcher = (RequestDispatcher)constructor.newInstance(pObjectToJsonConverter, pStringToObjectConverter, pRestrictor);
                ret.add(dispatcher);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Couldn't load class " + name + ": " + e, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Class " + name + " has invalid constructor: " + e, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Constructor of " + name + " couldn't be accessed: " + e, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(name + " couldn't be instantiated: " + e, e);
            }
        }
        return ret;
    }

    public JSONObject handleRequest(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        boolean debug = this.isDebug() && !"debugInfo".equals(pJmxReq.getOperation());
        Object retValue = null;
        boolean found = false;
        for (RequestDispatcher dispatcher : this.requestDispatchers) {
            if (!dispatcher.canHandle(pJmxReq)) continue;
            long time = 0L;
            if (debug) {
                time = System.currentTimeMillis();
            }
            retValue = dispatcher.dispatchRequest(pJmxReq);
            if (debug) {
                this.debug("Execution time: " + (System.currentTimeMillis() - time) + " ms");
            }
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Internal error: No dispatcher found for handling " + pJmxReq);
        }
        JSONObject json = this.objectToJsonConverter.convertToJson(retValue, pJmxReq);
        this.historyStore.updateAndAdd(pJmxReq, json);
        if (debug) {
            this.debug("Response: " + json);
        }
        json.put((Object)"status", (Object)200);
        if (debug) {
            this.debug("Success");
        }
        return json;
    }

    private void initStores(Map<Config, String> pConfig) {
        int maxDebugEntries;
        int maxEntries;
        try {
            maxEntries = Integer.parseInt(Config.HISTORY_MAX_ENTRIES.getValue(pConfig));
        }
        catch (NumberFormatException exp) {
            maxEntries = Integer.parseInt(Config.HISTORY_MAX_ENTRIES.getDefaultValue());
        }
        String doDebug = Config.DEBUG.getValue(pConfig);
        boolean debug = false;
        if (doDebug != null && Boolean.valueOf(doDebug).booleanValue()) {
            debug = true;
        }
        try {
            maxDebugEntries = Integer.parseInt(Config.DEBUG_MAX_ENTRIES.getValue(pConfig));
        }
        catch (NumberFormatException exp) {
            maxDebugEntries = Integer.parseInt(Config.DEBUG_MAX_ENTRIES.getDefaultValue());
        }
        this.historyStore = new HistoryStore(maxEntries);
        this.debugStore = new DebugStore(maxDebugEntries, debug);
    }

    private void registerOwnMBeans() {
        try {
            this.configMBeanName = this.localDispatcher.registerConfigMBean(this.historyStore, this.debugStore);
        }
        catch (NotCompliantMBeanException e) {
            this.error("Error registering config MBean: " + e, e);
        }
        catch (MBeanRegistrationException e) {
            this.error("Cannot register MBean: " + e, e);
        }
        catch (MalformedObjectNameException e) {
            this.error("Invalid name for config MBean: " + e, e);
        }
        catch (InstanceAlreadyExistsException e) {
            this.error("Config MBean already exists: " + e, e);
        }
    }

    public void unregisterOwnMBeans() {
        if (this.configMBeanName != null) {
            try {
                this.localDispatcher.unregisterLocalMBean(this.configMBeanName);
            }
            catch (MalformedObjectNameException e) {
                this.error("Invalid name for config MBean: " + e, e);
            }
            catch (InstanceNotFoundException e) {
                this.error("No Mbean registered with name " + this.configMBeanName + ": " + e, e);
            }
            catch (MBeanRegistrationException e) {
                this.error("Cannot unregister MBean: " + e, e);
            }
        } else {
            this.error("Internal Problem: No ConfigMBean name !", null);
        }
    }

    public boolean isRemoteAccessAllowed(String pRemoteHost, String pRemoteAddr) {
        return this.restrictor.isRemoteAccessAllowed(pRemoteHost, pRemoteAddr);
    }

    public void info(String msg) {
        this.logHandler.info(msg);
        if (this.debugStore != null) {
            this.debugStore.log(msg);
        }
    }

    public void debug(String msg) {
        this.logHandler.debug(msg);
        if (this.debugStore != null) {
            this.debugStore.log(msg);
        }
    }

    public final void error(String message, Throwable t) {
        this.logHandler.error(message, t);
        if (this.debugStore != null) {
            this.debugStore.log(message, t);
        }
    }

    public boolean isDebug() {
        return this.debugStore != null && this.debugStore.isDebug();
    }

    public void setLogHandler(LogHandler pLogHandler) {
        this.logHandler = pLogHandler;
    }
}

