#!perl -T

use strict;
use Test::More tests => 480;

use Graphics::Framebuffer;

# We no longer test against the real framebuffer, due to testing mucking up the screen.
my $fb = Graphics::Framebuffer->new();
isa_ok($fb, 'Graphics::Framebuffer');

$fb->cls();

# This is slow because of the screen memory copies for this test.
foreach my $y (0..478) {
    my $oldscreen = "$fb->{'SCREEN'}"; # Make a copy of the screen
    $fb->set_color({'red' => rand(256),'green' => rand(256), 'blue' => rand(256)});
    $fb->plot({'x'=>$y,'y'=>$y,'pixel_size'=>1});
    my $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,"$y,$y Point was plotted");
}
