package MMS::Parser;
use version; our $VERSION = qv('0.1.0');
use MMS::Parser::WorkHorse;

sub create { return MMS::Parser::WorkHorse->new() }

1;    # Magic true value required at end of module
__END__

=head1 NAME

MMS::Parser - parsing facilities for binary MMS messages


=head1 VERSION

This document describes MMS::Parser version 0.0.1


=head1 SYNOPSIS

    use MMS::Parser;
    my $parser = MMS::Parser->create();
    my $message = get_data_from_anywhere():
    my $parsed = $parser->CONTENT($message);
    

=head1 DESCRIPTION

MMS::Parser provides parsing facilities for binary encoded MMS messages.


=head1 INTERFACE 

All the work is done by L<MMS::Parser::WorkHorse>, which in turn is
auto-generated by L<Parse::RecDescent>. To be honest, this module
isn't really needed at the moment, because it only contains the
C<create()> method that does nothing except that call
C<MMS::Parser::WorkHorse->new()>. Anyway, I think it's cleaner to
keep this front-end around, because I might need something more
in the future, and L<MMS::Parser::WorkHorse> will be always
auto-generated. For some values of "always".


=over

=item C<my $parser = MMS::Parser->create();>

Create a new parser for MMS.

=back

You'll be mostly interested in the C<MMS_MESSAGE()> method inside
the generated C<$parser>, which does all the decoding activites
giving a hash back. At any rate, peruse the grammar files to know
which subs you can actually use. More documentation will come with
time.


=head1 DIAGNOSTICS

Being entirely based on L<Parse::RecDescent>, you get all its
diagnostics. Whatever they are.


=head1 CONFIGURATION AND ENVIRONMENT

MMS::Parser requires no configuration files or environment variables.


=head1 DEPENDENCIES

This module depends only on L<version>, which can be considered a
I<de facto> standard module even if it's non-CORE (as of 5.8.8).

Anyway, it must be said that the generation (and in some cases
running) of the L<MMS::Parser::WorkHorse> module needs the following
modules:

=over

=item B<Parse::RecDescent>

=item B<Path::Class>

=item B<File::Slurp>

=back

=head1 INCOMPATIBILITIES

None reported or known.


=head1 BUGS AND LIMITATIONS

Error reporting should be more application-oriented.

No bugs have been reported.

Please report any bugs or feature requests through http://rt.cpan.org/

=head1 SEE ALSO

Open Mobile Alliance (L<http://www.openmobilealliance.org/>), the standard
body that rules over MMS.


=head1 AUTHOR

Flavio Poletti  C<< <flavio [at] polettix [dot] it> >>


=head1 LICENCE AND COPYRIGHT

Copyright (c) 2006, Flavio Poletti C<< <flavio [at] polettix [dot] it> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>
and L<perlgpl>.

Questo modulo  software libero: potete ridistribuirlo e/o
modificarlo negli stessi termini di Perl stesso. Vedete anche
L<perlartistic> e L<perlgpl>.


=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.

=head1 NEGAZIONE DELLA GARANZIA

Poich questo software viene dato con una licenza gratuita, non
c' alcuna garanzia associata ad esso, ai fini e per quanto permesso
dalle leggi applicabili. A meno di quanto possa essere specificato
altrove, il proprietario e detentore del copyright fornisce questo
software "cos com'" senza garanzia di alcun tipo, sia essa espressa
o implicita, includendo fra l'altro (senza per limitarsi a questo)
eventuali garanzie implicite di commerciabilit e adeguatezza per
uno scopo particolare. L'intero rischio riguardo alla qualit ed
alle prestazioni di questo software rimane a voi. Se il software
dovesse dimostrarsi difettoso, vi assumete tutte le responsabilit
ed i costi per tutti i necessari servizi, riparazioni o correzioni.

In nessun caso, a meno che ci non sia richiesto dalle leggi vigenti
o sia regolato da un accordo scritto, alcuno dei detentori del diritto
di copyright, o qualunque altra parte che possa modificare, o redistribuire
questo software cos come consentito dalla licenza di cui sopra, potr
essere considerato responsabile nei vostri confronti per danni, ivi
inclusi danni generali, speciali, incidentali o conseguenziali, derivanti
dall'utilizzo o dall'incapacit di utilizzo di questo software. Ci
include, a puro titolo di esempio e senza limitarsi ad essi, la perdita
di dati, l'alterazione involontaria o indesiderata di dati, le perdite
sostenute da voi o da terze parti o un fallimento del software ad
operare con un qualsivoglia altro software. Tale negazione di garanzia
rimane in essere anche se i dententori del copyright, o qualsiasi altra
parte,  stata avvisata della possibilit di tali danneggiamenti.

Se decidete di utilizzare questo software, lo fate a vostro rischio
e pericolo. Se pensate che i termini di questa negazione di garanzia
non si confacciano alle vostre esigenze, o al vostro modo di
considerare un software, o ancora al modo in cui avete sempre trattato
software di terze parti, non usatelo. Se lo usate, accettate espressamente
questa negazione di garanzia e la piena responsabilit per qualsiasi
tipo di danno, di qualsiasi natura, possa derivarne.

=cut
