package API::MailboxOrg::API::Test;

# ABSTRACT: MailboxOrg::API::Test

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int InstanceOf ArrayRef);
use API::MailboxOrg::Types qw(HashRefRestricted Boolean);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.1'; # VERSION

my %validators = (
    'accountallowed' => validation_for(
        params => {
            account => { type => Str, optional => 0 },

        },
    ),
    'domainallowed' => validation_for(
        params => {
            domain => { type => Str, optional => 0 },

        },
    ),

);


sub accountallowed ($self, %params) {
    my $validator = $validators{'accountallowed'};
    %params       = $validator->(%params) if $validator;

    my %opt = ();

    return $self->_request( 'test.accountallowed', \%params, \%opt );
}

sub domainallowed ($self, %params) {
    my $validator = $validators{'domainallowed'};
    %params       = $validator->(%params) if $validator;

    my %opt = ();

    return $self->_request( 'test.domainallowed', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Test - MailboxOrg::API::Test

=head1 VERSION

version 1.0.1

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 accountallowed

Confirms if the account can be administrated using the current ACLs

Parameters:

=over 4

=item * account

=back

returns: boolean

    $api->test->accountallowed(%params);

=head2 domainallowed

Confirms if the domain can be administrated using the current ACLs

Parameters:

=over 4

=item * domain

=back

returns: boolean

    $api->test->domainallowed(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
