/* YYY:SWIG_BUG
** The unconditionally-exception-raising setter method generated by the
** DEF_PROPERTY_RO macro is necessary because SWIG (1.3.21, at least) generates
** classes that invalidate their own read-only Python properties.  For example,
** if a Python class Klass that was generated by SWIG or that extends a SWIG-
** generated class contains the following definitions:
**
** class Klass(object):
**     ...
**     def _get_x(self):
**         return 33
**     x = property(_get_x)
**
** then the following code will erroneously NOT raise an exception:
**
** o = Klass()
** o.x = 50
**
** The attempt to set o.x should raise an AttributeError, but SWIG meddles
** with the Python attribute management system in such a way that it does not.
** The dummy setter method generated by the DEF_PROPERTY_RO "tricks" SWIG into
** implementing the "correct" behavior.
*/

%define DEF_PROPERTY_RO(
  className, propName, varType,
  generatedGetterFuncName, generatedSetterFuncName, methNameSuppress,
  shouldCreateGetter,
  ...
)
  /* All leftover arguments (represented by the ...) are placed in __VA_ARGS__.
  ** Currently, I allow the client to pass in arbitrary transformative code
  ** to be wrapped around the return of the "suppressed" method call. */

  /* In order to "trick" SWIG, we must *NOT* make the following declaration, */
  /* even though it is logical: */
  /*   %immutable className::propName; */
  %extend className {
    varType propName;
  };
  #if shouldCreateGetter
  %{
   static inline varType generatedGetterFuncName(className *o) {
     return __VA_ARGS__(o->methNameSuppress());
   }
  %}
  #endif

  %{
   static inline void generatedSetterFuncName(className *o, varType value) {
     PyErr_SetString(PyExc_AttributeError, "property is read-only");
     throw PythonExceptionAlreadySet();
   }
  %}
  %ignore className::methNameSuppress;
%enddef


%define DEF_PROPERTY_RW(
  className, propName, varType,
  generatedGetterFuncName, generatedSetterFuncName,
  suppressedGetterMethName, suppressedSetterMethName,
  ...
)
  /* All leftover arguments (represented by the ...) are placed in __VA_ARGS__.
  ** Currently, I allow the client to pass in arbitrary transformative code
  ** to be wrapped around the return of the "suppressed" method call. */

  %extend className {
    varType propName;
  };

  %{
   static inline varType generatedGetterFuncName(className *o) {
     return __VA_ARGS__(o->suppressedGetterMethName());
   }
  %}

  %{
   static inline void generatedSetterFuncName(className *o, varType value) {
     o->suppressedSetterMethName(value);
   }
  %}

  %ignore className::suppressedGetterMethName;
  %ignore className::suppressedSetterMethName;
%enddef
