use strict;

use Apache::Test qw(:withtestmore);
use Test::More;
use Apache::TestUtil;
use Apache::TestRequest 'GET_BODY';
use File::Spec;

{
  my $f;
  sub t_start_error_log_watch {
    my $name=File::Spec->catfile
      ( Apache::Test::vars->{serverroot},
	Apache::Test::config->{httpd_defines}->{DEFAULT_ERRORLOG} );
    open $f, "$name" or die "ERROR: Cannot open $name: $!\n";
    seek $f, 0, 2;
  }

  sub t_finish_error_log_watch {
    local $/="\n";
    my @lines=<$f>;
    undef $f;
    return @lines;
  }
}

plan tests => 32;

my (undef,undef,undef,undef,@ip)=gethostbyname "localhost";
my ($res, $session);

# 1. without <ClickPathMachineTable> no environment variables

Apache::TestRequest::module('default');

$res=GET_BODY( "/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=$/, 'ClickPathMachineName undefined without <ClickPathTable>' );

$res=GET_BODY( "/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'ClickPathMachineStore undefined without <ClickPathTable>' );


# 2. simple table without names and extra field

Apache::TestRequest::module('Without_UAExc');

$res=GET_BODY( "/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=1$/, 'autogenerated ClickPathMachineName' );

$res=GET_BODY( "/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'autogenerated ClickPathMachineStore not set' );

$res=GET_BODY( "/TestSession__001session_generation?INVALID_SESSION" );
ok t_cmp( $res, qr/^INVALID_SESSION=$/, 'INVALID_SESSION not set' );

$session=GET_BODY( "/TestSession__001session_generation?CGI_SESSION" );
$session=~s/^CGI_SESSION=//; chomp $session;
t_debug( "using session: $session" );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=1$/, 'autogenerated ClickPathMachineName w/ SESSION' );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'autogenerated ClickPathMachineStore w/ SESSION not set' );

$res=GET_BODY( "$session/TestSession__001session_generation?INVALID_SESSION" );
ok t_cmp( $res, qr/^INVALID_SESSION=$/, 'INVALID_SESSION not set w/ SESSION' );

$session=~s/-S:B:/-S:C:/;
t_debug( "using foreign session: $session" );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=2$/, 'autogenerated ClickPathMachineName w/ foreign SESSION' );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'autogenerated ClickPathMachineStore w/ foreign SESSION not set' );

$session=~s/-S:C:/-S:D:/;
t_debug( "using invalid session: $session" );

t_client_log_error_is_expected();
$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=1$/, 'autogenerated ClickPathMachineName w/ invalid SESSION' );

t_client_log_error_is_expected();
t_start_error_log_watch;
$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'autogenerated ClickPathMachineStore w/ invalid SESSION not set' );

ok t_cmp( (t_finish_error_log_watch())[0], qr/Caught invalid session: Unknown Machine name '3'/,
	  'check for correct error message in error_log' );

t_client_log_error_is_expected();
$res=GET_BODY( "$session/TestSession__001session_generation?INVALID_SESSION" );
$session=~s/^.+?://;
ok t_cmp( $res, qr/^INVALID_SESSION=\Q$session\E$/, 'INVALID_SESSION set' );


# 3. table with with name but without store

Apache::TestRequest::module('FriendlySession');

$res=GET_BODY( "/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=A$/, 'ClickPathMachineName is A' );

$res=GET_BODY( "/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'ClickPathMachineStore not set' );

$session=GET_BODY( "/TestSession__001session_generation?CGI_SESSION" );
$session=~s/^CGI_SESSION=//; chomp $session;
t_debug( "using session: $session" );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=A$/, 'ClickPathMachineName is A w/ SESSION' );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'ClickPathMachineStore not set w/ SESSION' );

$session=~s/-S:N:/-S:O:/;
t_debug( "using foreign session: $session" );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=B$/, 'ClickPathMachineName is B w/ foreign SESSION' );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'ClickPathMachineStore not set w/ foreign SESSION' );

$session=~s/-S:O:/-S:P:/;
t_debug( "using invalid session: $session" );

t_client_log_error_is_expected();
$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=A$/, 'ClickPathMachineName is A w/ invalid SESSION' );

t_client_log_error_is_expected();
t_start_error_log_watch;
$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr/^ClickPathMachineStore=$/, 'ClickPathMachineStore not set w/ invalid SESSION' );

ok t_cmp( (t_finish_error_log_watch())[0], qr/Caught invalid session: Unknown Machine name 'C'/,
	  'check for correct error message in error_log' );


# 3. fully qualified table

Apache::TestRequest::module('UAExceptionsFile');

$res=GET_BODY( "/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=A$/, 'ClickPathMachineName is A' );

$res=GET_BODY( "/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr!^ClickPathMachineStore=/store$!, 'ClickPathMachineStore is /store' );

$session=GET_BODY( "/TestSession__001session_generation?CGI_SESSION" );
$session=~s/^CGI_SESSION=//; chomp $session;
t_debug( "using session: $session" );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=A$/, 'ClickPathMachineName is A w/ SESSION' );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr!^ClickPathMachineStore=/store$!, 'ClickPathMachineStore is /store w/ SESSION' );

$session=~s/-S:N:/-S:O:/;
t_debug( "using foreign session: $session" );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=B$/, 'ClickPathMachineName is B w/ foreign SESSION' );

$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr!^ClickPathMachineStore=http://klaus:32810/store$!, 'ClickPathMachineStore is http://klaus:32810/store w/ foreign SESSION' );

$session=~s/-S:O:/-S:P:/;
t_debug( "using invalid session: $session" );

t_client_log_error_is_expected();
$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineName" );
ok t_cmp( $res, qr/^ClickPathMachineName=A$/, 'ClickPathMachineName is A w/ invalid SESSION' );

t_client_log_error_is_expected();
t_start_error_log_watch;
$res=GET_BODY( "$session/TestSession__001session_generation?ClickPathMachineStore" );
ok t_cmp( $res, qr!^ClickPathMachineStore=/store$!, 'ClickPathMachineStore is /store w/ invalid SESSION' );

ok t_cmp( (t_finish_error_log_watch())[0], qr/Caught invalid session: Unknown Machine name 'C'/,
	  'check for correct error message in error_log' );

# Local Variables: #
# mode: cperl #
# End: #
