BEGIN { $| = 1; print "1..2\n"; }
END {print "not ok 1\n" unless $loaded;}
use Chart::GnuPlot;
$loaded = 1;
print "ok 1\n";

#$ENV{'DEBUG'} = 1;

my( $record, $data );

&_data();

my $plots =	[
			{
				'title'		=> 'high/ low',
				'columns'	=> [ 1 .. 4 ],
				'type'		=> 'errorbars',
			},
			{
				'title'		=> 'price',
				'columns'	=> [ 1, 2 ],
				'type'		=> 'lines',
			},
		];


my $series_colour2 = '0000ff';
my $series_colour = '00ff00';

my $colours =	{
			'background'	=> 'ffffff',
			'foreground'	=> '000000',
			'series'	=> [ $series_colour, $series_colour2, $series_colour, $series_colour2 ],
		};

my $settings =	{
			'terminal'	=> 'gif',
			'size'		=> '750, 300',
			'grid'		=> 1,
			'data'		=> [ $data ],
			'plots'		=> $plots,
			'title'		=> 'Historical Price Information',
			'xtitle'	=> 'Date',
			'ytitle'	=> 'Value',
			'timefmt'	=> '%Y/%m/%d',
			'xformat'	=> '%d/%m/%y',
			'tl_label'	=> 'blah blah stocks',
			'tr_label'	=> '21/8/97',
			'br_label'	=> 'Blah Inc',
			'bl_label'	=> 'http://www.blah.com',
			'bl_label_font'	=> 'large',
			'xtitle_font'	=> 'large',
			'colours'	=> $colours,
			'ytics'		=> 50,
			'mytics'	=> 5,
		};

my $gp = Chart::GnuPlot -> new();

my( $image, $ext ) = $gp -> plot( $settings );

if ( $image ) {
	open( OUT, ">test.$ext" ) || die "can't open test.$ext";
	binmode OUT;
	print OUT $image;
	close OUT;
	print "ok 2\n";
	print "there should now be a test.$ext in this directory\n";
} else {
	print "not ok 2\n";
}

sub _data {
	$data = [
			[
				'1998/4/21',
				'987.500000',
				'989.500000',
				'955.000000'
			],
			[
				'1998/4/22',
				'990.000000',
				'1007.000000',
				'948.000000'
			],
			[
				'1998/4/23',
				'959.000000',
				'995.000000',
				'952.000000'
			],
			[
				'1998/4/24',
				'938.000000',
				'956.500000',
				'928.500000'
			],
			[
				'1998/4/27',
				'932.000000',
				'933.500000',
				'918.500000'
			],
			[
				'1998/4/28',
				'942.500000',
				'958.500000',
				'931.000000'
			],
			[
				'1998/4/29',
				'945.000000',
				'968.500000',
				'935.000000'
			],
			[
				'1998/4/30',
				'957.000000',
				'976.000000',
				'940.000000'
			],
			[
				'1998/5/1',
				'958.500000',
				'964.000000',
				'930.500000'
			],
			[
				'1998/5/4',
				'958.500000',
				'964.000000',
				'930.500000'
			],
			[
				'1998/5/5',
				'951.500000',
				'960.000000',
				'935.000000'
			],
			[
				'1998/5/6',
				'953.000000',
				'980.000000',
				'943.000000'
			],
			[
				'1998/5/7',
				'957.000000',
				'956.500000',
				'938.000000'
			],
			[
				'1998/5/8',
				'950.000000',
				'953.500000',
				'925.500000'
			],
			[
				'1998/5/11',
				'930.000000',
				'955.000000',
				'900.000000'
			],
			[
				'1998/5/12',
				'921.000000',
				'932.500000',
				'911.000000'
			],
			[
				'1998/5/13',
				'925.000000',
				'928.000000',
				'898.500000'
			],
			[
				'1998/5/14',
				'938.500000',
				'939.000000',
				'932.500000'
			],
			[
				'1998/5/17',
				'925.000000',
				'940.000000',
				'923.500000'
			],
			[
				'1998/5/18',
				'945.000000',
				'962.500000',
				'934.000000'
			],
			[
				'1998/5/19',
				'952.000000',
				'960.000000',
				'945.000000'
			],
			[
				'1998/5/21',
				'965.000000',
				'997.500000',
				'945.500000'
			],
			[
				'1998/5/22',
				'960.000000',
				'967.500000',
				'958.500000'
			],
			[
				'1998/5/26',
				'976.500000',
				'997.500000',
				'953.000000'
			],
			[
				'1998/5/27',
				'963.000000',
				'982.000000',
				'956.000000'
			],
			[
				'1998/5/28',
				'977.500000',
				'992.500000',
				'939.000000'
			],
			[
				'1998/5/29',
				'988.000000',
				'995.500000',
				'965.000000'
			],
			[
				'1998/6/1',
				'985.000000',
				'982.000000',
				'959.000000'
			],
			[
				'1998/6/2',
				'992.000000',
				'994.000000',
				'980.500000'
			],
			[
				'1998/6/3',
				'1015.000000',
				'1026.000000',
				'975.000000'
			],
			[
				'1998/6/4',
				'1024.500000',
				'1035.500000',
				'1002.500000'
			],
			[
				'1998/6/5',
				'1039.500000',
				'1060.500000',
				'1011.500000'
			],
			[
				'1998/6/8',
				'1045.000000',
				'1079.500000',
				'1022.000000'
			],
			[
				'1998/6/9',
				'998.500000',
				'1030.000000',
				'992.000000'
			],
			[
				'1998/6/10',
				'986.000000',
				'1000.000000',
				'981.000000'
			],
			[
				'1998/6/11',
				'993.000000',
				'1006.000000',
				'983.500000'
			],
			[
				'1998/6/12',
				'982.500000',
				'992.500000',
				'950.000000'
			],
			[
				'1998/6/15',
				'988.000000',
				'984.000000',
				'946.500000'
			],
			[
				'1998/6/16',
				'973.000000',
				'979.500000',
				'955.500000'
			],
			[
				'1998/6/17',
				'990.000000',
				'990.500000',
				'975.500000'
			],
			[
				'1998/6/18',
				'985.000000',
				'995.000000',
				'969.000000'
			],
			[
				'1998/6/19',
				'988.000000',
				'1000.500000',
				'980.000000'
			],
			[
				'1998/6/22',
				'987.500000',
				'992.500000',
				'951.000000'
			],
			[
				'1998/6/23',
				'996.000000',
				'1019.000000',
				'988.500000'
			],
			[
				'1998/6/24',
				'988.000000',
				'995.500000',
				'946.000000'
			],
			[
				'1998/6/25',
				'998.000000',
				'1022.000000',
				'980.000000'
			],
			[
				'1998/6/26',
				'1021.000000',
				'1033.000000',
				'950.000000'
			],
			[
				'1998/6/29',
				'1031.000000',
				'1040.000000',
				'970.000000'
			],
			[
				'1998/6/30',
				'1049.500000',
				'1049.000000',
				'1038.000000'
			],
			[
				'1998/7/1',
				'1018.000000',
				'1035.000000',
				'987.500000'
			],
			[
				'1998/7/2',
				'1020.000000',
				'1027.000000',
				'985.500000'
			],
			[
				'1998/7/3',
				'1027.000000',
				'1062.000000',
				'970.000000'
			],
			[
				'1998/7/6',
				'1015.000000',
				'1025.000000',
				'992.000000'
			],
			[
				'1998/7/7',
				'1017.000000',
				'1024.500000',
				'1004.000000'
			],
			[
				'1998/7/8',
				'1030.000000',
				'1029.000000',
				'1011.000000'
			],
			[
				'1998/7/9',
				'1034.000000',
				'1042.000000',
				'1029.000000'
			],
			[
				'1998/7/10',
				'1049.000000',
				'1067.500000',
				'1028.000000'
			],
			[
				'1998/7/13',
				'1065.000000',
				'1067.000000',
				'1037.500000'
			],
			[
				'1998/7/14',
				'1070.000000',
				'1075.000000',
				'1059.000000'
			],
			[
				'1998/7/15',
				'1072.000000',
				'1079.500000',
				'1067.500000'
			],
			[
				'1998/7/16',
				'1001.000000',
				'1070.500000',
				'1001.000000'
			],
			[
				'1998/7/17',
				'1052.000000',
				'1055.000000',
				'1024.000000'
			],
			[
				'1998/7/20',
				'1053.000000',
				'1055.000000',
				'1025.000000'
			],
			[
				'1998/7/21',
				'1046.500000',
				'1047.000000',
				'1046.500000'
			]
		];

}
