use ExtUtils::MakeMaker;

my $mm_ver = $ExtUtils::MakeMaker::VERSION;
if ($mm_ver =~ /_/) {
    $mm_ver = eval $mm_ver;
    die $@ if $@;
}

my @REQUIRES = (
    'strict'            => 0,
    'warnings'          => 0,
    'Text::CSV_XS'      => 0,
    'Text::Table::Tiny' => 0,
    'Getopt::Long'      => 0,
);

my @TEST_REQUIRES = (
    'Test::More'            => 0,
);

push(@REQUIRES, @TEST_REQUIRES) if $mm_ver < 6.64;

WriteMakefile(
    DISTNAME        => 'csvgrep',
    NAME            => 'csvgrep',
    VERSION_FROM    => 'bin/csvgrep',

    PREREQ_PM       => { @REQUIRES },

    ($mm_ver >= 6.64
        ? (TEST_REQUIRES => { @TEST_REQUIRES })
        : ()
    ),

    ($mm_ver >= 6.48
        ? (MIN_PERL_VERSION => 5.006)
        : ()
    ),

    ($mm_ver >= 6.31 ? (LICENSE => 'perl') : ()),

);
