use 5.006001; ##-- from xspp Makefile.PL
use ExtUtils::MakeMaker;

##----------------------------------------------------------------------
## Configuration
##----------------------------------------------------------------------
if (system("pkg-config --atleast-version=2.0.38 ddc") != 0) {
  die("Required module ddc >= v2.0.38 not found!\n");
}

##-- @pthread_flags: flag(s) for pthread (added to both CPPFLAGS and LIBS)
#my @pthread_flags = ('-pthread');
my @pthread_flags = qw();
$DDC_IFLAGS = join(' ', @pthread_flags, grep {!/^\-/ || /^-[IDf]/} map { split(' ',`pkg-config --cflags $_`);} qw(ddc));
$DDC_LDFLAGS= join(' ',                 map { split(' ',`pkg-config --libs-only-L $_`) } qw(ddc));
$DDC_LIBS   = join(' ', @pthread_flags, map { split(' ',`pkg-config --libs-only-l $_`) } qw(ddc));



##----------------------------------------------------------------------
## MAIN
##----------------------------------------------------------------------
WriteMakefile
  (
   NAME		=> 'DDC::XS',
   DISTNAME	=> 'ddc-perl-xs',
   AUTHOR       => 'Bryan Jurish <moocow@cpan.org>',
   ABSTRACT	=> 'Perl interface to libDDC* ddc concordance libraries',
   VERSION_FROM	=> 'XS.pm',


   ##-- user variables
   CC           => 'c++',   ##-- your c++ compiler
   LD		=> '$(CC)',
   LIBS         => "$DDC_LDFLAGS $DDC_LIBS",      ##-- additional libraries
   DEFINE       => '-DHAVE_CONFIG_H',     ##-- additional defines
   INC          => $DDC_IFLAGS,      ##-- additional includes
   CCFLAGS      => '',          ##-- additional flags
   OPTIMIZE    => '-O2 -pipe', ##-- optimization flags
   #OBJECT       => '',

   ##-- install these
   #EXE_FILES => [glob("bin/*.perl")],
   EXE_FILES => [],

   ##-- DEBUG
   #MAKEAPERL=>1,
   #LINKTYPE=>'static',
   #MAP_TARGET=>'gfsmperl',
   #CCFLAGS=>'-g',
   ##-- /DEBUG

   ##-- prerequisites
   PREREQ_PM => {
		 'ExtUtils::XSpp' => '0.18',
		 JSON => undef,
		},

   ##-- stuff that probably doesn't need to be changed
   #XSOPT        => '-C++',
   XSOPT        => '-C++ -hiertype', ##-- from xspp Makefile.PL
   TYPEMAPS     => ['perlobject.map', 'typemap'],
  );


#-----------------------------------------------------------------------
# Extensions

##---------------------------------------------------------------
sub MY::depend {
  package MY;
  my $inherited = shift->SUPER::depend(@_);
  $inherited .= (
		 ##-- depends -> README.txt
		 "\n\n"
		 ."dist: README.txt\n"
		 ."\n"
		 ."create_distdir: README.txt\n"
		 #."distdir_am: README.txt\n"
		 ."\n"
		 ."distcheck: README.txt\n"
		 ."\n"
		 ."manicheck: README.txt\n"
		 ."\n"
		 ##-- included xs dependencies
		 ."\n\n"
		 ."XS.c: "
		 .(''
		   ." XS.xs"
		   ." Constants.xs"
		   ." Object.xsp"
		   ." QueryCompiler.xsp"
		   ." Query.xsp"
		   ." QCount.xsp"
		   ." QueryFilter.xsp"
		   ." QueryOptions.xsp"
		   #." dummy.xs"
		  )
		 ."\n\n"
		 ##-- c->o dependencies
		 ."XS.o: XS.c ddcxs.h\n"
		 ."\n"
		 ## -- more here
		 ."\n"
		);
  $inherited;
}

##---------------------------------------------------------------
sub MY::special_targets {
  package MY;
  my $inherited = shift->SUPER::special_targets(@_);
  return $inherited."
.SUFFIXES: .pm .pod .rpod .man .txt .html

##-- README: special handling
readme: README.txt README.html

README.html : README.rpod
\tpod2html --infile=README.rpod --outfile=README.html --title='DDC-perl-xs README'

.rpod.txt:
\tpod2text \$< \$@
";
}
