##-*- Mode: CPerl -*-

## File: DDC::Format::YAML.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description:
##  + DDC Query utilities: output formatting: YAML
##======================================================================

package DDC::Format::YAML;
use YAML::XS;
use Carp;
use strict;

##======================================================================
## Globals
our @ISA = qw(DDC::Format);

##======================================================================
## Constructors, etc.

## $fmt = $CLASS_OR_OBJ->new(%args)
##  + %args:
##    (
##     level => $level,    ##-- yaml prettification level (default:0)
##    )
sub new {
  my $that = shift;
  my $fmt = bless {
		   level=>0,
		   @_
		  }, ref($that)||$that;
  return $fmt;
}

## $fmt = $fmt->reset()
##  + reset counters, etc.
#sub reset {
#  return $_[0]->SUPER::reset();
#}

##======================================================================
## Helper functions

## $hitStr = $fmt->hitString($hit)
sub hitString {
  #my ($fmt,$hit) = @_;
  return YAML::XS::Dump($_[1]);
}

##======================================================================
## API

## $str = $fmt->toString(\@hits)
sub toString {
  my ($fmt,$hits) = @_;
  return YAML::XS::Dump($_[1]);
}

1; ##-- be happy

##======================================================================
## Docs
=pod

=head1 NAME

DDC::Format::YAML - YAML::XS formatting for DDC hits

=head1 SYNOPSIS

 use DDC;

 @hits = DDC::Client::Distributed->new()->query('foo&&bar'); ##-- get some hits

 $fmt = DDC::Format::YAML->new();
 $str = $fmt->toString(\@hits);        ##-- conversion to string
 $fmt->toFile(\@hits,$filename);       ##-- output to file
 $fmt->toFh(\@hits,$fh);               ##-- output to filehandle

=cut

##======================================================================
## Description
=pod

=head1 DESCRIPTION

Class for formatting DDC::Hit objects as perl code using YAML::XS.

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Format::YAML: Globals
=pod

=head2 Globals

=over 4

=item Variable: @ISA

DDC::Format::YAML inherits from DDC::Format.

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Format::YAML: Constructors, etc.
=pod

=head2 Constructors, etc.

=over 4

=item new

 $fmt = $CLASS_OR_OBJ->new(%args);

Accepted keywords in %args:

 (
  #level  => $bool,   ##-- pretty-print?  ##-- NOT USED
 )

=item reset

 $fmt = $fmt->reset();

Resets the formatting object.

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Format::YAML: Helper functions
=pod

=head2 Helper functions

=over 4

=item hitString

 $hitStr = $fmt->hitString($hit);

Formats a single $hit as a string.

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Format::YAML: API
=pod

=head2 API

=over 4

=item toString

 $str = $fmt->toString(\@hits);

Implements DDC::Format::toString().

=back

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl


##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.7 or,
at your option, any later version of Perl 5 you may have available.

=cut
