use strict;
use warnings;
use Test::More;
require "t/exercises.tt";

use_ok('Forks::Queue::Shmem');

if (! -d "$Forks::Queue::Shmem::DEV_SHM") {
    ok(1, '# skip - shared memory virtual filesystem not found');
    done_testing;
    exit;
}

########

my $DIR = $Forks::Queue::Shmem::DEV_SHM;
ok(-d $DIR, 'shared mem directory exists');
unlink "$DIR/q1";
ok(! -f "$DIR/q1", 'queue segment does not exist yet');

my $q = Forks::Queue::Shmem->new( file => 'q1', style => 'fifo' );

ok($q, 'got queue object');
ok(ref($q) eq 'Forks::Queue::Shmem', 'has correct object type');
ok(-f "$DIR/q1", 'queue file created');
ok(-s "$DIR/q1" > 1024, 'queue header section created');

exercise_fifo($q);

undef $q;
ok(! -f "$DIR/q1", 'queue segment destroyed at queue object destruction');

#####

unlink "$DIR/q2";
ok(-d $DIR, 'queue directory exists');
ok(! -f "$DIR/q2", 'queue file does not exist yet');

$q = Forks::Queue::Shmem->new( file => 'q2', style => 'lifo' );

ok($q && ref($q) eq 'Forks::Queue::Shmem', 'got queue with correct type');
ok(-f "$DIR/q2", 'queue file created');
ok(-s "$DIR/q2" > 1024, 'queue header section created');

exercise_lifo($q);

undef $q;
ok(! -f "$DIR/q2", 'queue file destroyed when queue object left scope');

#####

my $TEMP = $DIR;

unlink "$TEMP/q3a", "$TEMP/q3b";
ok(-d $TEMP, 'queue directory exists');
ok(! -f "$TEMP/q3a", 'queue file does not exist yet');
ok(! -f "$TEMP/q3b", 'queue file does not exist yet');

my $q1 = Forks::Queue->new( impl => 'Shmem', file => "$TEMP/q3a" );
my $q2 = Forks::Queue::Shmem->new( file => "$TEMP/q3b", persist => 1 );

ok($q1 && ref($q1) eq 'Forks::Queue::Shmem', 'got queue with correct type');

exercise_forks($q1);

undef $q1;
ok(! -f "$TEMP/q3a", 'queue file destroyed when object left scope');

exercise_forks($q2);
undef $q2;
ok(-f "$TEMP/q3b", 'queue with persist option not destroyed');
unlink("$TEMP/q3b");
ok(! -f "$TEMP/q3b", 'queue file removed manually');

#####

unlink "$TEMP/q4";
ok(-d $TEMP, 'queue directory exists');
ok(! -f "$TEMP/q4", 'queue file does not exist yet');

$q = Forks::Queue->new( impl => 'Shmem', limit => 5, on_limit => 'fail' );

exercise_limits($q, 'fail');

$q->{on_limit} = 'block';
exercise_limits($q, 'block');

undef $q;
ok(! -f "$TEMP/q4", 'queue file deleted on queue destruction');

#####

exercise_join( impl => 'Shmem', loc1 => 'q11a', loc2 => 'q11b',
               file1 => '/dev/shm/q11a', file2 => '/dev/shm/q11b' );

#####

done_testing;
