package IO::Iron::Applications::IronCache::Command::get;

use 5.010_000;
use strict;
use warnings FATAL => 'all';

# Global creator
BEGIN {
    # Inheritance
    use parent qw( IO::Iron::Applications::Command::CommandBase );
}

# Global destructor
END {
}

# ABSTRACT: Get item(s) from cache(s).

our $VERSION = '0.11'; # VERSION: generated by DZP::OurPkgVersion


use Data::Dumper;

use IO::Iron::Applications::IronCache -command;

sub description {
	return "Get item(s) from cache(s).";
}

sub usage_desc {
	my ($self, $opt, $args) = @_;
	return $opt->arg0() . " %o put item <item_key>[,<item_key>] --cache <cache_name>[,<cache_name>]";
}

sub opt_spec {
	return (
        IO::Iron::Applications::Command::CommandBase::opt_spec_base(),
		[ 'cache=s',	"cache name or names (separated with \',\')", ],
	);
}

sub validate_args {
	my ($self, $opt, $args) = @_;
    $self->validate_args_base($opt, $args);
	$self->usage_error("wrong number of arguments") unless scalar @{$args} == 2;
	$self->usage_error("invalid arguments") unless ($args->[0] eq 'item');
    $self->usage_error("missing cache name") unless (defined $opt->{'cache'});
}

sub execute {
    my ($self, $opts, $args) = @_;

    $self->raise_logging_levels_from_options($opts);
    if($self->check_for_iron_io_config($opts)) {
        return 1;
    }
    my %parameters;
    $parameters{'config'} = $opts->{'config'} if defined $opts->{'config'};
    $parameters{'policies'} = $opts->{'policies'} if defined $opts->{'policies'};
    $parameters{'no-policy'} = $opts->{'no-policy'};
    $parameters{'item_key'} = [ split q{,}, $args->[1] ]; # expects array
    $parameters{'cache_name'} = [ split q{,}, $opts->{'cache'} ]; # expects array
    my %output;
    %output = IO::Iron::Applications::IronCache::Functionality::get_item(%parameters);

    print $self->combine_template("get_item", \%output);
    return 0;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::Iron::Applications::IronCache::Command::get - Get item(s) from cache(s).

=head1 VERSION

version 0.11

=head1 SYNOPSIS

This package is for internal use of IO::Iron::Applications.

=head1 AUTHOR

Mikko Koivunalho <mikko.koivunalho AT iki.fi>

=head1 BUGS

Please report any bugs or feature requests to bug-io-iron-applications@rt.cpan.org or through the web interface at:
 http://rt.cpan.org/Public/Dist/Display.html?Name=IO-Iron-Applications

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Mikko Koivunalho.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
