
use Test;

use Unicode::Japanese;

BEGIN { plan tests => 8 }


## h2z/z2h convert

# h2z num
$string = new Unicode::Japanese "0129";
$string->h2z;
ok($string->get, "\xef\xbc\x90\xef\xbc\x91\xef\xbc\x92\xef\xbc\x99");

# h2z alpha
$string = new Unicode::Japanese "abzABZ";
$string->h2z;
ok($string->get, "\xef\xbd\x81\xef\xbd\x82\xef\xbd\x9a\xef\xbc\xa1\xef\xbc\xa2\xef\xbc\xba");

# h2z symbol
$string = new Unicode::Japanese "!#^*(-+~{]>?";
$string->h2z;
ok($string->get, "\xef\xbc\x81\xef\xbc\x83\xef\xbc\xbe\xef\xbc\x8a\xef\xbc\x88\xe2\x88\x92\xef\xbc\x8b\xe3\x80\x9c\xef\xbd\x9b\xef\xbc\xbd\xef\xbc\x9e\xef\xbc\x9f");

# h2z kana
$string = new Unicode::Japanese "\xef\xbd\xa1\xef\xbd\xab\xe3\x81\x89\xef\xbd\xb3\xef\xbe\x9e";
$string->h2z;
ok($string->get, "\xe3\x80\x82\xe3\x82\xa9\xe3\x81\x89\xe3\x83\xb4");

# z2h num
$string = new Unicode::Japanese "\xef\xbc\x90\xef\xbc\x91\xef\xbc\x92\xef\xbc\x99";
$string->z2h;
ok($string->get, "0129");

# z2h alpha
$string = new Unicode::Japanese "\xef\xbd\x81\xef\xbd\x82\xef\xbd\x9a\xef\xbc\xa1\xef\xbc\xa2\xef\xbc\xba";
$string->z2h;
ok($string->get, "abzABZ");

# z2h symbol
$string = new Unicode::Japanese "\xef\xbc\x81\xef\xbc\x83\xef\xbc\xbe\xef\xbc\x8a\xef\xbc\x88\xe2\x88\x92\xef\xbc\x8b\xe3\x80\x9c\xef\xbd\x9b\xef\xbc\xbd\xef\xbc\x9e\xef\xbc\x9f";
$string->z2h;
ok($string->get, "!#^*(-+~{]>?");

# z2h kana
$string = new Unicode::Japanese "\xe3\x80\x82\xe3\x82\xa9\xe3\x81\x89\xe3\x83\xb4";
$string->z2h;
ok($string->get, "\xef\xbd\xa1\xef\xbd\xab\xe3\x81\x89\xef\xbd\xb3\xef\xbe\x9e");



