#!/bin/bash

test_files=(queries_testcases.pml queries_testcases-2.pml)
limit=10000000
timeout=1000
fmt=pml # or bin?
fl_prefix=/net/projects/pdt/pdt20/data/filelists/

LANG=en_US.UTF8
LC_COLLATE=en_US.UTF8


if [ -z $PG_DB ]; then
    PG_DB=pdt-pg
fi
if [ -z $ORA_DB ]; then
    ORA_DB=default
fi

if [ -z $RESULT_DIR ]; then
    RESULT_DIR=results
fi
type='oracle pg jtred'

if [ ! -d $RESULT_DIR ]; then
  mkdir $RESULT_DIR || exit 1
fi

if [ -n "$1" ]; then
    type="$1"
    shift
fi

for test_file in "${test_files[@]}"; do

    i=0
    ids=()
    if [ $# -gt 0 ]; then
	ids=("$@")
    else
	ids=($(xsh2 -qFC 'for /*/*/*/@id echo (.)' "$test_file" | grep .| sed "s,^,${test_file}_,"))
    fi

    for id in "${ids[@]}"; do
	if [[ "$id" = [0-9][0-9][0-9]_* ]]; then
	    no="${id%%_*}"
	    id="${id#*_}"
	else
	    no=$(printf "%03d" $i)
	fi
	if [[ "$id" = "${test_file}_"* ]]; then
	    id="${id#${test_file}_}"
	    no="${no}_${test_file}"
	    
	    echo "== $test_file#$id =================================="
	    corpus_part=${id%%-*};
	    
	    if [ "$type" != "${type/oracle/}" ]; then
		echo "SQL[oracle] $test_file#$id"
		(time pmltq -q -s $ORA_DB --timeout $timeout --limit $limit -p "$test_file" -i "$id" > "$RESULT_DIR/${no}_${id}.oracle.o") 2>&1 |tee "$RESULT_DIR/${no}_${id}.oracle.e" >&2
		sleep 0.5
	    fi

	    if [ "$type" != "${type/pg/}" ]; then
		echo "SQL[pg] $test_file#$id"
		(time pmltq -q -s $PG_DB --timeout $timeout --limit $limit -p "$test_file" -i "$id" > "$RESULT_DIR/${no}_${id}.pg.o") 2>&1 |tee "$RESULT_DIR/${no}_${id}.pg.e" >&2
		sleep 0.5
	    fi
	    
	    if [ "$type" != "${type/jtred/}" ]; then
		echo "JTRED[$corpus_part] $test_file#$id"
		(time pmltq -s lrc-two --jtred -p "$test_file" -i "$id" -l ${fl_prefix}?-${corpus_part}-all-train-$fmt.fl > "$RESULT_DIR/${no}_$id.jtred.o" 2>"$RESULT_DIR/${no}_${id}.jtred.e")
		
		sleep 0.5
	    fi
	    
	    if [ "$type" != "${type/ntred/}" ]; then
		echo "NTRED[$corpus_part] $test_file#$id"
		(time pmltq --ntred -p "$test_file" -i "$id" -l ${fl_prefix}?-${corpus_part}-all-train-$fmt.fl > "$RESULT_DIR/${no}_$id.ntred.o" 2>"$RESULT_DIR/${no}_${id}.ntred.e")
	    
		sleep 0.5
	fi
	    i=$((i+1))
	fi
    done
done 
