use v6;
use Semi-xml;

package TMap:ver<0.2.0> {

  role Variant {

    # Topicname parent
    #
    has $.tn-parent;
    
    has Str $.datatype;
    has Str $.value;
    has @.scopes;

    #---------------------------------------------------------------------------
    # Initialize variant object
    #
    method initialize ( $name where $name.name eq 'name',
                        $topic where $topic.name eq 'topic'
                      ) {
            
      $!tn-parent = $name;
      self.check-item-identifiers;
      self.set-reifier($topic);

      my $type = 'IRI';
      my $ref;

      for self.nodes -> $v-node {
        if $v-node ~~ XML::Element {
          given $v-node.name {

            when 'resourceData' {
              $type = $v-node.attribs<datatype> if ?$v-node.attribs<datatype>;
            }

            when 'resourceRef' {
              $ref = $v-node.attribs<href> if ?$v-node.attribs<href>;
            }

            when 'scope' {
              my @trefs = self.get-topic-references($v-node);

              for @trefs -> $tref {
                my $scope = $topic.get-topic-from-id($tref);
                if ?$scope {
  say "Variant scope: ", $scope.attribs<id>;

                  # Store id as string. Later when checked get object of
                  # reference
                  #
                  @!scopes.push($scope);
                }
              }
            }
          }
        }
      }

      if ?$ref {
        $!datatype = $type;
        $!value = $ref;

say "Variant ref and data: {self.get('type')}, {self.get('value')}";
      }
    }

    #---------------------------------------------------------------------------
    # Some getters
    #
    multi method get ( 'type' ) { return $!datatype; }
    multi method get ( 'value' ) { return $!value; }
    multi method get ( 'parent' ) { return $!tn-parent; }
  }
}
