use v6;
use Semi-xml;

package TMap:ver<0.2.0> {

  role Occurrence {

    # Topic parent
    #
    has $.t-parent;
    
    has Str $.datatype;
    has $.type;
    has Str $.value;
    has @.scopes;

    #---------------------------------------------------------------------------
    # Initialize variant object
    #
    method initialize ( $topic where $topic.name eq 'topic' ) {
            
      $!t-parent = $topic;
      self.check-item-identifiers;
      self.set-reifier($topic);

      my $type = 'IRI';
      my $ref;

      for self.nodes -> $o-node {
        if $o-node ~~ XML::Element {
          given $o-node.name {

            when 'resourceData' {
              $type = $o-node.attribs<datatype> if ?$o-node.attribs<datatype>;
            }

            when 'resourceRef' {
              $ref = $o-node.attribs<href> if ?$o-node.attribs<href>;
            }

            when 'scope' {
              my @trefs = self.get-topic-references($o-node);

              for @trefs -> $tref {
                my $scope = $topic.get-topic-from-id($tref);
                if ?$scope {
  say "Occurrence scope: ", $scope.attribs<id>;

                  # Store id as string. Later when checked get object of
                  # reference
                  #
                  @!scopes.push($scope);
                }
              }
            }

            # Get the type of this occurence
            #
            when 'type' {
              my @trefs = self.get-topic-references($o-node);
              my $occ-type = $topic.get-topic-from-id(@trefs[0]);
  say "Occurrence type: ", $occ-type.attribs<id> if ?$occ-type;

              # Store id as string. Later when checked get object of reference
              #
              $!type = $occ-type if ?$occ-type;
            }
          }
        }
      }

      if ?$ref {
        $!datatype = $type;
        $!value = $ref;

say "Occurrence ref and data: {self.get('type')}, {self.get('value')}";
      }
    }

    #---------------------------------------------------------------------------
    # Some getters
    #
    multi method get ( 'type' ) { return $!datatype; }
    multi method get ( 'value' ) { return $!value; }
    multi method get ( 'parent' ) { return $!t-parent; }
  }
}
