#define PERL_NO_GET_CONTEXT // we'll define thread context if necessary (faster)
#include "EXTERN.h"         // globals/constant import locations
#include "perl.h"           // Perl symbols, structures and constants definition
#include "XSUB.h"           // xsubpp functions and macros
#include <pdfio.h> // PDFIO library header for PDF manipulation

MODULE = PDFio::Architect::Page::_Page  PACKAGE = PDFio::Architect::Page::_Page
PROTOTYPES: DISABLE

MODULE = PDFio::Architect::Page  PACKAGE = PDFio::Architect::Page
PROTOTYPES: DISABLE

SV *
new(pkg, file, ...)
	SV * pkg
	SV * file
	CODE:

		STRLEN retlen;
		char * pkg_name = SvPV(pkg, retlen);
		HV *hash = newHV();

		HV *self = (HV*)SvRV(file);

		SV **file_sv = hv_fetch(self, "file", 4, 0);
		if (!file_sv || !SvROK(*file_sv)) {
			croak("file not initialized");
		}
		pdfio_file_t *pdf = INT2PTR(pdfio_file_t*, SvUV(SvRV(*file_sv)));

		pdfio_dict_t *dict = pdfioDictCreate(pdf);

		HV *dict_hash = (HV*)SvRV(*hv_fetch(self, "dict", 4, 0));
		HE *entry;
		(void)hv_iterinit(dict_hash);
		while ((entry = hv_iternext(dict_hash)) != NULL) {
			SV *key_sv = hv_iterkeysv(entry);
			SV *value_sv = hv_iterval(dict_hash, entry);
			if (SvOK(key_sv) && SvOK(value_sv)) {
				const char *key = SvPV_nolen(key_sv);
				const char *value = NULL;
				if (sv_isa(value_sv, "PDFio::Architect::Rect")) {
					
				} else {
					HV * value_hash = (HV*)SvRV(value_sv);
					char * font_key = SvPV_nolen(*hv_fetch(value_hash, "name", 4, 0));
					pdfio_obj_t *pdf_font =  INT2PTR(pdfio_obj_t*, SvUV(SvRV(*hv_fetch(value_hash, "font", 4, 0))));
					pdfioPageDictAddFont(dict, font_key, &pdf_font);
				}
			}
		}

		pdfio_stream_t *page = pdfioFileCreatePage(pdf, dict);

		SV * page_sv = sv_bless(
			newRV_noinc(newSViv(PTR2UV(page))), gv_stashpv("PDFio::Architect::Page::_Page", 1)
		);
		hv_store(hash, "page", 4, page_sv, 0);

		RETVAL = sv_bless(newRV_noinc((SV*)hash), gv_stashpv(pkg_name, 0));
	OUTPUT:
		RETVAL