#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_anon0__capture1 = -1;
static int32_t FIELD_BYTE_OFFSET_anon0__capture1 = -1;
static int32_t FIELD_ID_anon0__capture2 = -1;
static int32_t FIELD_BYTE_OFFSET_anon0__capture2 = -1;
static int32_t FIELD_ID_TestCase__Point_3b__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__x = -1;
static int32_t FIELD_ID_TestCase__Point_3b__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__y = -1;
static int32_t FIELD_ID_TestCase__Point_3b__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__z = -1;
static int32_t FIELD_ID_TestCase__Point_3d__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__x = -1;
static int32_t FIELD_ID_TestCase__Point_3d__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__y = -1;
static int32_t FIELD_ID_TestCase__Point_3d__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__z = -1;
static int32_t FIELD_ID_TestCase__Point_3f__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__x = -1;
static int32_t FIELD_ID_TestCase__Point_3f__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__y = -1;
static int32_t FIELD_ID_TestCase__Point_3f__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__z = -1;
static int32_t FIELD_ID_TestCase__Point_3i__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__x = -1;
static int32_t FIELD_ID_TestCase__Point_3i__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__y = -1;
static int32_t FIELD_ID_TestCase__Point_3i__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__z = -1;
static int32_t FIELD_ID_TestCase__Point_3l__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__x = -1;
static int32_t FIELD_ID_TestCase__Point_3l__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__y = -1;
static int32_t FIELD_ID_TestCase__Point_3l__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__z = -1;
static int32_t FIELD_ID_TestCase__Point_3s__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__x = -1;
static int32_t FIELD_ID_TestCase__Point_3s__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__y = -1;
static int32_t FIELD_ID_TestCase__Point_3s__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__z = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1 = - 1;
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
static int32_t SUB_ID_TestCase__Sub__sum_int = - 1;
static int32_t SUB_ID_TestCase__Sub__call_sub_nest_sum = - 1;
static int32_t SUB_ID_TestCase__Sub__call_void_sub = - 1;
static int32_t SUB_ID_anon1__ = - 1;
static int32_t SUB_ID_SPVM__Comparator__ = - 1;
static int32_t SUB_ID_anon0__ = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_byte_sub = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_byte_sub_empty = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_double_sub = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_double_sub_empty = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_float_sub = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_float_sub_empty = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_int_sub = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_int_sub_empty = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_long_sub = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_long_sub_empty = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_object_sub = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_object_sub_empty = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_short_sub = - 1;
static int32_t SUB_ID_TestCase__Sub__default_return_value_short_sub_empty = - 1;
static int32_t SUB_ID_TestCase__Sub__sub_push_arg_undef = - 1;
static int32_t SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_widening = - 1;
static int32_t SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_byte = - 1;
static int32_t SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_short = - 1;
static int32_t SUB_ID_TestCase__Sub__return_value_byte_sub = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_TestCase__Sub__return_value_double_sub = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_TestCase__Sub__return_value_float_sub = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_TestCase__Sub__return_value_int_sub = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_TestCase__Sub__return_value_long_sub = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_TestCase__Sub__return_value_short_sub = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_TestCase__Simple__import_sub1 = - 1;
static int32_t SUB_ID_TestCase__Simple__import_sub2 = - 1;
static int32_t SUB_ID_TestCase__Sub__test_vaarg_objects_pass_array = - 1;
static int32_t SUB_ID_TestCase__Sub__test_vaarg_objects_pass_each_values = - 1;
static int32_t SUB_ID_TestCase__Sub__test_vaarg_pass_array = - 1;
static int32_t SUB_ID_TestCase__Sub__test_vaarg_pass_each_values = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_double = -1;
static int32_t BASIC_TYPE_ID_float = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_short = -1;
static int32_t BASIC_TYPE_ID_anon1 = -1;
static int32_t BASIC_TYPE_ID_anon2 = -1;
static int32_t BASIC_TYPE_ID_anon0 = -1;
static int32_t BASIC_TYPE_ID_object = -1;
// Function Declarations
// [SIG]int(int,int)
int32_t SPPRECOMPILE__TestCase__Sub__already_exists_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__already_exists_sub_no_arg(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(byte,byte,byte)
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_convertion(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double(byte,short,int,long,float,double)
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_convertion_stab1(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int,int,int)
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(long,long,long)
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(short,short,short)
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_assign(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte(byte[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_barray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double(double[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_darray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float(float[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_farray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_iarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long(long[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_larray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_last_camma(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_nest(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int,int)
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_nest_sum(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte[]()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_barray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(byte[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_barray_check(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double[]()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_darray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(double[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_darray_check(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float[]()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_farray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(float[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_farray_check(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int[]()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_iarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_iarray_check(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long[]()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_larray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(long[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_larray_check(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short[]()
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_sarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(short[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_sarray_check(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short(short[])
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_sarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Minimal)
int32_t SPPRECOMPILE__TestCase__Sub__call_sub_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__call_void(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(int[])
int32_t SPPRECOMPILE__TestCase__Sub__call_void_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__cb_obj_call_cb_obj(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__cb_obj_call_cb_obj_from_callback(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__cb_obj_capture(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_byte_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_byte_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_double_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_double_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_float_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_float_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_int_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_int_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_long_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_long_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Minimal()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_object_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Minimal()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_object_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_short_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short()
int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_short_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__push_arg_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_automatical_numeric_convertion(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3b()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_byte_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3d()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_double_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3f()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_float_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3i()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_int_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3l()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_long_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3s()
int32_t SPPRECOMPILE__TestCase__Sub__return_value_short_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Minimal(TestCase::Minimal)
int32_t SPPRECOMPILE__TestCase__Sub__sub_push_arg_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int,int)
int32_t SPPRECOMPILE__TestCase__Sub__sum_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__test_import_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte()
int32_t SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short()
int32_t SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_widening(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string,object[])
int32_t SPPRECOMPILE__TestCase__Sub__test_vaarg_objects_pass_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string,object[])
int32_t SPPRECOMPILE__TestCase__Sub__test_vaarg_objects_pass_each_values(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string,int[])
int32_t SPPRECOMPILE__TestCase__Sub__test_vaarg_pass_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string,int[])
int32_t SPPRECOMPILE__TestCase__Sub__test_vaarg_pass_each_values(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__vaarg_objects_pass_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__vaarg_objects_pass_each_values(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__vaarg_pass_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Sub__vaarg_pass_each_values(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Sub__already_exists_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L3: // INIT_INT
  int_vars[5] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__already_exists_sub_no_arg(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];
  // Copy arguments to variables
  byte_vars[0] = *(int8_t*)&stack[0];
  byte_vars[1] = *(int8_t*)&stack[1];
  byte_vars[2] = *(int8_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[0];
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L6: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L11: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L12: // MOVE_CONSTANT_INT
  int_vars[3] = -128;
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L18: // GOTO
  goto L19;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_convertion(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[1];
  int64_t long_vars[1];
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[6];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L4: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L5: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L6: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L7: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L8: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[7] = 8;
L10: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[7];
L11: // MOVE_CONSTANT_INT
  int_vars[8] = 16;
L12: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[8];
L13: // PUSH_ARG_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
L14: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L15: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L16: // PUSH_ARG_LONG
  *(int64_t*)&stack[3] = long_vars[0];
L17: // PUSH_ARG_FLOAT
  *(float*)&stack[4] = float_vars[0];
L18: // PUSH_ARG_DOUBLE
  *(double*)&stack[5] = double_vars[0];
L19: // CALL_SUB_DOUBLE
  // TestCase::Sub->call_sub_args_convertion_stab1
  {
    if (SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1 < 0) {
      SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1 = env->get_sub_id(env, "TestCase::Sub", "call_sub_args_convertion_stab1", "double(byte,short,int,long,float,double)");
      if (SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub call_sub_args_convertion_stab1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1;
    exception_flag = SPPRECOMPILE__TestCase__Sub__call_sub_args_convertion_stab1(env, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_args_convertion";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 520;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 32;
L22: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[3];
L23: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L26: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L32: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L33: // CONVERT_BYTE_TO_SHORT
  short_vars[0] = (int16_t)byte_vars[1];
L34: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L35: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[6];
L36: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[2];
L37: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L38: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[8];
L39: // CONVERT_BYTE_TO_LONG
  long_vars[0] = (int64_t)byte_vars[3];
L40: // MOVE_CONSTANT_INT
  int_vars[9] = 8;
L41: // CONVERT_INT_TO_BYTE
  byte_vars[4] = (int8_t)int_vars[9];
L42: // CONVERT_BYTE_TO_FLOAT
  float_vars[0] = (float)byte_vars[4];
L43: // MOVE_CONSTANT_INT
  int_vars[10] = 16;
L44: // CONVERT_INT_TO_BYTE
  byte_vars[5] = (int8_t)int_vars[10];
L45: // CONVERT_BYTE_TO_DOUBLE
  double_vars[0] = (double)byte_vars[5];
L46: // PUSH_ARG_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
L47: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L48: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[7];
L49: // PUSH_ARG_LONG
  *(int64_t*)&stack[3] = long_vars[0];
L50: // PUSH_ARG_FLOAT
  *(float*)&stack[4] = float_vars[0];
L51: // PUSH_ARG_DOUBLE
  *(double*)&stack[5] = double_vars[0];
L52: // CALL_SUB_DOUBLE
  // TestCase::Sub->call_sub_args_convertion_stab1
  {
    if (SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1 < 0) {
      SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1 = env->get_sub_id(env, "TestCase::Sub", "call_sub_args_convertion_stab1", "double(byte,short,int,long,float,double)");
      if (SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub call_sub_args_convertion_stab1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__call_sub_args_convertion_stab1;
    exception_flag = SPPRECOMPILE__TestCase__Sub__call_sub_args_convertion_stab1(env, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_args_convertion";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 529;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 32;
L55: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L56: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L61; }
L59: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L60: // GOTO
  goto L61;
L61: // BOOL_INT
  int_vars[0] = int_vars[1];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L63: // BOOL_INT
  int_vars[0] = int_vars[3];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L68; }
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // BOOL_INT
  int_vars[0] = int_vars[4];
L67: // GOTO
  goto L70;
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L69: // BOOL_INT
  int_vars[0] = int_vars[5];
L70: // GOTO
  goto L73;
L71: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L72: // BOOL_INT
  int_vars[0] = int_vars[6];
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L78; }
L75: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L82;
L77: // GOTO
  goto L78;
L78: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L82;
L80: // INIT_INT
  int_vars[8] = 0;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L82;
L82: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_convertion_stab1(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  float float_vars[3];
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];
  // Copy arguments to variables
  byte_vars[0] = *(int8_t*)&stack[0];
  short_vars[0] = *(int16_t*)&stack[1];
  int_vars[1] = *(int32_t*)&stack[2];
  long_vars[0] = *(int64_t*)&stack[3];
  float_vars[0] = *(float*)&stack[4];
  double_vars[0] = *(double*)&stack[5];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L2: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L3: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L4: // ADD_INT
  int_vars[5] = int_vars[4] + int_vars[1];
L5: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L6: // ADD_LONG
  long_vars[2] = long_vars[1] + long_vars[0];
L7: // CONVERT_LONG_TO_FLOAT
  float_vars[1] = (float)long_vars[2];
L8: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L9: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[2];
L10: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L11: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[2];
  goto L14;
L12: // INIT_DOUBLE
  double_vars[3] = 0;
L13: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[3];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];
  int_vars[3] = *(int32_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L2: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[4]);
L3: // BOOL_INT
  int_vars[0] = int_vars[0];
L4: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 2147483647;
L6: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L9: // MOVE_CONSTANT_INT
  int_vars[5] = INT32_MIN;
L10: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L22;
L15: // GOTO
  goto L16;
L16: // GOTO
  goto L17;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L22;
L20: // INIT_INT
  int_vars[9] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L22;
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  long_vars[0] = *(int64_t*)&stack[0];
  long_vars[1] = *(int64_t*)&stack[1];
  long_vars[2] = *(int64_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[3] = 0LL;
L2: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[3]);
L3: // BOOL_INT
  int_vars[0] = int_vars[0];
L4: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L5: // MOVE_CONSTANT_LONG
  long_vars[3] = 9223372036854775807LL;
L6: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[3]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L9: // MOVE_CONSTANT_LONG
  long_vars[3] = INT64_MIN;
L10: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[3]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L15: // GOTO
  goto L16;
L16: // GOTO
  goto L17;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_args_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  char convert_string_buffer[21];
  // Copy arguments to variables
  short_vars[0] = *(int16_t*)&stack[0];
  short_vars[1] = *(int16_t*)&stack[1];
  short_vars[2] = *(int16_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CONVERT_SHORT_TO_INT
  int_vars[1] = (int32_t)short_vars[0];
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L3: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L4: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L5: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L8: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 32767;
L10: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[3];
L11: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[3];
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L15: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L16: // MOVE_CONSTANT_INT
  int_vars[3] = -32768;
L17: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[3];
L18: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[3];
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L31;
L24: // GOTO
  goto L25;
L25: // GOTO
  goto L26;
L26: // GOTO
  goto L27;
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L31;
L29: // INIT_INT
  int_vars[6] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L31;
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_assign(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_assign";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 799;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L8;
  }
L4: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_assign";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 800;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L8;
  }
L6: // INIT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L8: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_barray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // GOTO
  goto L15;
L6: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L7: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[1] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_barray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L10: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L11: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L15: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_barray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L17: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L6; }
L20: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  goto L23;
L21: // INIT_BYTE
  byte_vars[1] = 0;
L22: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[1];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_darray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // GOTO
  goto L12;
L6: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[1] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_darray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L8: // ADD_DOUBLE
  double_vars[0] = double_vars[0] + double_vars[1];
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L12: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_darray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 648;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L14: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L6; }
L17: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L20;
L18: // INIT_DOUBLE
  double_vars[1] = 0;
L19: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_farray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // GOTO
  goto L12;
L6: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[1] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_farray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 638;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L8: // ADD_FLOAT
  float_vars[0] = float_vars[0] + float_vars[1];
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L12: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_farray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 637;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L14: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L6; }
L17: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L20;
L18: // INIT_FLOAT
  float_vars[1] = 0;
L19: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_iarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L4: // GOTO
  goto L11;
L5: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_iarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 616;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L7: // ADD_INT
  int_vars[1] = int_vars[1] + int_vars[4];
L8: // MOVE_INT
  int_vars[4] = int_vars[3];
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L10: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L11: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_iarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 615;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L13: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L5; }
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L19;
L17: // INIT_INT
  int_vars[5] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L19;
L19: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L20: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_larray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // GOTO
  goto L12;
L6: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_larray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 627;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L8: // ADD_LONG
  long_vars[0] = long_vars[0] + long_vars[1];
L9: // MOVE_INT
  int_vars[3] = int_vars[2];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L12: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_larray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L14: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L6; }
L17: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L20;
L18: // INIT_LONG
  long_vars[1] = 0;
L19: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_last_camma(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L5: // CALL_SUB_INT
  // TestCase::Sub->sum_int
  {
    if (SUB_ID_TestCase__Sub__sum_int < 0) {
      SUB_ID_TestCase__Sub__sum_int = env->get_sub_id(env, "TestCase::Sub", "sum_int", "int(int,int)");
      if (SUB_ID_TestCase__Sub__sum_int < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub sum_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__sum_int;
    exception_flag = SPPRECOMPILE__TestCase__Sub__sum_int(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_last_camma";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 814;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L8: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_nest(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L5: // CALL_SUB_INT
  // TestCase::Sub->call_sub_nest_sum
  {
    if (SUB_ID_TestCase__Sub__call_sub_nest_sum < 0) {
      SUB_ID_TestCase__Sub__call_sub_nest_sum = env->get_sub_id(env, "TestCase::Sub", "call_sub_nest_sum", "int(int,int)");
      if (SUB_ID_TestCase__Sub__call_sub_nest_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub call_sub_nest_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__call_sub_nest_sum;
    exception_flag = SPPRECOMPILE__TestCase__Sub__call_sub_nest_sum(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_nest";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L8: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L9: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L10: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L11: // CALL_SUB_INT
  // TestCase::Sub->call_sub_nest_sum
  {
    if (SUB_ID_TestCase__Sub__call_sub_nest_sum < 0) {
      SUB_ID_TestCase__Sub__call_sub_nest_sum = env->get_sub_id(env, "TestCase::Sub", "call_sub_nest_sum", "int(int,int)");
      if (SUB_ID_TestCase__Sub__call_sub_nest_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub call_sub_nest_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__call_sub_nest_sum;
    exception_flag = SPPRECOMPILE__TestCase__Sub__call_sub_nest_sum(env, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_nest";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L14: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[6];
L15: // CALL_SUB_INT
  // TestCase::Sub->call_sub_nest_sum
  {
    if (SUB_ID_TestCase__Sub__call_sub_nest_sum < 0) {
      SUB_ID_TestCase__Sub__call_sub_nest_sum = env->get_sub_id(env, "TestCase::Sub", "call_sub_nest_sum", "int(int,int)");
      if (SUB_ID_TestCase__Sub__call_sub_nest_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub call_sub_nest_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__call_sub_nest_sum;
    exception_flag = SPPRECOMPILE__TestCase__Sub__call_sub_nest_sum(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_nest";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L18: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[2]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_nest_sum(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L3: // INIT_INT
  int_vars[5] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_barray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_barray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_barray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 658;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_barray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 659;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L16: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L18: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_barray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L20: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L23: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_barray_check(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_barray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L5: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_barray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L15: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_barray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 668;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L21: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L23: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L26: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_barray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 669;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L29: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L40: // INIT_INT
  int_vars[6] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_darray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[1];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_darray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 776;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_darray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 778;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L11: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_darray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 779;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L16: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L18: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_darray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 780;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L20: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L23: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_darray_check(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_darray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 786;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L7: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_darray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 787;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L14: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_darray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 788;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L22: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L23: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L26: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_darray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 789;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L29: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L40: // INIT_INT
  int_vars[6] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_farray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[1];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_farray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 752;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_farray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 754;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L11: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_farray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 755;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L16: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L18: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_farray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 756;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L20: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L23: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_farray_check(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_farray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 762;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L7: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_farray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 763;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L14: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_farray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 764;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L22: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L23: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L26: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_farray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 765;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L29: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L40: // INIT_INT
  int_vars[6] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_iarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_iarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 704;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_INT
  int_vars[3] = int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_iarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L11: // MOVE_INT
  int_vars[3] = int_vars[2];
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_iarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 707;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L16: // MOVE_INT
  int_vars[3] = int_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L18: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_iarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 708;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L20: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L23: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_iarray_check(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[2] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_iarray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 714;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L6: // MOVE_INT
  int_vars[4] = int_vars[3];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_iarray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 715;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L14: // MOVE_INT
  int_vars[5] = int_vars[4];
L15: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_iarray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 716;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L22: // MOVE_INT
  int_vars[5] = int_vars[4];
L23: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L26: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_iarray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 717;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L29: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L40: // INIT_INT
  int_vars[6] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_larray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[1];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_larray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 728;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_larray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 730;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L11: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_larray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 731;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L16: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_larray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 732;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L20: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L23: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_larray_check(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_larray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 738;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L7: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_larray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 739;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L14: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L15: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_larray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 740;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L22: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L23: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L26: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_larray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 741;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L29: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L40: // INIT_INT
  int_vars[6] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_sarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_sarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_sarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 682;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L11: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_sarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 683;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L16: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_sarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 684;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L20: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L23: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_return_sarray_check(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_sarray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 690;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L5: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L7: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L8: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L9: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_sarray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 691;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L15: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L17: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L18: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L19: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L23: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_sarray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 692;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L25: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L27: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L28: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L29: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L32: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_return_sarray_check";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 693;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L35: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L40: // GOTO
  goto L41;
L41: // GOTO
  goto L42;
L42: // GOTO
  goto L43;
L43: // GOTO
  goto L44;
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L48;
L46: // INIT_INT
  int_vars[6] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_sarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // GOTO
  goto L15;
L6: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L7: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[1] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_sarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 605;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L10: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L11: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L15: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_sub_sarray";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 604;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L17: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L6; }
L20: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  goto L23;
L21: // INIT_SHORT
  short_vars[1] = 0;
L22: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[1];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_sub_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L3: // BOOL_INT
  int_vars[0] = int_vars[0];
L4: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L8; }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L12;
L7: // GOTO
  goto L8;
L8: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L12;
L10: // INIT_INT
  int_vars[6] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_void(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_void";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 490;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_void";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 490;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L10: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L13: // CALL_SUB_VOID
  // TestCase::Sub->call_void_sub
  {
    if (SUB_ID_TestCase__Sub__call_void_sub < 0) {
      SUB_ID_TestCase__Sub__call_void_sub = env->get_sub_id(env, "TestCase::Sub", "call_void_sub", "void(int[])");
      if (SUB_ID_TestCase__Sub__call_void_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub call_void_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__call_void_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__call_void_sub(env, stack);
    if (!exception_flag) {
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_void";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_void";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L19: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__call_void_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L4: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[1];
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "call_void_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 487;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L6: // RETURN_VOID
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__cb_obj_call_cb_obj(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon1 < 0) {
      BASIC_TYPE_ID_anon1 = env->get_basic_type_id(env, "anon1");
      if (BASIC_TYPE_ID_anon1 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon1;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L8: // CALL_SUB_INT
  // anon1->
  {
    if (SUB_ID_anon1__ < 0) {
      SUB_ID_anon1__ = env->get_sub_id(env, "anon1", "", "int(self,int,int)");
      if (SUB_ID_anon1__ < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found anon1 ");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_anon1__;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "cb_obj_call_cb_obj";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L11: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L21;
L19: // INIT_INT
  int_vars[7] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__cb_obj_call_cb_obj_from_callback(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon2 < 0) {
      BASIC_TYPE_ID_anon2 = env->get_basic_type_id(env, "anon2");
      if (BASIC_TYPE_ID_anon2 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon2;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L7: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[2];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L10: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L13: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L14: // CALL_METHOD_INT
  // SPVM::Comparator->
  {
    void* object = object_vars[1];
    int32_t call_sub_id = env->get_method_sub_id(env, object, "", "int(self,object,object)");
    if (call_sub_id == 0) {
      void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Comparator ");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "cb_obj_call_cb_obj_from_callback";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L17: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L29;
L27: // INIT_INT
  int_vars[7] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L29;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__cb_obj_capture(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture1 < 0, 0)) {
      FIELD_ID_anon0__capture1 = env->get_field_id(env, "anon0", "capture1", "int");
      if (FIELD_ID_anon0__capture1 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture1 = env->get_field_offset(env, FIELD_ID_anon0__capture1);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture1) = int_vars[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "cb_obj_capture";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L7: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture2 < 0, 0)) {
      FIELD_ID_anon0__capture2 = env->get_field_id(env, "anon0", "capture2", "int");
      if (FIELD_ID_anon0__capture2 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture2 = env->get_field_offset(env, FIELD_ID_anon0__capture2);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture2) = int_vars[3];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "cb_obj_capture";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L10: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L13: // PUSH_ARG_UNDEF
  *(void**)&stack[1] = NULL;
L14: // PUSH_ARG_UNDEF
  *(void**)&stack[2] = NULL;
L15: // CALL_SUB_INT
  // anon0->
  {
    if (SUB_ID_anon0__ < 0) {
      SUB_ID_anon0__ = env->get_sub_id(env, "anon0", "", "int(self,object,object)");
      if (SUB_ID_anon0__ < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found anon0 ");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_anon0__;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "cb_obj_capture";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L20;
L18: // INIT_INT
  int_vars[6] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // TestCase::Sub->default_return_value_byte_sub
  {
    if (SUB_ID_TestCase__Sub__default_return_value_byte_sub < 0) {
      SUB_ID_TestCase__Sub__default_return_value_byte_sub = env->get_sub_id(env, "TestCase::Sub", "default_return_value_byte_sub", "byte()");
      if (SUB_ID_TestCase__Sub__default_return_value_byte_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_byte_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_byte_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_byte_sub(env, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_byte";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // CALL_SUB_BYTE
  // TestCase::Sub->default_return_value_byte_sub_empty
  {
    if (SUB_ID_TestCase__Sub__default_return_value_byte_sub_empty < 0) {
      SUB_ID_TestCase__Sub__default_return_value_byte_sub_empty = env->get_sub_id(env, "TestCase::Sub", "default_return_value_byte_sub_empty", "byte()");
      if (SUB_ID_TestCase__Sub__default_return_value_byte_sub_empty < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_byte_sub_empty");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_byte_sub_empty;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_byte_sub_empty(env, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_byte";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 375;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_byte_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // INIT_BYTE
  byte_vars[0] = 0;
L3: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_byte_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[2];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_BYTE
  byte_vars[0] = 0;
L2: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  goto L3;
L3: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // TestCase::Sub->default_return_value_double_sub
  {
    if (SUB_ID_TestCase__Sub__default_return_value_double_sub < 0) {
      SUB_ID_TestCase__Sub__default_return_value_double_sub = env->get_sub_id(env, "TestCase::Sub", "default_return_value_double_sub", "double()");
      if (SUB_ID_TestCase__Sub__default_return_value_double_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_double_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_double_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_double_sub(env, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_double";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // CALL_SUB_DOUBLE
  // TestCase::Sub->default_return_value_double_sub_empty
  {
    if (SUB_ID_TestCase__Sub__default_return_value_double_sub_empty < 0) {
      SUB_ID_TestCase__Sub__default_return_value_double_sub_empty = env->get_sub_id(env, "TestCase::Sub", "default_return_value_double_sub_empty", "double()");
      if (SUB_ID_TestCase__Sub__default_return_value_double_sub_empty < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_double_sub_empty");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_double_sub_empty;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_double_sub_empty(env, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_double";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L12: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_double_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // INIT_DOUBLE
  double_vars[0] = 0;
L3: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_double_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[2];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_DOUBLE
  double_vars[0] = 0;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L3;
L3: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // TestCase::Sub->default_return_value_float_sub
  {
    if (SUB_ID_TestCase__Sub__default_return_value_float_sub < 0) {
      SUB_ID_TestCase__Sub__default_return_value_float_sub = env->get_sub_id(env, "TestCase::Sub", "default_return_value_float_sub", "float()");
      if (SUB_ID_TestCase__Sub__default_return_value_float_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_float_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_float_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_float_sub(env, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_float";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 438;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[1];
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // CALL_SUB_FLOAT
  // TestCase::Sub->default_return_value_float_sub_empty
  {
    if (SUB_ID_TestCase__Sub__default_return_value_float_sub_empty < 0) {
      SUB_ID_TestCase__Sub__default_return_value_float_sub_empty = env->get_sub_id(env, "TestCase::Sub", "default_return_value_float_sub_empty", "float()");
      if (SUB_ID_TestCase__Sub__default_return_value_float_sub_empty < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_float_sub_empty");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_float_sub_empty;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_float_sub_empty(env, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_float";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 439;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L12: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_float_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // INIT_FLOAT
  float_vars[0] = 0;
L3: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_float_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[2];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_FLOAT
  float_vars[0] = 0;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L3;
L3: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // TestCase::Sub->default_return_value_int_sub
  {
    if (SUB_ID_TestCase__Sub__default_return_value_int_sub < 0) {
      SUB_ID_TestCase__Sub__default_return_value_int_sub = env->get_sub_id(env, "TestCase::Sub", "default_return_value_int_sub", "int()");
      if (SUB_ID_TestCase__Sub__default_return_value_int_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_int_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_int_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_int_sub(env, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_int";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 406;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L4: // MOVE_INT
  int_vars[3] = int_vars[2];
L5: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // CALL_SUB_INT
  // TestCase::Sub->default_return_value_int_sub_empty
  {
    if (SUB_ID_TestCase__Sub__default_return_value_int_sub_empty < 0) {
      SUB_ID_TestCase__Sub__default_return_value_int_sub_empty = env->get_sub_id(env, "TestCase::Sub", "default_return_value_int_sub_empty", "int()");
      if (SUB_ID_TestCase__Sub__default_return_value_int_sub_empty < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_int_sub_empty");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_int_sub_empty;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_int_sub_empty(env, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_int";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 407;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // MOVE_INT
  int_vars[4] = int_vars[3];
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_int_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // INIT_INT
  int_vars[2] = 0;
L3: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_int_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L3;
L3: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // TestCase::Sub->default_return_value_long_sub
  {
    if (SUB_ID_TestCase__Sub__default_return_value_long_sub < 0) {
      SUB_ID_TestCase__Sub__default_return_value_long_sub = env->get_sub_id(env, "TestCase::Sub", "default_return_value_long_sub", "long()");
      if (SUB_ID_TestCase__Sub__default_return_value_long_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_long_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_long_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_long_sub(env, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_long";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[1];
L5: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // CALL_SUB_LONG
  // TestCase::Sub->default_return_value_long_sub_empty
  {
    if (SUB_ID_TestCase__Sub__default_return_value_long_sub_empty < 0) {
      SUB_ID_TestCase__Sub__default_return_value_long_sub_empty = env->get_sub_id(env, "TestCase::Sub", "default_return_value_long_sub_empty", "long()");
      if (SUB_ID_TestCase__Sub__default_return_value_long_sub_empty < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_long_sub_empty");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_long_sub_empty;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_long_sub_empty(env, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_long";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L12: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_long_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[1];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // INIT_LONG
  long_vars[0] = 0;
L3: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_long_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[1];
  int32_t int_vars[2];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_LONG
  long_vars[0] = 0;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L3;
L3: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Sub->default_return_value_object_sub
  {
    if (SUB_ID_TestCase__Sub__default_return_value_object_sub < 0) {
      SUB_ID_TestCase__Sub__default_return_value_object_sub = env->get_sub_id(env, "TestCase::Sub", "default_return_value_object_sub", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Sub__default_return_value_object_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_object_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_object_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_object_sub(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_object";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L4: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // CALL_SUB_OBJECT
  // TestCase::Sub->default_return_value_object_sub_empty
  {
    if (SUB_ID_TestCase__Sub__default_return_value_object_sub_empty < 0) {
      SUB_ID_TestCase__Sub__default_return_value_object_sub_empty = env->get_sub_id(env, "TestCase::Sub", "default_return_value_object_sub_empty", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Sub__default_return_value_object_sub_empty < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_object_sub_empty");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_object_sub_empty;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_object_sub_empty(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_object";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L11: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L14: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L17: // GOTO
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // GOTO
  goto L21;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_object_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L4: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L5;
L5: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L6: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_object_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[2];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L4;
L4: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L5: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // TestCase::Sub->default_return_value_short_sub
  {
    if (SUB_ID_TestCase__Sub__default_return_value_short_sub < 0) {
      SUB_ID_TestCase__Sub__default_return_value_short_sub = env->get_sub_id(env, "TestCase::Sub", "default_return_value_short_sub", "short()");
      if (SUB_ID_TestCase__Sub__default_return_value_short_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_short_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_short_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_short_sub(env, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_short";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L3: // CONVERT_SHORT_TO_INT
  int_vars[1] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[2];
L6: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L10: // CALL_SUB_SHORT
  // TestCase::Sub->default_return_value_short_sub_empty
  {
    if (SUB_ID_TestCase__Sub__default_return_value_short_sub_empty < 0) {
      SUB_ID_TestCase__Sub__default_return_value_short_sub_empty = env->get_sub_id(env, "TestCase::Sub", "default_return_value_short_sub_empty", "short()");
      if (SUB_ID_TestCase__Sub__default_return_value_short_sub_empty < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub default_return_value_short_sub_empty");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__default_return_value_short_sub_empty;
    exception_flag = SPPRECOMPILE__TestCase__Sub__default_return_value_short_sub_empty(env, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "default_return_value_short";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 391;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L12: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L15: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L16: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L21: // GOTO
  goto L22;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_short_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // INIT_SHORT
  short_vars[0] = 0;
L3: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__default_return_value_short_sub_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[2];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_SHORT
  short_vars[0] = 0;
L2: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  goto L3;
L3: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__push_arg_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_ARG_UNDEF
  *(void**)&stack[0] = NULL;
L3: // CALL_SUB_OBJECT
  // TestCase::Sub->sub_push_arg_undef
  {
    if (SUB_ID_TestCase__Sub__sub_push_arg_undef < 0) {
      SUB_ID_TestCase__Sub__sub_push_arg_undef = env->get_sub_id(env, "TestCase::Sub", "sub_push_arg_undef", "TestCase::Minimal(TestCase::Minimal)");
      if (SUB_ID_TestCase__Sub__sub_push_arg_undef < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub sub_push_arg_undef");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__sub_push_arg_undef;
    exception_flag = SPPRECOMPILE__TestCase__Sub__sub_push_arg_undef(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "push_arg_undef";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L5: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_automatical_numeric_convertion(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // TestCase::Sub->test_return_value_automatical_numeric_convertion_widening
  {
    if (SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_widening < 0) {
      SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_widening = env->get_sub_id(env, "TestCase::Sub", "test_return_value_automatical_numeric_convertion_widening", "double()");
      if (SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_widening < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub test_return_value_automatical_numeric_convertion_widening");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_widening;
    exception_flag = SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_widening(env, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_automatical_numeric_convertion";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L4: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L9: // GOTO
  goto L10;
L10: // CALL_SUB_BYTE
  // TestCase::Sub->test_return_value_automatical_numeric_convertion_narrowing_byte
  {
    if (SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_byte < 0) {
      SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_byte = env->get_sub_id(env, "TestCase::Sub", "test_return_value_automatical_numeric_convertion_narrowing_byte", "byte()");
      if (SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_byte < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub test_return_value_automatical_numeric_convertion_narrowing_byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_byte;
    exception_flag = SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_byte(env, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_automatical_numeric_convertion";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L12: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L19: // GOTO
  goto L20;
L20: // CALL_SUB_SHORT
  // TestCase::Sub->test_return_value_automatical_numeric_convertion_narrowing_short
  {
    if (SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_short < 0) {
      SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_short = env->get_sub_id(env, "TestCase::Sub", "test_return_value_automatical_numeric_convertion_narrowing_short", "short()");
      if (SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_short < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub test_return_value_automatical_numeric_convertion_narrowing_short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_short;
    exception_flag = SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_short(env, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_automatical_numeric_convertion";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L22: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 32767;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[5];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_MULNUM_BYTE
  // TestCase::Sub->return_value_byte_sub
  {
    if (SUB_ID_TestCase__Sub__return_value_byte_sub < 0) {
      SUB_ID_TestCase__Sub__return_value_byte_sub = env->get_sub_id(env, "TestCase::Sub", "return_value_byte_sub", "TestCase::Point_3b()");
      if (SUB_ID_TestCase__Sub__return_value_byte_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub return_value_byte_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__return_value_byte_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__return_value_byte_sub(env, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
      byte_vars[1] = *(int8_t*)&stack[1];
      byte_vars[2] = *(int8_t*)&stack[2];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_byte";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 228;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L3: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[0];
L4: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L5: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[4] = *(int8_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_byte";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L7: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[4];
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L11: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[1];
L12: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L17: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[2];
L18: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L20: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L32;
L25: // GOTO
  goto L26;
L26: // GOTO
  goto L27;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L30: // INIT_INT
  int_vars[6] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_byte_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[7];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_BYTE
  byte_vars[0] = 0;
  byte_vars[1] = 0;
  byte_vars[2] = 0;
L2: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_byte_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // MULNUM_SET_FIELD_BYTE
  byte_vars[0] = byte_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L7: // MULNUM_SET_FIELD_BYTE
  byte_vars[1] = byte_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L10: // MULNUM_SET_FIELD_BYTE
  byte_vars[2] = byte_vars[3];
L11: // RETURN_MULNUM_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  *(int8_t*)&stack[1] = byte_vars[1];
  *(int8_t*)&stack[2] = byte_vars[2];
  goto L14;
L12: // INIT_MULNUM_BYTE
  byte_vars[4] = 0;
  byte_vars[5] = 0;
  byte_vars[6] = 0;
L13: // RETURN_MULNUM_BYTE
  *(int8_t*)&stack[0] = byte_vars[4];
  *(int8_t*)&stack[1] = byte_vars[5];
  *(int8_t*)&stack[2] = byte_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_MULNUM_DOUBLE
  // TestCase::Sub->return_value_double_sub
  {
    if (SUB_ID_TestCase__Sub__return_value_double_sub < 0) {
      SUB_ID_TestCase__Sub__return_value_double_sub = env->get_sub_id(env, "TestCase::Sub", "return_value_double_sub", "TestCase::Point_3d()");
      if (SUB_ID_TestCase__Sub__return_value_double_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub return_value_double_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__return_value_double_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__return_value_double_sub(env, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
      double_vars[1] = *(double*)&stack[1];
      double_vars[2] = *(double*)&stack[2];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_double";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[0];
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_double";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 345;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L6: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[4]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L9: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[1];
L10: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.25;
L11: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[4]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L14: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[2];
L15: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.5;
L16: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[4]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L21: // GOTO
  goto L22;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_double_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[7];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
  double_vars[2] = 0;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_double_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L4: // MULNUM_SET_FIELD_DOUBLE
  double_vars[0] = double_vars[3];
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.25;
L6: // MULNUM_SET_FIELD_DOUBLE
  double_vars[1] = double_vars[3];
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.5;
L8: // MULNUM_SET_FIELD_DOUBLE
  double_vars[2] = double_vars[3];
L9: // RETURN_MULNUM_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  *(double*)&stack[1] = double_vars[1];
  *(double*)&stack[2] = double_vars[2];
  goto L12;
L10: // INIT_MULNUM_DOUBLE
  double_vars[4] = 0;
  double_vars[5] = 0;
  double_vars[6] = 0;
L11: // RETURN_MULNUM_DOUBLE
  *(double*)&stack[0] = double_vars[4];
  *(double*)&stack[1] = double_vars[5];
  *(double*)&stack[2] = double_vars[6];
  goto L12;
L12: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_MULNUM_FLOAT
  // TestCase::Sub->return_value_float_sub
  {
    if (SUB_ID_TestCase__Sub__return_value_float_sub < 0) {
      SUB_ID_TestCase__Sub__return_value_float_sub = env->get_sub_id(env, "TestCase::Sub", "return_value_float_sub", "TestCase::Point_3f()");
      if (SUB_ID_TestCase__Sub__return_value_float_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub return_value_float_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__return_value_float_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__return_value_float_sub(env, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
      float_vars[1] = *(float*)&stack[1];
      float_vars[2] = *(float*)&stack[2];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_float";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 320;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[0];
L4: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_float";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L6: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[4]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L9: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[1];
L10: // MOVE_CONSTANT_FLOAT
  float_vars[4] = 0.25;
L11: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[4]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L14: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[2];
L15: // MOVE_CONSTANT_FLOAT
  float_vars[4] = 0.5;
L16: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[4]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L21: // GOTO
  goto L22;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_float_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[7];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_FLOAT
  float_vars[0] = 0;
  float_vars[1] = 0;
  float_vars[2] = 0;
L2: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_float_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L4: // MULNUM_SET_FIELD_FLOAT
  float_vars[0] = float_vars[3];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.25;
L6: // MULNUM_SET_FIELD_FLOAT
  float_vars[1] = float_vars[3];
L7: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.5;
L8: // MULNUM_SET_FIELD_FLOAT
  float_vars[2] = float_vars[3];
L9: // RETURN_MULNUM_FLOAT
  *(float*)&stack[0] = float_vars[0];
  *(float*)&stack[1] = float_vars[1];
  *(float*)&stack[2] = float_vars[2];
  goto L12;
L10: // INIT_MULNUM_FLOAT
  float_vars[4] = 0;
  float_vars[5] = 0;
  float_vars[6] = 0;
L11: // RETURN_MULNUM_FLOAT
  *(float*)&stack[0] = float_vars[4];
  *(float*)&stack[1] = float_vars[5];
  *(float*)&stack[2] = float_vars[6];
  goto L12;
L12: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_MULNUM_INT
  // TestCase::Sub->return_value_int_sub
  {
    if (SUB_ID_TestCase__Sub__return_value_int_sub < 0) {
      SUB_ID_TestCase__Sub__return_value_int_sub = env->get_sub_id(env, "TestCase::Sub", "return_value_int_sub", "TestCase::Point_3i()");
      if (SUB_ID_TestCase__Sub__return_value_int_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub return_value_int_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__return_value_int_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__return_value_int_sub(env, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
      int_vars[2] = *(int32_t*)&stack[1];
      int_vars[3] = *(int32_t*)&stack[2];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_int";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[1];
L4: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_int";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L6: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L9: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[2];
L10: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L11: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L14: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[3];
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L16: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L28;
L21: // GOTO
  goto L22;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L26: // INIT_INT
  int_vars[9] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_int_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_INT
  int_vars[1] = 0;
  int_vars[2] = 0;
  int_vars[3] = 0;
L2: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_int_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 266;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L4: // MULNUM_SET_FIELD_INT
  int_vars[1] = int_vars[5];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L6: // MULNUM_SET_FIELD_INT
  int_vars[2] = int_vars[5];
L7: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L8: // MULNUM_SET_FIELD_INT
  int_vars[3] = int_vars[5];
L9: // RETURN_MULNUM_INT
  *(int32_t*)&stack[0] = int_vars[1];
  *(int32_t*)&stack[1] = int_vars[2];
  *(int32_t*)&stack[2] = int_vars[3];
  goto L12;
L10: // INIT_MULNUM_INT
  int_vars[6] = 0;
  int_vars[7] = 0;
  int_vars[8] = 0;
L11: // RETURN_MULNUM_INT
  *(int32_t*)&stack[0] = int_vars[6];
  *(int32_t*)&stack[1] = int_vars[7];
  *(int32_t*)&stack[2] = int_vars[8];
  goto L12;
L12: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_MULNUM_LONG
  // TestCase::Sub->return_value_long_sub
  {
    if (SUB_ID_TestCase__Sub__return_value_long_sub < 0) {
      SUB_ID_TestCase__Sub__return_value_long_sub = env->get_sub_id(env, "TestCase::Sub", "return_value_long_sub", "TestCase::Point_3l()");
      if (SUB_ID_TestCase__Sub__return_value_long_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub return_value_long_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__return_value_long_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__return_value_long_sub(env, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
      long_vars[1] = *(int64_t*)&stack[1];
      long_vars[2] = *(int64_t*)&stack[2];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_long";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L3: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[0];
L4: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[4] = *(int64_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_long";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L6: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[4]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L9: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[1];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L12: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[4]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[2];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L17: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L18: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[4]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L30;
L23: // GOTO
  goto L24;
L24: // GOTO
  goto L25;
L25: // GOTO
  goto L26;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L30;
L28: // INIT_INT
  int_vars[6] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L30;
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_long_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[7];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_LONG
  long_vars[0] = 0;
  long_vars[1] = 0;
  long_vars[2] = 0;
L2: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_long_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // MULNUM_SET_FIELD_LONG
  long_vars[0] = long_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L7: // MULNUM_SET_FIELD_LONG
  long_vars[1] = long_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L10: // MULNUM_SET_FIELD_LONG
  long_vars[2] = long_vars[3];
L11: // RETURN_MULNUM_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  *(int64_t*)&stack[1] = long_vars[1];
  *(int64_t*)&stack[2] = long_vars[2];
  goto L14;
L12: // INIT_MULNUM_LONG
  long_vars[4] = 0;
  long_vars[5] = 0;
  long_vars[6] = 0;
L13: // RETURN_MULNUM_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  *(int64_t*)&stack[1] = long_vars[5];
  *(int64_t*)&stack[2] = long_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[5];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_MULNUM_SHORT
  // TestCase::Sub->return_value_short_sub
  {
    if (SUB_ID_TestCase__Sub__return_value_short_sub < 0) {
      SUB_ID_TestCase__Sub__return_value_short_sub = env->get_sub_id(env, "TestCase::Sub", "return_value_short_sub", "TestCase::Point_3s()");
      if (SUB_ID_TestCase__Sub__return_value_short_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub return_value_short_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__return_value_short_sub;
    exception_flag = SPPRECOMPILE__TestCase__Sub__return_value_short_sub(env, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
      short_vars[1] = *(int16_t*)&stack[1];
      short_vars[2] = *(int16_t*)&stack[2];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_short";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L3: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[0];
L4: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[4] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_short";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L7: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[4];
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L11: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[1];
L12: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L17: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[2];
L18: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L20: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L32;
L25: // GOTO
  goto L26;
L26: // GOTO
  goto L27;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L30: // INIT_INT
  int_vars[6] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__return_value_short_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[7];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_SHORT
  short_vars[0] = 0;
  short_vars[1] = 0;
  short_vars[2] = 0;
L2: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "return_value_short_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // MULNUM_SET_FIELD_SHORT
  short_vars[0] = short_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L7: // MULNUM_SET_FIELD_SHORT
  short_vars[1] = short_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L10: // MULNUM_SET_FIELD_SHORT
  short_vars[2] = short_vars[3];
L11: // RETURN_MULNUM_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  *(int16_t*)&stack[1] = short_vars[1];
  *(int16_t*)&stack[2] = short_vars[2];
  goto L14;
L12: // INIT_MULNUM_SHORT
  short_vars[4] = 0;
  short_vars[5] = 0;
  short_vars[6] = 0;
L13: // RETURN_MULNUM_SHORT
  *(int16_t*)&stack[0] = short_vars[4];
  *(int16_t*)&stack[1] = short_vars[5];
  *(int16_t*)&stack[2] = short_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__sub_push_arg_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__sum_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L3: // INIT_INT
  int_vars[6] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__test_import_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // TestCase::Simple->import_sub1
  {
    if (SUB_ID_TestCase__Simple__import_sub1 < 0) {
      SUB_ID_TestCase__Simple__import_sub1 = env->get_sub_id(env, "TestCase::Simple", "import_sub1", "int()");
      if (SUB_ID_TestCase__Simple__import_sub1 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple import_sub1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__import_sub1;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_import_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L9: // GOTO
  goto L10;
L10: // CALL_SUB_INT
  // TestCase::Simple->import_sub2
  {
    if (SUB_ID_TestCase__Simple__import_sub2 < 0) {
      SUB_ID_TestCase__Simple__import_sub2 = env->get_sub_id(env, "TestCase::Simple", "import_sub2", "int()");
      if (SUB_ID_TestCase__Simple__import_sub2 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple import_sub2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__import_sub2;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_import_sub";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L13: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 127;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  goto L6;
L4: // INIT_BYTE
  byte_vars[1] = 0;
L5: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_narrowing_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32767;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  goto L6;
L4: // INIT_SHORT
  short_vars[1] = 0;
L5: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__test_return_value_automatical_numeric_convertion_widening(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L6;
L4: // INIT_DOUBLE
  double_vars[1] = 0;
L5: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__test_vaarg_objects_pass_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L5: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L86;
L12: // GOTO
  goto L13;
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L17: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L86;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L25: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L27: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[5] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L33: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L36: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L38: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[3] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L41: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L46: // BOOL_INT
  int_vars[0] = int_vars[2];
L47: // GOTO
  goto L50;
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L49: // BOOL_INT
  int_vars[0] = int_vars[3];
L50: // GOTO
  goto L54;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L53: // BOOL_INT
  int_vars[0] = int_vars[4];
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L58: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L60: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[3] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L63: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // BOOL_INT
  int_vars[0] = int_vars[2];
L69: // GOTO
  goto L72;
L70: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L71: // BOOL_INT
  int_vars[0] = int_vars[3];
L72: // GOTO
  goto L76;
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[4];
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L86;
L80: // GOTO
  goto L81;
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L86;
L84: // INIT_INT
  int_vars[6] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L86;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__test_vaarg_objects_pass_each_values(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L5: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 96;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L86;
L12: // GOTO
  goto L13;
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L17: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L86;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L25: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L27: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[5] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L33: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L36: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L38: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[3] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L41: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L46: // BOOL_INT
  int_vars[0] = int_vars[2];
L47: // GOTO
  goto L50;
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L49: // BOOL_INT
  int_vars[0] = int_vars[3];
L50: // GOTO
  goto L54;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L53: // BOOL_INT
  int_vars[0] = int_vars[4];
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L58: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L60: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[3] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L63: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // BOOL_INT
  int_vars[0] = int_vars[2];
L69: // GOTO
  goto L72;
L70: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L71: // BOOL_INT
  int_vars[0] = int_vars[3];
L72: // GOTO
  goto L76;
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[4];
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L86;
L80: // GOTO
  goto L81;
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L86;
L84: // INIT_INT
  int_vars[6] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L86;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__test_vaarg_pass_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L5: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L12: // GOTO
  goto L13;
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 121;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L17: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L27: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L34: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // BOOL_INT
  int_vars[0] = int_vars[2];
L39: // GOTO
  goto L42;
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[3];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[4];
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L48: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L51: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // BOOL_INT
  int_vars[0] = int_vars[2];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // GOTO
  goto L62;
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L61: // BOOL_INT
  int_vars[0] = int_vars[4];
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L67; }
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L66: // GOTO
  goto L67;
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L69: // INIT_INT
  int_vars[6] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__test_vaarg_pass_each_values(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L5: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L12: // GOTO
  goto L13;
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 142;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L17: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 146;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L27: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 146;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L34: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // BOOL_INT
  int_vars[0] = int_vars[2];
L39: // GOTO
  goto L42;
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[3];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[4];
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L48: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "test_vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 146;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L51: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // BOOL_INT
  int_vars[0] = int_vars[2];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // GOTO
  goto L62;
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L61: // BOOL_INT
  int_vars[0] = int_vars[4];
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L67; }
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L66: // GOTO
  goto L67;
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L69: // INIT_INT
  int_vars[6] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__vaarg_objects_pass_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[2];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[4];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L17: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[6];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object);
  }
L22: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L23: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L27: // CALL_SUB_INT
  // TestCase::Sub->test_vaarg_objects_pass_array
  {
    if (SUB_ID_TestCase__Sub__test_vaarg_objects_pass_array < 0) {
      SUB_ID_TestCase__Sub__test_vaarg_objects_pass_array = env->get_sub_id(env, "TestCase::Sub", "test_vaarg_objects_pass_array", "int(string,object[])");
      if (SUB_ID_TestCase__Sub__test_vaarg_objects_pass_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub test_vaarg_objects_pass_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__test_vaarg_objects_pass_array;
    exception_flag = SPPRECOMPILE__TestCase__Sub__test_vaarg_objects_pass_array(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L32;
L30: // INIT_INT
  int_vars[10] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L32;
L32: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__vaarg_objects_pass_each_values(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[2];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[4];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L17: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[6];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object);
  }
L22: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L23: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L27: // CALL_SUB_INT
  // TestCase::Sub->test_vaarg_objects_pass_each_values
  {
    if (SUB_ID_TestCase__Sub__test_vaarg_objects_pass_each_values < 0) {
      SUB_ID_TestCase__Sub__test_vaarg_objects_pass_each_values = env->get_sub_id(env, "TestCase::Sub", "test_vaarg_objects_pass_each_values", "int(string,object[])");
      if (SUB_ID_TestCase__Sub__test_vaarg_objects_pass_each_values < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub test_vaarg_objects_pass_each_values");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__test_vaarg_objects_pass_each_values;
    exception_flag = SPPRECOMPILE__TestCase__Sub__test_vaarg_objects_pass_each_values(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_objects_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L32;
L30: // INIT_INT
  int_vars[10] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L32;
L32: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__vaarg_pass_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L9: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L16: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L17: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L21: // CALL_SUB_INT
  // TestCase::Sub->test_vaarg_pass_array
  {
    if (SUB_ID_TestCase__Sub__test_vaarg_pass_array < 0) {
      SUB_ID_TestCase__Sub__test_vaarg_pass_array = env->get_sub_id(env, "TestCase::Sub", "test_vaarg_pass_array", "int(string,int[])");
      if (SUB_ID_TestCase__Sub__test_vaarg_pass_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub test_vaarg_pass_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__test_vaarg_pass_array;
    exception_flag = SPPRECOMPILE__TestCase__Sub__test_vaarg_pass_array(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_array";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L26;
L24: // INIT_INT
  int_vars[10] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Sub__vaarg_pass_each_values(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 154;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L9: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 154;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 154;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L16: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L17: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 154;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L21: // CALL_SUB_INT
  // TestCase::Sub->test_vaarg_pass_each_values
  {
    if (SUB_ID_TestCase__Sub__test_vaarg_pass_each_values < 0) {
      SUB_ID_TestCase__Sub__test_vaarg_pass_each_values = env->get_sub_id(env, "TestCase::Sub", "test_vaarg_pass_each_values", "int(string,int[])");
      if (SUB_ID_TestCase__Sub__test_vaarg_pass_each_values < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Sub test_vaarg_pass_each_values");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Sub__test_vaarg_pass_each_values;
    exception_flag = SPPRECOMPILE__TestCase__Sub__test_vaarg_pass_each_values(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Sub";
    const char* sub_name = "vaarg_pass_each_values";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 154;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L26;
L24: // INIT_INT
  int_vars[10] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


