#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder_byte_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder_byte_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder_int_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder_int_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder_int_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder_long_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder_short_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Remainder__remainder_short_short(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Remainder__remainder(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[4];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // REMAINDER_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[5] = int_vars[2] % /* REMAINDER */ int_vars[4];
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L9: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[5];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L12: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L14: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L15: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L16: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L18: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[6];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L20: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L21: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L23: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L24: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L25: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L27: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[6];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L29: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L30: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L32: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L33: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L34: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L36: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[6];
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L39: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[4] = int_vars[2] % /* REMAINDER */ int_vars[3];
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L43: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[5] = int_vars[2] % /* REMAINDER */ int_vars[3];
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 127;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L45: // MOVE_CONSTANT_LONG
  long_vars[0] = 5LL;
L46: // MOVE_CONSTANT_LONG
  long_vars[1] = 3LL;
L47: // REMAINDER_LONG
  if (__builtin_expect(long_vars[1] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    long_vars[2] = long_vars[0] % /* REMAINDER */ long_vars[1];
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L49: // MOVE_CONSTANT_LONG
  long_vars[0] = -3LL;
L50: // MOVE_CONSTANT_LONG
  long_vars[1] = 5LL;
L51: // REMAINDER_LONG
  if (__builtin_expect(long_vars[1] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    long_vars[3] = long_vars[0] % /* REMAINDER */ long_vars[1];
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L53: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L55: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L58: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L59: // MOVE_CONSTANT_INT
  int_vars[3] = -3;
L60: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L63: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L65: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L68: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L69: // MOVE_CONSTANT_INT
  int_vars[3] = -3;
L70: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L71: // BOOL_INT
  int_vars[0] = int_vars[0];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L74: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L78: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L81: // MOVE_CONSTANT_LONG
  long_vars[0] = 2LL;
L82: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L85: // MOVE_CONSTANT_LONG
  long_vars[0] = -3LL;
L86: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L103;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L101: // INIT_INT
  int_vars[8] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L103;
L103: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Remainder__remainder_byte_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // REMAINDER_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[5] = int_vars[2] % /* REMAINDER */ int_vars[4];
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder_byte_byte";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 7;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[4];
L18: // MOVE_INT
  int_vars[0] = int_vars[0];
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Remainder__remainder_byte_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -5;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[4] = int_vars[2] % /* REMAINDER */ int_vars[3];
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder_byte_int";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 63;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = -2;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Remainder__remainder_int_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 12;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L4: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L5: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[4] = int_vars[1] % /* REMAINDER */ int_vars[3];
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder_int_byte";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Remainder__remainder_int_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1000000000;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L3: // REMAINDER_INT
  if (__builtin_expect(int_vars[2] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[3] = int_vars[1] % /* REMAINDER */ int_vars[2];
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder_int_int";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[5];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L24;
L22: // INIT_INT
  int_vars[7] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Remainder__remainder_int_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L4: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L5: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[4] = int_vars[1] % /* REMAINDER */ int_vars[3];
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder_int_short";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 49;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Remainder__remainder_long_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 100000000001LL;
L2: // MOVE_CONSTANT_LONG
  long_vars[1] = 2LL;
L3: // REMAINDER_LONG
  if (__builtin_expect(long_vars[1] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    long_vars[2] = long_vars[0] % /* REMAINDER */ long_vars[1];
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder_long_long";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Remainder__remainder_short_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = -3;
L5: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[4] = int_vars[2] % /* REMAINDER */ int_vars[3];
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder_short_int";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Remainder__remainder_short_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // REMAINDER_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[5] = int_vars[2] % /* REMAINDER */ int_vars[4];
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Remainder";
    const char* sub_name = "remainder_short_short";
    const char* file = "TestCase/Remainder.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[4];
L18: // MOVE_INT
  int_vars[0] = int_vars[0];
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


