
use strict;
use warnings;

use 5.010;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'develop perl modules with git-flow and Dist::Zilla',
  'AUTHOR' => 'Keedi Kim - 김도형 <keedi@cpan.org>',
  'BUILD_REQUIRES' => {
    'Test::More' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'Dist-Zilla-Plugin-GitFlow',
  'EXE_FILES' => [],
  'LICENSE' => 'perl',
  'NAME' => 'Dist::Zilla::Plugin::GitFlow',
  'PREREQ_PM' => {
    'Class::MOP' => '0',
    'Dist::Zilla' => '4',
    'Dist::Zilla::Plugin::Git' => '0',
    'Dist::Zilla::Plugin::NextRelease' => '0',
    'Dist::Zilla::Role::AfterMint' => '0',
    'Dist::Zilla::Role::PluginBundle' => '0',
    'Dist::Zilla::Role::VersionProvider' => '0',
    'Git::Wrapper' => '0',
    'Moose' => '0',
    'String::Formatter' => '0',
    'Try::Tiny' => '0',
    'Version::Next' => '0',
    'namespace::autoclean' => '0.09',
    'version' => '0.80'
  },
  'VERSION' => '0.008',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



