#ifndef DENDRITE_GROUP_H
#define DENDRITE_GROUP_H

#include <stdio.h>
#include <arch/neuron.h>
#include <utils/real.h>

class neuron;

class synaptic_arc {
    private:
        char name[255];

    public:
        real weight;
        real eligibility;
        neuron *dendrilitic_neuron;
        neuron *fireing_neuron;

        synaptic_arc(neuron *dendrilitic, neuron *fireing);
        char *query_name();
};

class synaptic_node {
    public:
        synaptic_arc  *my_arc;
        synaptic_node *next;

        synaptic_node(neuron *dendrilitic, neuron *fireing);
        synaptic_node(synaptic_arc *arc);
};

class synaptic_group {
    private:
        char name[255];
        real *weights;
        synaptic_node *head;
        synaptic_node *current_node;

        // These need friends:
        void    add_existing_arc(synaptic_arc *arc);
 //       void recalc_needed_upward();

        // These are the friends:
        friend synaptic_arc::synaptic_arc(neuron *dendrilitic, neuron *fireing);
//        friend neuron::recalc_needed();

    public:
        int size;

        synaptic_group(char *n);

//      This should be private ... irritating, since ya can't have cicular
//      friends...
        void recalc_needed_upward();

        void    add_weight_for(neuron *dendrilitic, neuron *fireing);
        real  sum_of_outputs();
        real  weighted_sum_of_delta_from_above();
        void    start_foreach();
        void    next_weight();
        void    next_eligibility();
        int     has_a_weight();
        int     has_an_eligibility();
        void    set_current_weight_to(real d);
        void    set_weights_to(real *d);
        void    change_current_weight_by(real d);
        void    change_weights_by(real *d);
        void    change_current_eligibility_by(real d);
        void    set_current_eligibility_to(real d);
        char *query_current_name();
        real  query_current_weight();
        real  query_current_eligibility();
        real  query_current_fireing_output();
        real  query_current_dendrilitic_output();
        real *query_weights();

        void reinitialize_weights_with(real max, real min);

        void    save_weights(FILE *F);
        void restore_weights(FILE *F);
};

#endif
