use strict;
use warnings FATAL => 'all';

package MarpaX::Java::ClassFile::Common::BNF;

# ABSTRACT: Provides common BNF top and header contents

our $VERSION = '0.001'; # TRIAL VERSION

our $AUTHORITY = 'cpan:JDDPAUSE'; # AUTHORITY

use Data::Section -setup;
use Exporter 'import';


our @EXPORT_OK = qw/bnf/;

my $_bnf_top    = ${__PACKAGE__->section_data('bnf_top')};
my $_bnf_bottom = ${__PACKAGE__->section_data('bnf_bottom')};

#
# Class method
#
sub bnf {
  my ($class, $bnf) = @_;
  join('', $_bnf_top, $bnf, $_bnf_bottom)
}

1;

=pod

=encoding UTF-8

=head1 NAME

MarpaX::Java::ClassFile::Common::BNF - Provides common BNF top and header contents

=head1 VERSION

version 0.001

=head1 DESCRIPTION

MarpaX::Java::ClassFile::Common::BNF is an internal class used by L<MarpaX::Java::ClassFile>, please refer to the later.

=head1 AUTHOR

Jean-Damien Durand <jeandamiendurand@free.fr>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Jean-Damien Durand.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
__[ bnf_top ]__
#
# latm is a sane default that can be common to all grammars
#
lexeme default = latm => 1
#
# This is more dangerous, but let's say we know what we are doing.
#
inaccessible is ok by default

__[ bnf_bottom ]__
########################################
#           Common rules               #
########################################
u1      ::= U1                 action => u1
u2      ::= U2                 action => u2
u4      ::= U4                 action => u4
managed ::= MANAGED            action => ::first

# ----------------
# Internal Lexemes
# ----------------
_U1      ~ [\s\S]
_U2      ~ _U1 _U1
_U4      ~ _U2 _U2
_MANAGED ~ [^\s\S]

########################################
#          Common lexemes              #
########################################
U1      ~ _U1
U2      ~ _U2
U4      ~ _U4
MANAGED ~ _MANAGED
