use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name         => '<tmpl_var main_module>',
    license             => '<tmpl_var license>',
    dist_author         => '<tmpl_var author> <<tmpl_var email>>',
    dist_version_from   => '<tmpl_var main_pm_file>',
    tmpl_files          => eval {
        my %tmpls; File::Find::find(
            {
                wanted => sub {
                    if ( -f $_ ) {
                        $tmpls{$File::Find::name} = $File::Find::name;
                    }
                },
            },
            '<tmpl_var templatedir>',
        );
        return \%tmpls;
    },
    build_requires => {
        'Test::More'                    => 0,
        'Test::WWW::Mechanize::CGIApp'  => 0,
    },
    requires => {
        'CGI::Application'              => 4.04,
        'HTML::Template'                => 0,
    },
    add_to_cleanup      => [ '<tmpl_var distro>-*' ],
    create_makefile_pl  => 'traditional',
    sign                => 1,
);

$builder->add_build_element('tmpl');
$builder->create_build_script();

