class M68kROMAgent is Agent 
{
	has $.romdb;

	has $.machinecodedb;
	
	method BUILD($stat) {
		super.BUILD($stat);

		.romdb = new ROMDB();	
		.machinecodedb = new M68kasmDB();
	}

	### add a key value pair such as "Dwarrendelf", "binary ROM file in a bytearray or something"
	method add_to_rom_db($key, value) {
		.romdb.add($key,$value);
	}

	method add_music(%args) {
		for %args.kv -> $key, $value {
			self.add_to_rom_db($key, $value);
		}
	}

	method list_romdb_keys() {
		return .romdb.list_keys();	
	}

	method ask(%args) {
		my $string = super.ask(%args) . 
				"ask about roms\n" .
				"get roms\n" .
				"add roms\n" .
				"agent\n";
		
		return $string;
	}


	method ask_roms(%args) {
		my $string;

		for %args.kv -> $key,$value {

			if (.romdb.search($key)) {
				$string .= $key;
			}
		}
		return $string;
	}

	method get_roms(%args) {
		my @roms = <>;

		for %args.kv -> $key,$value {
			push(@roms, .romdb.search($key));
		}
		return @roms;
	}

	### write roms to disk (in local directory)

	method deploy_roms(%args) {
		say "Note that you are deploying ROMs or code which might
			be copyrighted. You are owning these files at your 
			own risk. You can have a license to these files and 
			hack them for the company's sake, not your own
			indulgence!\n";

		for %.romdb.kv -> $key,$value {
			my $fh = open "$key", :w;

			if ($fh) {
				print "deploying file in local directory : " . "$key" . "\n";
			} else {
				next;
			}
			$fh.print($value);
			$fh.close();
		}
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process roms or anything from $agent here

		return &$agent.dispatch;
	} 

	method dispatch($msg, %optargs) {
		given $msg {
		when "ask" { self.ask(%optargs) }
		when "ask about roms" { self.ask_roms(%optargs) }
		when "get roms" { self.get_roms(%optargs) }
		when "add roms" { self.add_roms(%optargs) }
		when "list roms" { self.list_romdb_keys(%optargs) } 
		when "deploy roms" { self.deploy_roms(%optargs) } 
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
