#!./perl

BEGIN {
    unless(grep /blib/, @INC) {
        chdir 't' if -d 't';
        @INC = '../lib' if -d '../lib';
    }
}
use Test;
BEGIN { plan tests => 19 }
use SNMP;

my $host = 'localhost';
my $comm = 'private';
my $port = 12000;
my $junk_oid = ".1.3.6.1.2.1.1.1.1.1.1";
my $oid = '.1.3.6.1.2.1.1.1';
my $junk_name = 'fooDescr';
my $junk_host = 'no.host.here';
my $name = "gmarzot\@nortelnetworks.com";

my $snmpd_cmd;

if ((-e "t/snmpd.pid") && (-r "t/snmpd.pid")) {
# Making sure that any running agents are killed.
    system "kill `cat t/snmpd.pid`" > "/dev/null";
}

if (open(CMD,"<t/snmpd.cmd")) {
    ($snmpd_cmd) = (<CMD> =~ /SNMPD => (\S+)\s*/);
    if (-r $snmpd_cmd and -x $snmpd_cmd) {
	system "$snmpd_cmd -r -l t/snmpd.log -C -c t/snmpd.conf -p $port -P t/snmpd.pid";
    } else {
	undef $snmpd_cmd;
    }
    close CMD;
}

$SNMP::debugging = 0;
$n = 15;  # Number of tests to run

#print "1..$n\n";
if ($n == 0) { exit 0; }

# create list of varbinds for GETS, val field can be null or omitted
$vars = new SNMP::VarList (
			   ['sysDescr', '0', ''],
			   ['sysObjectID', '0'],
			   ['sysUpTime', '0'],	
			   ['sysContact', '0'],
			   ['sysName', '0'],
			   ['sysLocation', '0'],
			   ['sysServices', '0'],
			   ['ifNumber', '0'],
			   ['ifDescr', '1'],
			   ['ifSpeed', '1'],
			   
			   ['snmpInPkts', '0'],
			   ['snmpInBadVersions', '0'],
			   ['snmpInBadCommunityNames', '0'],
			   ['snmpInBadCommunityUses', '0'],
			   ['snmpInASNParseErrs', '0'],
			   ['snmpEnableAuthenTraps', '0'],
#			   ['snmpSilentDrops', '0'],
#			   ['snmpProxyDrops', '0'],
#			   ['snmpTrapEnterprise', '2'],

#			   ['hrStorageType', '2'],
#			   ['hrSystemDate', '0'],
			   ['sysORIndex', '1'],
			   ['sysORID', '2'],
			   ['sysORDescr', '3'],
			   ['sysORUpTime', '4'],
#			   ['ifName', '1'],
			   ['sysORLastChange', '0'],
			   ['ipInHdrErrors', '0'],
			   ['ipDefaultTTL', '0'],
			   ['ipInHdrErrors', '0'],
		          );
################################################################
# Yet to do:
# test for the max limit the 'get' can provide. 
# Figure out why the IP and Physical address are not getting printed.
# why ifname is not getting printed?
################################################################
#			   ['ipNetToMediaPhysAddress', '0'],
#			   ['ipAdEntAddr', '0'],
#			   ['snmpTrapOID', '0'],
#			   ['hrSystemNumUsers', '0'],
#			   ['hrFSLastFullBackupDate', '0'],
#			   ['ifPromiscuousMode', '0'],



######################################################################
# Create a bogus session, undef means the host can't be found.
my $s2 = new SNMP::Session ( DestHost => $junk_host );
ok(!defined($s2),1);

######################################################################
# Fire up a session.
my $s1 = new SNMP::Session (DestHost=>$host,Community=>$comm,RemotePort=>$port);
ok(defined($s1),1);
#####################################################################
# if no snmpd then skip dynamic tests
unless ($snmpd_cmd) {
    print STDERR "[no agent running]";
    for (3..$n) {
	skip(1,0);
    }
    exit(0);
}


######################################################################
# Get the standard Vars and check that we got some defined vars back
@ret = $s1->get($vars);
#print STDERR "Error string = $s1->{ErrorStr}:$s1->{ErrorInd}\n";
ok(!$s1->{ErrorStr} and defined($ret[0]));

######################################################################
# Check that we got back the number we asked for.
ok($#ret == $#{$vars});
#print("dude : $#ret\n");
################################################

# Test for a string
$contact = $s1->get('sysContact.0');
#print("contact is : $contact\n");
ok( defined($contact));


$name = $s1->get('sysName.0');
#print("Name is : $name\n");
ok( defined($name));


$location = $s1->get('sysLocation.0');
#print("Location is : $location\n");
ok( defined($location));
#########################################


# Test for an integer
$ttl = $s1->get('ipDefaultTTL.0');
#print("TTL is : $ttl\n");
ok( defined($ttl));
########################################


# Test for a TimeTicks
$time = $s1->get('sysUpTime.0');
#print("up time is : $time hundredths of a second\n");
ok( defined($time));
######################################### 


#Test for a Counter32 type.
$totalDatagramsReceived = $s1->get('ipInHdrErrors.0');
#print("totalDatagramsReceived is : $totalDatagramsReceived\n");
ok( defined($totalDatagramsReceived));
################################################


#Test for a PhysicalAddr type
$physaddr = $s1->get('ipNetToMediaPhysAddress.0');
#print("physical addr is : $physaddr \n");
ok( defined($physaddr));
##############################################


#Test for a IpAddr type
$ipaddr = $s1->get('ipAdEntAddr.0');
#print("Ip address is : $ipaddr \n");
ok( defined($ipaddr));
##############################################


#Test for a OID type
$trapOID = $s1->get('snmpTrapOID.0');
#print("trap OID is : $trapOID $s1->{ErrorStr}\n");
ok( defined($trapOID));
##############################################


#Test for a Gauge type
#$numusers = $s1->get('hrSystemNumUsers.0');
#print("Number of users is : $numusers \n");
#ok( defined($numusers));
##############################################

#nosuchname
#Test for a date & time type
#$datetime = $s1->get('hrFSLastFullBackupDate.0');
#print("Number of users is : $datetime \n");
#ok( defined($datetime));
##############################################

#nosuchname
#Test for a Truth value type
#$mode = $s1->get('ifPromiscuousMode.16');
#print("Truth value(1 true, 2 false) is : $mode \n");
#ok( defined($mode));
##############################################

# Time stamp test
$time = $s1->get('sysORLastChange.0');
#print("time stamp is : $time \n");
ok(defined($time));
#############################################

# Integer test
$index = $s1->get('sysORIndex.0');
#print("index is : $index\n");
ok(defined($index));
#############################################

# OID test
$oid = $s1->get('sysORID.2');
#print("index is : $oid\n");
ok(defined($oid));
#############################################

# String test
$descr = $s1->get('sysORDescr.3');
#print("Sys Descr is : $descr\n");
ok(defined($descr));
#############################################

# string String test
$ifname = $s1->get('ifDescr.1');
#print("ifname is : $ifname $s1->{ErrorStr}\n");
ok(defined($ifname));
#############################################


# Try getting some unknown(wrong ?) data
$unknown = $s1->get('ifmyData.0');
ok(!defined($unknown));
##############################################



system "kill `cat t/snmpd.pid`";


