use strict;

use Text::Editor::Easy;

Text::Editor::Easy->new (
    {
        'sub'      => 'main',    # Sub for action
        'x_offset' => 60,
        'y_offset' => 170,
        'width'    => 500,
        'height'   => 300,
    }
);

print "Fin du programme", threads->tid, "\n";
exit;
print "Fin du programme ...\n";

sub main {
		my ( $editor ) = @_;
		
		
		use Test::More qw( no_plan );
		
		# Full trace thread creation
		print "Full trace thread creation by trace_print call\n";
		my @first_list = threads->list;
		print "Scakar first ", scalar (@first_list), "\n";
		
		my $tid = Text::Editor::Easy->create_new_server(
		   {
				'use' => 'Text::Editor::Easy::Test::Test1', 
				'package' => 'Text::Editor::Easy::Test::Test1',
				'methods' => ['test1'],
				'object' => [] 
		    });
		print "Aprs create_new_server : ", scalar (threads->list), "\n";
		
		my @second_list = threads->list;		
		is ( scalar(@second_list), scalar(@first_list) + 1, "One more thread");
		
		print "Avant appel add_thread_method : ", scalar (threads->list), "\n";

		Text::Editor::Easy->ask_thread(
		    'stop_thread', $tid,
		);
		print "Aprs appel stop_thread : ", scalar (threads->list), "\n";
		my @third_list = threads->list;
		
		print "Third second ", scalar (@third_list), "\n";
		is (  scalar(@third_list), scalar(@second_list) - 1, "One thread less");
		# Tests de cration de thread nomms (mthodes mises en commun sans augmentation du nombre d'entre de %get_tid_from_instance_method



		# Vrifier le bon partage du mme objet
		# Donner la possibilit d'avoir un objet personnel ?
		# Si oui tester le bon partage par dfaut, la diffrence si souhaite
        # Ajout avec une autre mthode de classe dfinie pour l'occassion
		# Vrifier l'appel de classe correct
		# Vrifier l'hritage automatique
		# Vrifier l'appel de classe incorrect (appel Text::Editor::Easy avec mthode uniquement dfinie dans la classe hrite)
		# Vrifier l'implmentation de "->super"
		# Vrifier le non crasement de mthode ? (add et non overload ?)

	Text::Editor::Easy->exit(0);
}		