use strict;
use warnings;

### after: use lib qw(@RT_LIB_PATH@);
use lib qw(/srv/rt/github/bestpractical/rt/local/lib /srv/rt/github/bestpractical/rt/lib);

package RT::Extension::ConditionalCustomFields::Test;

our @ISA;
BEGIN {
    local $@;
    eval { require RT::Test; 1 } or do {
        require Test::More;
        Test::More::BAIL_OUT(
            "requires 3.8 to run tests. Error:\n$@\n"
            ."You may need to set PERL5LIB=/path/to/rt/lib"
        );
    };
    push @ISA, 'RT::Test';
}

sub import {
    my $class = shift;
    my %args  = @_;

    $args{'requires'} ||= [];
    if ( $args{'testing'} ) {
        unshift @{ $args{'requires'} }, 'RT::Extension::ConditionalCustomFields';
    } else {
        $args{'testing'} = 'RT::Extension::ConditionalCustomFields';
    }

    $class->SUPER::import( %args );
    $class->export_to_level(1);

    require RT::Extension::ConditionalCustomFields;
}

1;
