#!perl -T
use 5.10.0;
use strict;
use warnings;
use utf8;
use Test::More;

BEGIN {
  use_ok('Net::IPAM::Tree')  || print "Bail out!\n";
  use_ok('Net::IPAM::Block') || print "Bail out!\n";
}

my ( $t, $dup );
my @blocks = qw(0.0.0.0/0 ::ffff:1.2.3.5 1.2.3.6 1.2.3.7/31 ::/0 fe80::1/10 ::cafe:affe);

my @items;
foreach my $b (@blocks) {
  push @items, Net::IPAM::Block->new($b);
}
$t = Net::IPAM::Tree->new->insert(@items);

my $str = <<EOT;
▼
├─ 0.0.0.0/0
│  ├─ 1.2.3.5/32
│  └─ 1.2.3.6/31
│     └─ 1.2.3.6/32
└─ ::/0
   ├─ ::cafe:affe/128
   └─ fe80::/10
EOT

ok( $t->to_string eq $str, 'insert and stringify' );

# shut up warnings
$t   = Net::IPAM::Tree->new( sub { } )->insert(@items);
$dup = Net::IPAM::Block->new('1.2.3.6');
ok( !$t->insert($dup), 'insert dup block' );

# die on dups
$t   = Net::IPAM::Tree->new( sub { die shift } )->insert(@items);
$dup = Net::IPAM::Block->new('1.2.3.6');
eval { $t->insert($dup) };
like( $@, qr/\Q1.2.3.6\E/i, 'dies on dup' );

done_testing();
