
package Module::Spec;
$Module::Spec::VERSION = '0.2.0';
# ABSTRACT: Load modules based on specifications
use 5.010;

# use strict;
# use warnings;

use Module::Spec::V1 ();

sub new {
    my ( $self, %args ) = @_;
    Module::Spec::V1::croak qq{What version?} unless my $v = $args{ver};
    Module::Spec::V1::_require_module( my $m = "Module::Spec::V$v" );
    return bless {}, $m;
}

1;

#pod =encoding utf8
#pod
#pod =head1 SYNOPSIS
#pod
#pod     use Module::Spec;
#pod
#pod     my $ms = Module::Spec->new(ver => 1);
#pod     $ms->need_module('Mango~2.3');
#pod
#pod =cut

__END__

=pod

=encoding UTF-8

=head1 NAME

Module::Spec - Load modules based on specifications

=head1 VERSION

version 0.2.0

=head1 SYNOPSIS

    use Module::Spec;

    my $ms = Module::Spec->new(ver => 1);
    $ms->need_module('Mango~2.3');

=head1 AUTHOR

Adriano Ferreira <ferreira@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Adriano Ferreira.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
