use v6.*;
use Test;
use P5getgrnam;
%*ENV<RAKUDO_NO_DEPRECATIONS> = True;

plan 22;

my int $groupid = +$*GROUP;
ok $groupid > 0, 'did we get a group ID';

my $groupname = getgrgid(Scalar, $groupid);
ok $groupname ~~ m/^ \w+ /, 'did we get a name';
is getgrgid($groupid, :scalar), $groupname, 'did we get right name';

my @result = getgrgid($groupid);
is @result[0], $groupname, 'did we get the groupname in this struct by gid';
is @result[2], $groupid,   'did we get the groupid in this struct by gid';
ok @result[3] ~~ Str,      'did we get the members by gid';

is getgrnam(Scalar, $groupname), $groupid, 'did we get the gid';
is getgrnam($groupname, :scalar), $groupid, 'did we get the gid';
@result = getgrnam($groupname);
is @result[0], $groupname, 'did we get the groupname in this struct by name';
is @result[2], $groupid,   'did we get the groupid in this struct by name';
ok @result[3] ~~ Str,      'did we get the members by name';

@result = getgrent;
ok @result, 'did we get anything from getgrent';

my int $seen = 1;
my $seen_me;
while getgrent() -> @result {
    $seen_me = True if @result[0] eq $groupname && @result[2] == $groupid;
    ++$seen;
}
ok $seen_me, 'did we see ourselves';
is setgrent, 1, 'did we return the undocumented 1';

--$seen while getgrent;
is $seen, 0, 'did we get the same number of entries the 2nd time';
is endgrent, 1, 'did we return the undocumented 1';

is-deeply getgrnam("thisnameshouldnotexist"), (), 'non-existing name';
is getgrnam(Scalar, "thisnameshouldnotexist"), Nil, 'non-existing name scalar';
is getgrnam("thisnameshouldnotexist", :scalar), Nil, 'non-existing name scalar';

is-deeply getgrgid(9999), (), 'non-existing gid';
is getgrgid(Scalar, 9999), Nil, 'non-existing name gid';
is getgrgid(9999, :scalar), Nil, 'non-existing name gid';

# vim: expandtab shiftwidth=4
