package Locales::DB::Language::sl;

# Auto generated from CLDR

$Locales::DB::Language::sl::VERSION = '0.09';

$Locales::DB::Language::sl::cldr_version = '2.0';

%Locales::DB::Language::sl::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Jezik\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ in\ \{1\}",
            'end'    => "\{0\}\ in\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regija\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '“',
        'alternate_quotation_start' => '„',
        'quotation_end'             => '«',
        'quotation_start'           => '»'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'two',
            'few',
            'other'
        ],
        'category_rules' => {
            'few' => "n\ mod\ 100\ in\ 3\.\.4",
            'one' => "n\ mod\ 100\ is\ 1",
            'two' => "n\ mod\ 100\ is\ 2"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) >= 3 && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) <= 4 ) ) ) { return 'few'; }
                return;
            },
            'one' => sub {
                if ( ( ( ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) == 1 ) ) ) { return 'one'; }
                return;
            },
            'two' => sub {
                if ( ( ( ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) == 2 ) ) ) { return 'two'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "da\:d"
    },
);

%Locales::DB::Language::sl::code_to_name = (
    'aa'    => 'afarščina',
    'ab'    => 'abhaščina',
    'ace'   => 'ačejščina',
    'ach'   => 'ačolijščina',
    'ada'   => 'adangmejščina',
    'ady'   => 'adigejščina',
    'ae'    => 'avestijščina',
    'af'    => 'afrikanščina',
    'afa'   => "afroazijski\ jezik",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainujščina',
    'ak'    => 'akanščina',
    'akk'   => 'akadščina',
    'ale'   => 'aleutščina',
    'alg'   => "algonkinski\ jezik",
    'alt'   => "južna\ altajščina",
    'am'    => 'amharščina',
    'an'    => 'aragonščina',
    'ang'   => "stara\ angleščina",
    'anp'   => 'angikaščina',
    'apa'   => "apaški\ jezik",
    'ar'    => 'arabščina',
    'arc'   => 'aramejščina',
    'arn'   => 'aravkanščina',
    'arp'   => 'arapaščina',
    'art'   => "umetni\ jezik",
    'arw'   => 'aravaščina',
    'as'    => 'asamščina',
    'asa'   => 'Asu',
    'ast'   => 'asturijščina',
    'ath'   => "atabaški\ jezik",
    'aus'   => "avstralski\ jezik",
    'av'    => 'avarščina',
    'awa'   => 'avadščina',
    'ay'    => 'ajmarščina',
    'az'    => 'azerščina',
    'ba'    => 'baškirščina',
    'bad'   => "bandaški\ jezik",
    'bai'   => "bamilekejski\ jezik",
    'bal'   => 'beludžijščina',
    'ban'   => 'balijščina',
    'bas'   => 'basa',
    'bat'   => "baltski\ jezik",
    'be'    => 'beloruščina',
    'bej'   => 'bedža',
    'bem'   => 'bemba',
    'ber'   => 'berberščina',
    'bez'   => 'Bena',
    'bg'    => 'bolgarščina',
    'bh'    => 'biharščina',
    'bho'   => 'bodžpuri',
    'bi'    => 'bislamščina',
    'bik'   => "bikolski\ jezik",
    'bin'   => 'edo',
    'bla'   => 'siksika',
    'bm'    => 'bambarščina',
    'bn'    => 'bengalščina',
    'bnt'   => 'bantujščina',
    'bo'    => 'tibetanščina',
    'br'    => 'bretonščina',
    'bra'   => 'bradžbakanščina',
    'brx'   => 'Bodo',
    'bs'    => 'bosanščina',
    'btk'   => "bataški\ jezik",
    'bua'   => 'burjatščina',
    'bug'   => 'buginščina',
    'byn'   => 'blinščina',
    'ca'    => 'katalonščina',
    'cad'   => 'kadoščina',
    'cai'   => "srednjeameriški\ indijanski\ jezik",
    'car'   => "karibski\ jezik",
    'cau'   => "kavkaški\ jezik",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'čečenščina',
    'ceb'   => 'sebuanščina',
    'cel'   => "keltski\ jezik",
    'cgg'   => 'Chiga',
    'ch'    => 'čamorščina',
    'chb'   => 'čibčevščina',
    'chg'   => 'čagatajščina',
    'chk'   => 'trukeščina',
    'chm'   => 'marijščina',
    'chn'   => "činuški\ žargon",
    'cho'   => 'čoktavščina',
    'chp'   => 'čipevščina',
    'chr'   => 'čerokeščina',
    'chy'   => 'čejenščina',
    'cmc'   => "camski\ jezik",
    'co'    => 'korziščina',
    'cop'   => 'koptščina',
    'cpe'   => "angleška\ kreolščina\ ali\ pidžinščina",
    'cpf'   => "francoska\ kreolščina\ ali\ pidžinščina",
    'cpp'   => "portugalska\ kreolščina\ ali\ pidžinščina",
    'cr'    => 'krijščina',
    'crh'   => "krimska\ tatarščina",
    'crp'   => "kreolščina\ ali\ pidžinščina",
    'cs'    => 'češčina',
    'csb'   => 'kašubščina',
    'cu'    => "stara\ cerkvena\ slovanščina",
    'cus'   => 'kušitščina',
    'cv'    => 'čuvaščina',
    'cy'    => 'valižanščina',
    'da'    => 'danščina',
    'dak'   => 'dakotščina',
    'dar'   => 'darginščina',
    'dav'   => 'Taita',
    'day'   => 'dajaščina',
    'de'    => 'nemščina',
    'de_at' => "avstrijska\ nemščina",
    'de_ch' => "visoka\ nemščina\ \(Švica\)",
    'del'   => 'delavarščina',
    'den'   => 'slavejščina',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => "dravidski\ jezik",
    'dsb'   => "dolnja\ lužiška\ srbščina",
    'dua'   => 'duala',
    'dum'   => "srednja\ nizozemščina",
    'dv'    => 'diveščina',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'diula',
    'dz'    => 'dzonka',
    'ebu'   => 'Embu',
    'ee'    => 'evenščina',
    'efi'   => 'efiščina',
    'egy'   => "stara\ egipčanščina",
    'eka'   => 'ekajuk',
    'el'    => 'grščina',
    'elx'   => 'elamščina',
    'en'    => 'angleščina',
    'en_au' => "avstralska\ angleščina",
    'en_ca' => "kanadska\ angleščina",
    'en_gb' => "angleščina\ \(VB\)",
    'en_us' => "angleščina\ \(ZDA\)",
    'enm'   => "srednja\ angleščina",
    'eo'    => 'esperanto',
    'es'    => 'španščina',
    'es_es' => "iberska\ španščina",
    'et'    => 'estonščina',
    'eu'    => 'baskovščina',
    'ewo'   => 'evondovščina',
    'fa'    => 'perzijščina',
    'fan'   => 'fangijščina',
    'fat'   => 'fantijščina',
    'ff'    => 'fulščina',
    'fi'    => 'finščina',
    'fil'   => 'filipinščina',
    'fiu'   => "ugrofinski\ jezik",
    'fj'    => 'fidžijščina',
    'fo'    => 'ferščina',
    'fon'   => 'fonščina',
    'fr'    => 'francoščina',
    'fr_ca' => "kanadska\ francoščina",
    'fr_ch' => "švicarska\ francoščina",
    'frm'   => "srednja\ francoščina",
    'fro'   => "stara\ francoščina",
    'frr'   => "severna\ frizijščina",
    'frs'   => "vzhodna\ frizijščina",
    'fur'   => 'furlanščina',
    'fy'    => 'frizijščina',
    'ga'    => 'irščina',
    'gaa'   => 'ga',
    'gay'   => 'gajščina',
    'gba'   => 'gbajščina',
    'gd'    => "škotska\ gelščina",
    'gem'   => "germanski\ jezik",
    'gez'   => 'etiopščina',
    'gil'   => 'kiribatščina',
    'gl'    => 'galicijščina',
    'gmh'   => "srednja\ visoka\ nemščina",
    'gn'    => 'gvaranijščina',
    'goh'   => "stara\ visoka\ nemščina",
    'gon'   => 'gondi',
    'gor'   => 'gorontalščina',
    'got'   => 'gotščina',
    'grb'   => 'grebščina',
    'grc'   => "stara\ grščina",
    'gsw'   => "nemščina\ \(Švica\)",
    'gu'    => 'gudžaratščina',
    'guz'   => 'Gusii',
    'gv'    => 'manščina',
    'gwi'   => 'gwi',
    'ha'    => 'havščina',
    'hai'   => 'haidščina',
    'haw'   => 'havajščina',
    'he'    => 'hebrejščina',
    'hi'    => 'hindujščina',
    'hil'   => 'hiligajnonščina',
    'him'   => 'himačalščina',
    'hit'   => 'hetitščina',
    'hmn'   => 'hmonščina',
    'ho'    => "hiri\ motu",
    'hr'    => 'hrvaščina',
    'hsb'   => "gornja\ lužiška\ srbščina",
    'ht'    => "haitijska\ kreolščina",
    'hu'    => 'madžarščina',
    'hup'   => 'hupa',
    'hy'    => 'armenščina',
    'hz'    => 'herero',
    'ia'    => 'interlingva',
    'iba'   => 'ibanščina',
    'id'    => 'indonezijščina',
    'ie'    => 'interlingve',
    'ig'    => 'igboščina',
    'ii'    => 'ii',
    'ijo'   => 'ijo',
    'ik'    => 'inupiaščina',
    'ilo'   => 'ilokanščina',
    'inc'   => "indijski\ jezik",
    'ine'   => "indoevropski\ jezik",
    'inh'   => 'inguščina',
    'io'    => 'ido',
    'ira'   => "iranski\ jezik",
    'iro'   => "irokeški\ jezik",
    'is'    => 'islandščina',
    'it'    => 'italijanščina',
    'iu'    => 'inuktitutščina',
    'ja'    => 'japonščina',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "judovska\ perzijščina",
    'jrb'   => "judovska\ arabščina",
    'jv'    => 'javanščina',
    'ka'    => 'gruzinščina',
    'kaa'   => 'karakalpaščina',
    'kab'   => 'kabilščina',
    'kac'   => 'kačinščina',
    'kaj'   => 'kaj',
    'kam'   => 'kamba',
    'kar'   => 'karenščina',
    'kaw'   => 'kavi',
    'kbd'   => 'kabardinščina',
    'kcg'   => "tjapska\ nigerijščina",
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'kfo',
    'kg'    => 'kongovščina',
    'kha'   => 'kasi',
    'khi'   => "koisanski\ jezik",
    'kho'   => 'kotanščina',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikujščina',
    'kj'    => 'kvanjama',
    'kk'    => 'kazaščina',
    'kl'    => 'grenlandščina',
    'kln'   => 'Kalenjin',
    'km'    => 'kmerščina',
    'kmb'   => 'kimbundu',
    'kn'    => 'kanada',
    'ko'    => 'korejščina',
    'kok'   => 'konkanščina',
    'kos'   => 'kosrajščina',
    'kpe'   => 'kpelejščina',
    'kr'    => 'kanurščina',
    'krc'   => "karačaj\-balkarščina",
    'krl'   => 'karelščina',
    'kro'   => "jezik\ kru",
    'kru'   => 'kuruk',
    'ks'    => 'kašmirščina',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdščina',
    'kum'   => 'kumiščina',
    'kut'   => 'kutenajščina',
    'kv'    => 'komijščina',
    'kw'    => 'kornijščina',
    'ky'    => 'kirgiščina',
    'la'    => 'latinščina',
    'lad'   => 'ladinščina',
    'lag'   => 'Langi',
    'lah'   => 'landa',
    'lam'   => 'lamba',
    'lb'    => 'luksemburščina',
    'lez'   => 'lezginščina',
    'lg'    => 'ganda',
    'li'    => 'limburščina',
    'ln'    => 'lingala',
    'lo'    => 'laoščina',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litovščina',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luisenščina',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'luy'   => 'Luyia',
    'lv'    => 'latvijščina',
    'mad'   => 'madurščina',
    'mag'   => 'magadščina',
    'mai'   => 'maitili',
    'mak'   => 'makasarščina',
    'man'   => 'mandingo',
    'map'   => "avstronezijski\ jezik",
    'mas'   => 'masajščina',
    'mdf'   => 'mokšavščina',
    'mdr'   => 'mandarščina',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagaščina',
    'mga'   => "srednja\ irščina",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'marshallovščina',
    'mi'    => 'maorščina',
    'mic'   => 'mikmaščina',
    'min'   => 'minangkabau',
    'mis'   => "drugi\ jeziki",
    'mk'    => 'makedonščina',
    'mkh'   => "monsko\-kmerski\ jezik",
    'ml'    => 'malajalamščina',
    'mn'    => 'mongolščina',
    'mnc'   => 'mandžurščina',
    'mni'   => 'manipurščina',
    'mno'   => "kotabatski\ manobo",
    'mo'    => 'moldavščina',
    'moh'   => 'mohoščina',
    'mos'   => 'mosijščina',
    'mr'    => 'maratščina',
    'ms'    => 'malajščina',
    'mt'    => 'malteščina',
    'mua'   => 'Mundang',
    'mul'   => "več\ jezikov",
    'mun'   => "mundski\ jezik",
    'mus'   => 'mus',
    'mwl'   => 'mirandeščina',
    'mwr'   => 'marvarščina',
    'my'    => 'burmanščina',
    'myn'   => "majevski\ jezik",
    'myv'   => 'erzjanščina',
    'na'    => 'naurujščina',
    'nah'   => 'nahuatl',
    'nai'   => "severnoameriški\ indijanski\ jezik",
    'nap'   => 'napolitanščina',
    'naq'   => 'Nama',
    'nb'    => "knjižna\ norveščina",
    'nd'    => "severna\ ndebelščina",
    'nds'   => "nizka\ nemščina",
    'ne'    => 'nepalščina',
    'new'   => 'nevarščina',
    'ng'    => 'ng',
    'nia'   => 'niaščina',
    'nic'   => "nigrsko\-kordofanski\ jezik",
    'niu'   => 'niuejščina',
    'nl'    => 'nizozemščina',
    'nl_be' => 'flamščina',
    'nmg'   => 'Kwasio',
    'nn'    => 'novonorveščina',
    'no'    => 'norveščina',
    'nog'   => 'nogajščina',
    'non'   => "stara\ nordijščina",
    'nqo'   => 'nqo',
    'nr'    => "južna\ ndebelščina",
    'nso'   => "severna\ sotščina",
    'nub'   => "nubijski\ jezik",
    'nus'   => 'Nuer',
    'nv'    => 'navajščina',
    'nwc'   => "klasična\ nevarščina",
    'ny'    => 'njanščina',
    'nym'   => 'njamveščina',
    'nyn'   => 'njankole',
    'nyo'   => 'njoro',
    'nzi'   => 'nzima',
    'oc'    => 'okcitanščina',
    'oj'    => 'anašinabščina',
    'om'    => 'oromo',
    'or'    => 'orijščina',
    'os'    => 'osetinščina',
    'osa'   => 'osage',
    'ota'   => "otomanska\ turščina",
    'oto'   => "otomijski\ jezik",
    'pa'    => 'pandžabščina',
    'paa'   => "papuanski\ jezik",
    'pag'   => 'pangasinanščina',
    'pal'   => 'pal',
    'pam'   => 'pampanščina',
    'pap'   => 'papiamentu',
    'pau'   => 'palavanščina',
    'peo'   => "stara\ perzijščina",
    'phi'   => "filipinski\ jezik",
    'phn'   => 'feničanščina',
    'pi'    => 'palijščina',
    'pl'    => 'poljščina',
    'pon'   => 'ponpejščina',
    'pra'   => "prakritski\ jezik",
    'pro'   => "stara\ provansalščina",
    'ps'    => 'paštunščina',
    'pt'    => 'portugalščina',
    'pt_br' => "brazilska\ portugalščina",
    'pt_pt' => "iberska\ portugalščina",
    'qu'    => 'kečuanščina',
    'raj'   => 'radžastanščina',
    'rap'   => 'rapanujščina',
    'rar'   => 'rarotongščina',
    'rm'    => 'retoromanščina',
    'rn'    => 'rundščina',
    'ro'    => 'romunščina',
    'roa'   => "romanski\ jezik",
    'rof'   => 'Rombo',
    'rom'   => 'romščina',
    'ru'    => 'ruščina',
    'rup'   => 'aromunščina',
    'rw'    => 'ruandščina',
    'rwk'   => 'Rwa',
    'sa'    => 'sanskrt',
    'sad'   => 'sad',
    'sah'   => 'jakutščina',
    'sai'   => 'sai',
    'sal'   => 'sal',
    'sam'   => "samaritanska\ aramejščina",
    'saq'   => 'Samburu',
    'sas'   => 'sasaščina',
    'sat'   => 'santalščina',
    'sbp'   => 'Sangu',
    'sc'    => 'sardinščina',
    'scn'   => 'sicilijanščina',
    'sco'   => 'škotščina',
    'sd'    => 'sindščina',
    'se'    => "severna\ samijščina",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkupščina',
    'sem'   => "semitski\ jezik",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => "stara\ irščina",
    'sgn'   => "znakovni\ jezik",
    'sh'    => 'srbohrvaščina',
    'shi'   => 'Tachelhit',
    'shn'   => 'šanščina',
    'si'    => 'singalščina',
    'sid'   => 'sidamščina',
    'sio'   => 'sijuščina',
    'sit'   => "kitajsko\-tibetanski\ jezik",
    'sk'    => 'slovaščina',
    'sl'    => 'slovenščina',
    'sla'   => "slovanski\ jezik",
    'sm'    => 'samoanščina',
    'sma'   => "južna\ samijščina",
    'smi'   => "samijski\ jezik",
    'smj'   => "luleška\ samijščina",
    'smn'   => "inarska\ samijščina",
    'sms'   => "samijščina\ Skolt",
    'sn'    => 'šonščina',
    'snk'   => 'snk',
    'so'    => 'somalščina',
    'sog'   => 'sog',
    'son'   => 'songajščina',
    'sq'    => 'albanščina',
    'sr'    => 'srbščina',
    'srn'   => "surinamska\ kreolščina",
    'srr'   => 'sererščina',
    'ss'    => 'svazijščina',
    'ssa'   => "nilsko\-saharski\ jezik",
    'ssy'   => 'Saho',
    'st'    => 'sesoto',
    'su'    => 'sundanščina',
    'suk'   => 'sukuma',
    'sus'   => 'susujščina',
    'sux'   => 'sumerščina',
    'sv'    => 'švedščina',
    'sw'    => 'svahili',
    'swb'   => 'šikomor',
    'swc'   => "Congo\ Swahili",
    'syc'   => "klasična\ sirščina",
    'syr'   => 'sirščina',
    'ta'    => 'tamilščina',
    'tai'   => "tajski\ jezik",
    'te'    => 'telugijščina',
    'tem'   => 'temnejščina',
    'teo'   => 'Teso',
    'ter'   => 'ter',
    'tet'   => 'tetumščina',
    'tg'    => 'tadžiščina',
    'th'    => 'tajščina',
    'ti'    => 'tigrajščina',
    'tig'   => 'tigrejščina',
    'tiv'   => 'tivščina',
    'tk'    => 'turkmenščina',
    'tkl'   => 'tokelavščina',
    'tl'    => 'tagalogščina',
    'tlh'   => 'klingonščina',
    'tli'   => 'tlingitščina',
    'tmh'   => 'tamajaščina',
    'tn'    => 'cvanščina',
    'to'    => 'tongščina',
    'tog'   => "malavijska\ tongščina",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turščina',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimščina',
    'tt'    => 'tatarščina',
    'tum'   => 'tumbukščina',
    'tup'   => "tupijski\ jezik",
    'tut'   => "altajski\ jezik",
    'tvl'   => 'tuvalujščina',
    'tw'    => 'tvi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahitščina',
    'tyv'   => 'tuvinščina',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurtščina',
    'ug'    => 'ujgurščina',
    'uga'   => "ugaritski\ jezik",
    'uk'    => 'ukrajinščina',
    'umb'   => 'umbundščina',
    'und'   => "neznan\ ali\ neveljaven\ jezik",
    'ur'    => 'urdujščina',
    'uz'    => 'uzbeščina',
    'vai'   => 'vajščina',
    've'    => 'venda',
    'vi'    => 'vietnamščina',
    'vo'    => 'volapuk',
    'vot'   => 'votjaščina',
    'vun'   => 'Vunjo',
    'wa'    => 'valonščina',
    'wae'   => 'Walser',
    'wak'   => "vakaški\ jezik",
    'wal'   => 'valamščina',
    'war'   => 'varajščina',
    'was'   => 'vašajščina',
    'wen'   => "lužiško\ srbski\ jezik",
    'wo'    => 'volofščina',
    'xal'   => 'kalmiščina',
    'xh'    => 'xhosa',
    'xog'   => 'Soga',
    'yao'   => 'jaojščina',
    'yap'   => 'japščina',
    'yav'   => 'Yangben',
    'yi'    => 'jidiš',
    'yo'    => 'jorubščina',
    'ypk'   => "jupiški\ jezik",
    'yue'   => 'kantonščina',
    'za'    => 'za',
    'zap'   => 'zapoteščina',
    'zbl'   => "znakovni\ jezik\ Bliss",
    'zen'   => 'zenaščina',
    'zh'    => 'kitajščina',
    'znd'   => 'zandejščina',
    'zu'    => 'zulujščina',
    'zun'   => 'zunijščina',
    'zxx'   => "brez\ jezikoslovne\ vsebine",
    'zza'   => 'zazajščina',
);

%Locales::DB::Language::sl::name_to_code = (
    'abhaščina'                              => 'ab',
    'adangmejščina'                          => 'ada',
    'adigejščina'                            => 'ady',
    'afarščina'                              => 'aa',
    'afrihili'                                 => 'afh',
    'afrikanščina'                           => 'af',
    'afroazijskijezik'                         => 'afa',
    'aghem'                                    => 'agq',
    'ainujščina'                             => 'ain',
    'ajmarščina'                             => 'ay',
    'akadščina'                              => 'akk',
    'akanščina'                              => 'ak',
    'albanščina'                             => 'sq',
    'aleutščina'                             => 'ale',
    'algonkinskijezik'                         => 'alg',
    'altajskijezik'                            => 'tut',
    'amharščina'                             => 'am',
    'anašinabščina'                         => 'oj',
    'angikaščina'                            => 'anp',
    'angleškakreolščinaalipidžinščina'   => 'cpe',
    'angleščina'                             => 'en',
    'angleščinavb'                           => 'en_gb',
    'angleščinazda'                          => 'en_us',
    'apaškijezik'                             => 'apa',
    'arabščina'                              => 'ar',
    'aragonščina'                            => 'an',
    'aramejščina'                            => 'arc',
    'arapaščina'                             => 'arp',
    'aravaščina'                             => 'arw',
    'aravkanščina'                           => 'arn',
    'armenščina'                             => 'hy',
    'aromunščina'                            => 'rup',
    'asamščina'                              => 'as',
    'asturijščina'                           => 'ast',
    'asu'                                      => 'asa',
    'atabaškijezik'                           => 'ath',
    'atsam'                                    => 'cch',
    'avadščina'                              => 'awa',
    'avarščina'                              => 'av',
    'avestijščina'                           => 'ae',
    'avstralskaangleščina'                   => 'en_au',
    'avstralskijezik'                          => 'aus',
    'avstrijskanemščina'                     => 'de_at',
    'avstronezijskijezik'                      => 'map',
    'azerščina'                              => 'az',
    'ačejščina'                             => 'ace',
    'ačolijščina'                           => 'ach',
    'bafia'                                    => 'ksf',
    'balijščina'                             => 'ban',
    'baltskijezik'                             => 'bat',
    'bambarščina'                            => 'bm',
    'bamilekejskijezik'                        => 'bai',
    'bandaškijezik'                           => 'bad',
    'bantujščina'                            => 'bnt',
    'basa'                                     => 'bas',
    'baskovščina'                            => 'eu',
    'bataškijezik'                            => 'btk',
    'baškirščina'                           => 'ba',
    'bedža'                                   => 'bej',
    'beloruščina'                            => 'be',
    'beludžijščina'                         => 'bal',
    'bemba'                                    => 'bem',
    'bena'                                     => 'bez',
    'bengalščina'                            => 'bn',
    'berberščina'                            => 'ber',
    'biharščina'                             => 'bh',
    'bikolskijezik'                            => 'bik',
    'bislamščina'                            => 'bi',
    'blinščina'                              => 'byn',
    'bodo'                                     => 'brx',
    'bodžpuri'                                => 'bho',
    'bolgarščina'                            => 'bg',
    'bosanščina'                             => 'bs',
    'bradžbakanščina'                       => 'bra',
    'brazilskaportugalščina'                 => 'pt_br',
    'bretonščina'                            => 'br',
    'brezjezikoslovnevsebine'                  => 'zxx',
    'buginščina'                             => 'bug',
    'burjatščina'                            => 'bua',
    'burmanščina'                            => 'my',
    'camskijezik'                              => 'cmc',
    'cayuga'                                   => 'cay',
    'centralmoroccotamazight'                  => 'tzm',
    'chiga'                                    => 'cgg',
    'colognian'                                => 'ksh',
    'congoswahili'                             => 'swc',
    'cvanščina'                              => 'tn',
    'dajaščina'                              => 'day',
    'dakotščina'                             => 'dak',
    'danščina'                               => 'da',
    'darginščina'                            => 'dar',
    'delavarščina'                           => 'del',
    'dinka'                                    => 'din',
    'diula'                                    => 'dyu',
    'diveščina'                              => 'dv',
    'dogri'                                    => 'doi',
    'dogrib'                                   => 'dgr',
    'dolnjalužiškasrbščina'                => 'dsb',
    'dravidskijezik'                           => 'dra',
    'drugijeziki'                              => 'mis',
    'duala'                                    => 'dua',
    'dzonka'                                   => 'dz',
    'edo'                                      => 'bin',
    'efiščina'                               => 'efi',
    'ekajuk'                                   => 'eka',
    'elamščina'                              => 'elx',
    'embu'                                     => 'ebu',
    'erzjanščina'                            => 'myv',
    'esperanto'                                => 'eo',
    'estonščina'                             => 'et',
    'etiopščina'                             => 'gez',
    'evenščina'                              => 'ee',
    'evondovščina'                           => 'ewo',
    'fangijščina'                            => 'fan',
    'fantijščina'                            => 'fat',
    'feničanščina'                          => 'phn',
    'ferščina'                               => 'fo',
    'fidžijščina'                           => 'fj',
    'filipinskijezik'                          => 'phi',
    'filipinščina'                           => 'fil',
    'finščina'                               => 'fi',
    'flamščina'                              => 'nl_be',
    'fonščina'                               => 'fon',
    'francoskakreolščinaalipidžinščina'   => 'cpf',
    'francoščina'                            => 'fr',
    'frizijščina'                            => 'fy',
    'fulščina'                               => 'ff',
    'furlanščina'                            => 'fur',
    'ga'                                       => 'gaa',
    'gajščina'                               => 'gay',
    'galicijščina'                           => 'gl',
    'ganda'                                    => 'lg',
    'gbajščina'                              => 'gba',
    'germanskijezik'                           => 'gem',
    'gondi'                                    => 'gon',
    'gornjalužiškasrbščina'                => 'hsb',
    'gorontalščina'                          => 'gor',
    'gotščina'                               => 'got',
    'grebščina'                              => 'grb',
    'grenlandščina'                          => 'kl',
    'gruzinščina'                            => 'ka',
    'grščina'                                => 'el',
    'gudžaratščina'                         => 'gu',
    'gusii'                                    => 'guz',
    'gvaranijščina'                          => 'gn',
    'gwi'                                      => 'gwi',
    'haidščina'                              => 'hai',
    'haitijskakreolščina'                    => 'ht',
    'havajščina'                             => 'haw',
    'havščina'                               => 'ha',
    'hebrejščina'                            => 'he',
    'herero'                                   => 'hz',
    'hetitščina'                             => 'hit',
    'hiligajnonščina'                        => 'hil',
    'himačalščina'                          => 'him',
    'hindujščina'                            => 'hi',
    'hirimotu'                                 => 'ho',
    'hmonščina'                              => 'hmn',
    'hrvaščina'                              => 'hr',
    'hupa'                                     => 'hup',
    'ibanščina'                              => 'iba',
    'iberskaportugalščina'                   => 'pt_pt',
    'iberskašpanščina'                      => 'es_es',
    'ido'                                      => 'io',
    'igboščina'                              => 'ig',
    'ii'                                       => 'ii',
    'ijo'                                      => 'ijo',
    'ilokanščina'                            => 'ilo',
    'inarskasamijščina'                      => 'smn',
    'indijskijezik'                            => 'inc',
    'indoevropskijezik'                        => 'ine',
    'indonezijščina'                         => 'id',
    'inguščina'                              => 'inh',
    'interlingva'                              => 'ia',
    'interlingve'                              => 'ie',
    'inuktitutščina'                         => 'iu',
    'inupiaščina'                            => 'ik',
    'iranskijezik'                             => 'ira',
    'irokeškijezik'                           => 'iro',
    'irščina'                                => 'ga',
    'islandščina'                            => 'is',
    'italijanščina'                          => 'it',
    'jakutščina'                             => 'sah',
    'jaojščina'                              => 'yao',
    'japonščina'                             => 'ja',
    'japščina'                               => 'yap',
    'javanščina'                             => 'jv',
    'jezikkru'                                 => 'kro',
    'jidiš'                                   => 'yi',
    'jolafonyi'                                => 'dyo',
    'jorubščina'                             => 'yo',
    'judovskaarabščina'                      => 'jrb',
    'judovskaperzijščina'                    => 'jpr',
    'jupiškijezik'                            => 'ypk',
    'južnaaltajščina'                       => 'alt',
    'južnandebelščina'                      => 'nr',
    'južnasamijščina'                       => 'sma',
    'kabardinščina'                          => 'kbd',
    'kabilščina'                             => 'kab',
    'kabuverdianu'                             => 'kea',
    'kadoščina'                              => 'cad',
    'kaj'                                      => 'kaj',
    'kalenjin'                                 => 'kln',
    'kalmiščina'                             => 'xal',
    'kamba'                                    => 'kam',
    'kanada'                                   => 'kn',
    'kanadskaangleščina'                     => 'en_ca',
    'kanadskafrancoščina'                    => 'fr_ca',
    'kantonščina'                            => 'yue',
    'kanurščina'                             => 'kr',
    'karakalpaščina'                         => 'kaa',
    'karačajbalkarščina'                    => 'krc',
    'karelščina'                             => 'krl',
    'karenščina'                             => 'kar',
    'karibskijezik'                            => 'car',
    'kasi'                                     => 'kha',
    'katalonščina'                           => 'ca',
    'kavi'                                     => 'kaw',
    'kavkaškijezik'                           => 'cau',
    'kazaščina'                              => 'kk',
    'kačinščina'                            => 'kac',
    'kašmirščina'                           => 'ks',
    'kašubščina'                            => 'csb',
    'keltskijezik'                             => 'cel',
    'kečuanščina'                           => 'qu',
    'kfo'                                      => 'kfo',
    'kikujščina'                             => 'ki',
    'kimbundu'                                 => 'kmb',
    'kirgiščina'                             => 'ky',
    'kiribatščina'                           => 'gil',
    'kitajskotibetanskijezik'                  => 'sit',
    'kitajščina'                             => 'zh',
    'klasičnanevarščina'                    => 'nwc',
    'klasičnasirščina'                      => 'syc',
    'klingonščina'                           => 'tlh',
    'kmerščina'                              => 'km',
    'knjižnanorveščina'                     => 'nb',
    'koisanskijezik'                           => 'khi',
    'komijščina'                             => 'kv',
    'kongovščina'                            => 'kg',
    'konkanščina'                            => 'kok',
    'koptščina'                              => 'cop',
    'korejščina'                             => 'ko',
    'kornijščina'                            => 'kw',
    'korziščina'                             => 'co',
    'kosrajščina'                            => 'kos',
    'kotabatskimanobo'                         => 'mno',
    'kotanščina'                             => 'kho',
    'koyraborosenni'                           => 'ses',
    'koyrachiini'                              => 'khq',
    'kpelejščina'                            => 'kpe',
    'kreolščinaalipidžinščina'            => 'crp',
    'krijščina'                              => 'cr',
    'krimskatatarščina'                      => 'crh',
    'kumiščina'                              => 'kum',
    'kurdščina'                              => 'ku',
    'kuruk'                                    => 'kru',
    'kutenajščina'                           => 'kut',
    'kušitščina'                            => 'cus',
    'kvanjama'                                 => 'kj',
    'kwasio'                                   => 'nmg',
    'ladinščina'                             => 'lad',
    'lamba'                                    => 'lam',
    'landa'                                    => 'lah',
    'langi'                                    => 'lag',
    'laoščina'                               => 'lo',
    'latinščina'                             => 'la',
    'latvijščina'                            => 'lv',
    'lezginščina'                            => 'lez',
    'limburščina'                            => 'li',
    'lingala'                                  => 'ln',
    'litovščina'                             => 'lt',
    'lojban'                                   => 'jbo',
    'lozi'                                     => 'loz',
    'lubakatanga'                              => 'lu',
    'lubalulua'                                => 'lua',
    'luisenščina'                            => 'lui',
    'luksemburščina'                         => 'lb',
    'luleškasamijščina'                     => 'smj',
    'lunda'                                    => 'lun',
    'luo'                                      => 'luo',
    'lushai'                                   => 'lus',
    'luyia'                                    => 'luy',
    'lužiškosrbskijezik'                     => 'wen',
    'machame'                                  => 'jmc',
    'madurščina'                             => 'mad',
    'madžarščina'                           => 'hu',
    'magadščina'                             => 'mag',
    'maitili'                                  => 'mai',
    'majevskijezik'                            => 'myn',
    'makasarščina'                           => 'mak',
    'makedonščina'                           => 'mk',
    'makhuwameetto'                            => 'mgh',
    'makonde'                                  => 'kde',
    'malagaščina'                            => 'mg',
    'malajalamščina'                         => 'ml',
    'malajščina'                             => 'ms',
    'malavijskatongščina'                    => 'tog',
    'malteščina'                             => 'mt',
    'mandarščina'                            => 'mdr',
    'mandingo'                                 => 'man',
    'mandžurščina'                          => 'mnc',
    'manipurščina'                           => 'mni',
    'manščina'                               => 'gv',
    'maorščina'                              => 'mi',
    'maratščina'                             => 'mr',
    'marijščina'                             => 'chm',
    'marshallovščina'                        => 'mh',
    'marvarščina'                            => 'mwr',
    'masajščina'                             => 'mas',
    'mende'                                    => 'men',
    'meru'                                     => 'mer',
    'mikmaščina'                             => 'mic',
    'minangkabau'                              => 'min',
    'mirandeščina'                           => 'mwl',
    'mohoščina'                              => 'moh',
    'mokšavščina'                           => 'mdf',
    'moldavščina'                            => 'mo',
    'mongo'                                    => 'lol',
    'mongolščina'                            => 'mn',
    'monskokmerskijezik'                       => 'mkh',
    'morisyen'                                 => 'mfe',
    'mosijščina'                             => 'mos',
    'mundang'                                  => 'mua',
    'mundskijezik'                             => 'mun',
    'mus'                                      => 'mus',
    'nahuatl'                                  => 'nah',
    'nama'                                     => 'naq',
    'napolitanščina'                         => 'nap',
    'naurujščina'                            => 'na',
    'navajščina'                             => 'nv',
    'nemščina'                               => 'de',
    'nemščinaŠvica'                         => 'gsw',
    'nepalščina'                             => 'ne',
    'nevarščina'                             => 'new',
    'neznanalineveljavenjezik'                 => 'und',
    'ng'                                       => 'ng',
    'niaščina'                               => 'nia',
    'nigrskokordofanskijezik'                  => 'nic',
    'nilskosaharskijezik'                      => 'ssa',
    'niuejščina'                             => 'niu',
    'nizkanemščina'                          => 'nds',
    'nizozemščina'                           => 'nl',
    'njamveščina'                            => 'nym',
    'njankole'                                 => 'nyn',
    'njanščina'                              => 'ny',
    'njoro'                                    => 'nyo',
    'nogajščina'                             => 'nog',
    'norveščina'                             => 'no',
    'novonorveščina'                         => 'nn',
    'nqo'                                      => 'nqo',
    'nubijskijezik'                            => 'nub',
    'nuer'                                     => 'nus',
    'nzima'                                    => 'nzi',
    'okcitanščina'                           => 'oc',
    'orijščina'                              => 'or',
    'oromo'                                    => 'om',
    'osage'                                    => 'osa',
    'osetinščina'                            => 'os',
    'otomanskaturščina'                      => 'ota',
    'otomijskijezik'                           => 'oto',
    'pal'                                      => 'pal',
    'palavanščina'                           => 'pau',
    'palijščina'                             => 'pi',
    'pampanščina'                            => 'pam',
    'pandžabščina'                          => 'pa',
    'pangasinanščina'                        => 'pag',
    'papiamentu'                               => 'pap',
    'papuanskijezik'                           => 'paa',
    'paštunščina'                           => 'ps',
    'perzijščina'                            => 'fa',
    'poljščina'                              => 'pl',
    'ponpejščina'                            => 'pon',
    'portugalskakreolščinaalipidžinščina' => 'cpp',
    'portugalščina'                          => 'pt',
    'prakritskijezik'                          => 'pra',
    'radžastanščina'                        => 'raj',
    'rapanujščina'                           => 'rap',
    'rarotongščina'                          => 'rar',
    'retoromanščina'                         => 'rm',
    'romanskijezik'                            => 'roa',
    'rombo'                                    => 'rof',
    'romunščina'                             => 'ro',
    'romščina'                               => 'rom',
    'ruandščina'                             => 'rw',
    'rundščina'                              => 'rn',
    'ruščina'                                => 'ru',
    'rwa'                                      => 'rwk',
    'sad'                                      => 'sad',
    'saho'                                     => 'ssy',
    'sai'                                      => 'sai',
    'sal'                                      => 'sal',
    'samaritanskaaramejščina'                => 'sam',
    'samburu'                                  => 'saq',
    'samijskijezik'                            => 'smi',
    'samijščinaskolt'                        => 'sms',
    'samoanščina'                            => 'sm',
    'sango'                                    => 'sg',
    'sangu'                                    => 'sbp',
    'sanskrt'                                  => 'sa',
    'santalščina'                            => 'sat',
    'sardinščina'                            => 'sc',
    'sasaščina'                              => 'sas',
    'sebuanščina'                            => 'ceb',
    'selkupščina'                            => 'sel',
    'semitskijezik'                            => 'sem',
    'sena'                                     => 'seh',
    'seneca'                                   => 'see',
    'sererščina'                             => 'srr',
    'sesoto'                                   => 'st',
    'severnafrizijščina'                     => 'frr',
    'severnandebelščina'                     => 'nd',
    'severnasamijščina'                      => 'se',
    'severnasotščina'                        => 'nso',
    'severnoameriškiindijanskijezik'          => 'nai',
    'shambala'                                 => 'ksb',
    'sicilijanščina'                         => 'scn',
    'sidamščina'                             => 'sid',
    'sijuščina'                              => 'sio',
    'siksika'                                  => 'bla',
    'sindščina'                              => 'sd',
    'singalščina'                            => 'si',
    'sirščina'                               => 'syr',
    'slavejščina'                            => 'den',
    'slovanskijezik'                           => 'sla',
    'slovaščina'                             => 'sk',
    'slovenščina'                            => 'sl',
    'snk'                                      => 'snk',
    'sog'                                      => 'sog',
    'soga'                                     => 'xog',
    'somalščina'                             => 'so',
    'songajščina'                            => 'son',
    'srbohrvaščina'                          => 'sh',
    'srbščina'                               => 'sr',
    'srednjaangleščina'                      => 'enm',
    'srednjafrancoščina'                     => 'frm',
    'srednjairščina'                         => 'mga',
    'srednjanizozemščina'                    => 'dum',
    'srednjavisokanemščina'                  => 'gmh',
    'srednjeameriškiindijanskijezik'          => 'cai',
    'staraangleščina'                        => 'ang',
    'staracerkvenaslovanščina'               => 'cu',
    'staraegipčanščina'                     => 'egy',
    'starafrancoščina'                       => 'fro',
    'staragrščina'                           => 'grc',
    'starairščina'                           => 'sga',
    'staranordijščina'                       => 'non',
    'staraperzijščina'                       => 'peo',
    'staraprovansalščina'                    => 'pro',
    'staravisokanemščina'                    => 'goh',
    'sukuma'                                   => 'suk',
    'sumerščina'                             => 'sux',
    'sundanščina'                            => 'su',
    'surinamskakreolščina'                   => 'srn',
    'susujščina'                             => 'sus',
    'svahili'                                  => 'sw',
    'svazijščina'                            => 'ss',
    'tachelhit'                                => 'shi',
    'tadžiščina'                            => 'tg',
    'tagalogščina'                           => 'tl',
    'tahitščina'                             => 'ty',
    'taita'                                    => 'dav',
    'tajskijezik'                              => 'tai',
    'tajščina'                               => 'th',
    'tamajaščina'                            => 'tmh',
    'tamilščina'                             => 'ta',
    'taroko'                                   => 'trv',
    'tasawaq'                                  => 'twq',
    'tatarščina'                             => 'tt',
    'telugijščina'                           => 'te',
    'temnejščina'                            => 'tem',
    'ter'                                      => 'ter',
    'teso'                                     => 'teo',
    'tetumščina'                             => 'tet',
    'tibetanščina'                           => 'bo',
    'tigrajščina'                            => 'ti',
    'tigrejščina'                            => 'tig',
    'tivščina'                               => 'tiv',
    'tjapskanigerijščina'                    => 'kcg',
    'tlingitščina'                           => 'tli',
    'tokelavščina'                           => 'tkl',
    'tokpisin'                                 => 'tpi',
    'tongščina'                              => 'to',
    'trukeščina'                             => 'chk',
    'tsimščina'                              => 'tsi',
    'tsonga'                                   => 'ts',
    'tumbukščina'                            => 'tum',
    'tupijskijezik'                            => 'tup',
    'turkmenščina'                           => 'tk',
    'turščina'                               => 'tr',
    'tuvalujščina'                           => 'tvl',
    'tuvinščina'                             => 'tyv',
    'tvi'                                      => 'tw',
    'udmurtščina'                            => 'udm',
    'ugaritskijezik'                           => 'uga',
    'ugrofinskijezik'                          => 'fiu',
    'ujgurščina'                             => 'ug',
    'ukrajinščina'                           => 'uk',
    'umbundščina'                            => 'umb',
    'umetnijezik'                              => 'art',
    'urdujščina'                             => 'ur',
    'uzbeščina'                              => 'uz',
    'vajščina'                               => 'vai',
    'vakaškijezik'                            => 'wak',
    'valamščina'                             => 'wal',
    'valižanščina'                          => 'cy',
    'valonščina'                             => 'wa',
    'varajščina'                             => 'war',
    'vašajščina'                            => 'was',
    'venda'                                    => 've',
    'večjezikov'                              => 'mul',
    'vietnamščina'                           => 'vi',
    'visokanemščinaŠvica'                   => 'de_ch',
    'volapuk'                                  => 'vo',
    'volofščina'                             => 'wo',
    'votjaščina'                             => 'vot',
    'vunjo'                                    => 'vun',
    'vzhodnafrizijščina'                     => 'frs',
    'walser'                                   => 'wae',
    'xhosa'                                    => 'xh',
    'yangben'                                  => 'yav',
    'za'                                       => 'za',
    'zandejščina'                            => 'znd',
    'zapoteščina'                            => 'zap',
    'zarma'                                    => 'dje',
    'zazajščina'                             => 'zza',
    'zenaščina'                              => 'zen',
    'znakovnijezik'                            => 'sgn',
    'znakovnijezikbliss'                       => 'zbl',
    'zulujščina'                             => 'zu',
    'zunijščina'                             => 'zun',
    'čagatajščina'                          => 'chg',
    'čamorščina'                            => 'ch',
    'čejenščina'                            => 'chy',
    'čerokeščina'                           => 'chr',
    'čečenščina'                           => 'ce',
    'češčina'                               => 'cs',
    'čibčevščina'                          => 'chb',
    'činuškižargon'                         => 'chn',
    'čipevščina'                            => 'chp',
    'čoktavščina'                           => 'cho',
    'čuvaščina'                             => 'cv',
    'šanščina'                              => 'shn',
    'šikomor'                                 => 'swb',
    'škotskagelščina'                       => 'gd',
    'škotščina'                             => 'sco',
    'šonščina'                              => 'sn',
    'španščina'                             => 'es',
    'švedščina'                             => 'sv',
    'švicarskafrancoščina'                  => 'fr_ch',
);

1;
