package Locales::DB::Language::lv;

# Auto generated from CLDR

$Locales::DB::Language::lv::VERSION = '0.02';

$Locales::DB::Language::lv::cldr_version = '1.7.1';

%Locales::DB::Language::lv::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Valoda\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Reģions\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nē\:ne\:n",
        'yesstr' => "jā\:ja\:j"
    },
);

%Locales::DB::Language::lv::code_to_name = (
    'aa'    => 'afāru',
    'ab'    => 'abhāzu',
    'ace'   => 'ačinu',
    'ach'   => 'ačolu',
    'ada'   => 'adangmu',
    'ady'   => 'adigu',
    'ae'    => 'avesta',
    'af'    => 'afrikandu',
    'afa'   => "afroaziātu\ valoda",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'akanu',
    'akk'   => 'akadiešu',
    'ale'   => 'aleutu',
    'alg'   => "algonkinu\ valoda",
    'alt'   => 'dienvidaltajiešu',
    'am'    => 'amharu',
    'an'    => 'aragoniešu',
    'ang'   => 'senangļu',
    'anp'   => 'angika',
    'apa'   => "apaču\ valoda",
    'ar'    => 'arābu',
    'arc'   => 'aramiešu',
    'arn'   => 'araukāņu',
    'arp'   => 'arapahu',
    'art'   => "mākslīgā\ valoda",
    'arw'   => 'aravaku',
    'as'    => 'asamiešu',
    'ast'   => 'astūriešu',
    'ath'   => "atapasku\ valoda",
    'aus'   => "austrāliešu\ valoda",
    'av'    => 'avāru',
    'awa'   => 'avadhu',
    'ay'    => 'aimaru',
    'az'    => 'azerbaidžāņu',
    'ba'    => 'baškīru',
    'bad'   => 'bandu',
    'bai'   => "bamileku\ valoda",
    'bal'   => 'beludžu',
    'ban'   => 'baliešu',
    'bas'   => 'basu',
    'bat'   => "baltu\ valoda",
    'be'    => 'baltkrievu',
    'bej'   => 'bedžu',
    'bem'   => 'bembu',
    'ber'   => 'berberu',
    'bg'    => 'bulgāru',
    'bh'    => 'biharu',
    'bho'   => 'bhodžpūru',
    'bi'    => 'bišlamā',
    'bik'   => 'bikolu',
    'bin'   => 'binu',
    'bla'   => 'siksiku',
    'bm'    => 'bambaru',
    'bn'    => 'bengāļu',
    'bnt'   => 'bantu',
    'bo'    => 'tibetiešu',
    'br'    => 'bretoņu',
    'bra'   => 'bradžiešu',
    'bs'    => 'bosniešu',
    'btk'   => 'bataku',
    'bua'   => 'burjatu',
    'bug'   => 'bugu',
    'byn'   => 'bilinu',
    'ca'    => 'katalāņu',
    'cad'   => 'kadu',
    'cai'   => "Centrālamerikas\ indiāņu\ valoda",
    'car'   => 'karību',
    'cau'   => "kaukāziešu\ valoda",
    'cch'   => 'Atsam',
    'ce'    => 'čečenu',
    'ceb'   => 'sebuāņu',
    'cel'   => "ķeltu\ valoda",
    'ch'    => 'čamorru',
    'chb'   => 'čibču',
    'chg'   => 'džagatajs',
    'chk'   => 'čūku',
    'chm'   => 'mariešu',
    'chn'   => "činuku\ žargons",
    'cho'   => 'čoktavu',
    'chp'   => 'čipevaianu',
    'chr'   => 'irokēzu',
    'chy'   => 'šejenu',
    'cmc'   => "čamiešu\ valoda",
    'co'    => 'korsikāņu',
    'cop'   => 'koptu',
    'cpe'   => "angliskā\ kreoliskā\ vai\ pidžinvaloda",
    'cpf'   => "franciskā\ kreoliskā\ vai\ pidžinvaloda",
    'cpp'   => "portugāliskās\ kreoliskās\ vai\ pidžinvaloda",
    'cr'    => 'krī',
    'crh'   => "Krimas\ tatāru",
    'crp'   => "kreoliskā\ vai\ pidžinvaloda",
    'cs'    => 'čehu',
    'csb'   => 'kašubu',
    'cu'    => 'baznīcslāvu',
    'cus'   => "kušītu\ valoda",
    'cv'    => 'čuvašu',
    'cy'    => 'velsiešu',
    'da'    => 'dāņu',
    'dak'   => 'dakotu',
    'dar'   => 'dargu',
    'day'   => "bidayuh\ valoda",
    'de'    => 'vācu',
    'de_at' => "Austrijas\ vācu",
    'de_ch' => "Šveices\ augšvācu",
    'del'   => 'delavēru',
    'den'   => 'sleivu',
    'dgr'   => 'dogribu',
    'din'   => 'dinku',
    'doi'   => 'dogru',
    'dra'   => "dravīdu\ valoda",
    'dsb'   => 'lejassorbu',
    'dua'   => 'dualu',
    'dum'   => 'vidusholandiešu',
    'dv'    => 'maldīviešu',
    'dyu'   => 'diūlu',
    'dz'    => 'dzongke',
    'ee'    => 'evu',
    'efi'   => 'efiku',
    'egy'   => 'ēģiptiešu',
    'eka'   => 'ekadžuku',
    'el'    => 'grieķu',
    'elx'   => 'elamiešu',
    'en'    => 'angļu',
    'en_au' => "Austrālijas\ angļu",
    'en_ca' => "Kanādas\ angļu",
    'en_gb' => "British\ English",
    'en_us' => "angļu\ \(ASV\)",
    'enm'   => 'vidusangļu',
    'eo'    => 'esperanto',
    'es'    => 'spāņu',
    'es_es' => "ibēriešu\ spāņu",
    'et'    => 'igauņu',
    'eu'    => 'basku',
    'ewo'   => 'evondu',
    'fa'    => 'persiešu',
    'fan'   => 'fangu',
    'fat'   => 'fantu',
    'ff'    => 'fulu',
    'fi'    => 'somu',
    'fil'   => 'filipīniešu',
    'fiu'   => "somugru\ valoda",
    'fj'    => 'fidžiešu',
    'fo'    => 'fēru',
    'fon'   => 'fonu',
    'fr'    => 'franču',
    'fr_ca' => "Kanādas\ franču",
    'fr_ch' => "Šveices\ franču",
    'frm'   => 'vidusfranču',
    'fro'   => 'senfranču',
    'frr'   => 'ziemeļfrīzu',
    'frs'   => 'austrumfrīzu',
    'fur'   => 'friūlu',
    'fy'    => 'rietumfrīzu',
    'ga'    => 'īru',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaju',
    'gd'    => 'gēlu',
    'gem'   => "ģermāņu\ valodas",
    'gez'   => 'gēzu',
    'gil'   => 'kiribatiešu',
    'gl'    => 'galisiešu',
    'gmh'   => 'vidusaugšvācu',
    'gn'    => 'gvaranu',
    'goh'   => 'senaugšvācu',
    'gon'   => "gondu\ valodas",
    'gor'   => 'gorontalu',
    'got'   => 'gotu',
    'grb'   => 'grebo',
    'grc'   => 'sengrieķu',
    'gsw'   => "Šveices\ vācu",
    'gu'    => 'gudžaratu',
    'gv'    => 'meniešu',
    'gwi'   => 'kučinu',
    'ha'    => 'hausu',
    'hai'   => 'haidu',
    'haw'   => 'havajiešu',
    'he'    => 'ivrits',
    'hi'    => 'hindi',
    'hil'   => 'hiligainonu',
    'him'   => 'himačali',
    'hit'   => 'hetu',
    'hmn'   => 'hmongu',
    'ho'    => 'hirimotu',
    'hr'    => 'horvātu',
    'hsb'   => 'augšsorbu',
    'ht'    => 'haitiešu',
    'hu'    => 'ungāru',
    'hup'   => 'hupu',
    'hy'    => 'armēņu',
    'hz'    => 'hereru',
    'ia'    => 'interlingva',
    'iba'   => 'ibanu',
    'id'    => 'indonēziešu',
    'ie'    => 'interlingve',
    'ig'    => 'igbo',
    'ii'    => "Sičuaņas\ ji",
    'ijo'   => 'idžbu',
    'ik'    => 'inupiaku',
    'ilo'   => 'iloku',
    'inc'   => "indoāriešu\ valoda",
    'ine'   => "indoeiropiešu\ valoda",
    'inh'   => 'ingušu',
    'io'    => 'ido',
    'ira'   => "irāņu\ valodas",
    'iro'   => "irokēzu\ valoda",
    'is'    => 'īslandiešu',
    'it'    => 'itāliešu',
    'iu'    => 'inuītu',
    'ja'    => 'japāņu',
    'jbo'   => 'ložbans',
    'jpr'   => 'jūdpersiešu',
    'jrb'   => 'jūdarābu',
    'jv'    => 'javiešu',
    'ka'    => 'gruzīnu',
    'kaa'   => 'karakalpaku',
    'kab'   => 'kabilu',
    'kac'   => 'kačinu',
    'kaj'   => 'Jju',
    'kam'   => 'kambu',
    'kar'   => 'karenu',
    'kaw'   => 'kāvi',
    'kbd'   => 'kabardiešu',
    'kcg'   => 'Tyap',
    'kfo'   => 'koru',
    'kg'    => 'kongu',
    'kha'   => 'khasu',
    'khi'   => "hojsanu\ valoda",
    'kho'   => 'hotaniešu',
    'ki'    => 'kikuju',
    'kj'    => 'kvaņamu',
    'kk'    => 'kazahu',
    'kl'    => 'grenlandiešu',
    'km'    => 'khmeru',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannadu',
    'ko'    => 'korejiešu',
    'kok'   => 'konkanu',
    'kos'   => 'kosrājiešu',
    'kpe'   => 'kpellu',
    'kr'    => 'kanuru',
    'krc'   => "karačaju\ un\ balkāru",
    'krl'   => 'karēļu',
    'kro'   => 'krū',
    'kru'   => 'kuruhu',
    'ks'    => 'kašmiriešu',
    'ku'    => 'kurdu',
    'kum'   => 'kumiku',
    'kut'   => 'kutenaju',
    'kv'    => 'komiešu',
    'kw'    => 'korniešu',
    'ky'    => 'kirgīzu',
    'la'    => 'latīņu',
    'lad'   => 'ladino',
    'lah'   => 'landu',
    'lam'   => 'lambu',
    'lb'    => 'luksemburgiešu',
    'lez'   => 'lezgīnu',
    'lg'    => 'gandu',
    'li'    => 'limburgiešu',
    'ln'    => 'lingala',
    'lo'    => 'laosiešu',
    'lol'   => 'mongu',
    'loz'   => 'lozu',
    'lt'    => 'lietuviešu',
    'lu'    => 'lubakatanga',
    'lua'   => 'lubalulva',
    'lui'   => 'luisenu',
    'lun'   => 'lundu',
    'luo'   => 'luo',
    'lus'   => 'lušeju',
    'lv'    => 'latviešu',
    'mad'   => 'maduriešu',
    'mag'   => 'magahiešu',
    'mai'   => 'maithili',
    'mak'   => 'makasaru',
    'man'   => 'mandingu',
    'map'   => "austronēziešu\ valoda",
    'mas'   => 'masaju',
    'mdf'   => 'mokšu',
    'mdr'   => 'mandaru',
    'men'   => 'mendu',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasu',
    'mga'   => 'vidusīru',
    'mh'    => 'māršaliešu',
    'mi'    => 'maoru',
    'mic'   => 'mikmaku',
    'min'   => 'minangkabavu',
    'mis'   => "dažādas\ valodas",
    'mk'    => 'maķedoniešu',
    'mkh'   => "monkhmeru\ valoda",
    'ml'    => 'malajalu',
    'mn'    => 'mongoļu',
    'mnc'   => 'mandžūru',
    'mni'   => 'manipūru',
    'mno'   => "manobu\ valoda",
    'mo'    => 'moldāvu',
    'moh'   => 'mohauku',
    'mos'   => 'mosu',
    'mr'    => 'maratu',
    'ms'    => 'malajiešu',
    'mt'    => 'maltiešu',
    'mul'   => "vairākas\ valodas",
    'mun'   => "mundu\ valoda",
    'mus'   => 'krīku',
    'mwl'   => 'mirandiešu',
    'mwr'   => 'marvaru',
    'my'    => 'birmiešu',
    'myn'   => "maiju\ valoda",
    'myv'   => 'erzju',
    'na'    => 'nauruiešu',
    'nah'   => 'navatlu',
    'nai'   => "Ziemeļamerikas\ indiāņu\ valoda",
    'nap'   => 'neapoliešu',
    'nb'    => "norvēģu\ bukmols",
    'nd'    => 'ziemeļndebelu',
    'nds'   => 'lejasvācu',
    'ne'    => 'nepāliešu',
    'new'   => 'nevaru',
    'ng'    => 'ndongu',
    'nia'   => 'njasu',
    'nic'   => "nigēriešu\-kordofāņu\ valoda",
    'niu'   => 'niuāņu',
    'nl'    => 'holandiešu',
    'nl_be' => 'flāmu',
    'nn'    => 'jaunnorvēģu',
    'no'    => 'norvēģu',
    'nog'   => 'nogaju',
    'non'   => 'sennorvēģu',
    'nqo'   => "n\-ko",
    'nr'    => 'dienvidndebelu',
    'nso'   => 'ziemeļsotu',
    'nub'   => "nūbiešu\ valodas",
    'nv'    => 'navahu',
    'nwc'   => "klasiskā\ nevaru",
    'ny'    => 'čičeva',
    'nym'   => 'ņamvezu',
    'nyn'   => 'ņankolu',
    'nyo'   => 'ņoru',
    'nzi'   => 'nzemu',
    'oc'    => 'oksitāņu',
    'oj'    => 'odžibvu',
    'om'    => 'oromu',
    'or'    => 'orisiešu',
    'os'    => 'osetīnu',
    'osa'   => 'važāžu',
    'ota'   => "turku\ osmaņu",
    'oto'   => "otomu\ valoda",
    'pa'    => 'pandžabu',
    'paa'   => "papuasu\ valoda",
    'pag'   => 'pangasinanu',
    'pal'   => 'pehlevi',
    'pam'   => 'pampanganu',
    'pap'   => 'papjamento',
    'pau'   => 'palaviešu',
    'peo'   => 'senpersu',
    'phi'   => "filipīniešu\ valoda",
    'phn'   => 'feniķiešu',
    'pi'    => 'pāli',
    'pl'    => 'poļu',
    'pon'   => 'ponapiešu',
    'pra'   => "prākrita\ valoda",
    'pro'   => 'senprovansiešu',
    'ps'    => 'puštu',
    'pt'    => 'portugāļu',
    'pt_br' => "Brazīlijas\ portugāļu",
    'pt_pt' => "ibēriešu\ portugāļu",
    'qu'    => 'kečvu',
    'raj'   => 'radžastāņu',
    'rap'   => 'rapanuju',
    'rar'   => 'rarotongiešu',
    'rm'    => 'retoromāņu',
    'rn'    => 'rundu',
    'ro'    => 'rumāņu',
    'roa'   => "romāņu\ valoda",
    'rom'   => 'čigānu',
    'ru'    => 'krievu',
    'rup'   => 'aromūnu',
    'rw'    => 'kiņaruanda',
    'sa'    => 'sanskrits',
    'sad'   => 'sandavu',
    'sah'   => 'jakutu',
    'sai'   => "Dienvidamerikas\ indiāņu\ valoda",
    'sal'   => "sališu\ valoda",
    'sam'   => "samārijas\ aramiešu",
    'sas'   => 'sasaku',
    'sat'   => 'santalu',
    'sc'    => 'sardīniešu',
    'scn'   => 'sicīliešu',
    'sco'   => 'skotu',
    'sd'    => 'sindhu',
    'se'    => 'ziemeļsāmu',
    'sel'   => 'selkupu',
    'sem'   => "semītu\ valoda",
    'sg'    => 'sangu',
    'sga'   => 'senīru',
    'sgn'   => "zīmju\ valodas",
    'sh'    => "serbu\-horvātu",
    'shn'   => 'šanu',
    'si'    => 'singāļu',
    'sid'   => 'sidamu',
    'sio'   => "siū\ valodas",
    'sit'   => "sinotibetiešu\ valoda",
    'sk'    => 'slovāku',
    'sl'    => 'slovēņu',
    'sla'   => 'slāvu',
    'sm'    => 'samoāņu',
    'sma'   => 'dienvidsāmu',
    'smi'   => "sāmu\ valoda",
    'smj'   => "Luleo\ sāmu",
    'smn'   => "Inari\ sāmu",
    'sms'   => 'skoltsāmu',
    'sn'    => 'šonu',
    'snk'   => 'soninku',
    'so'    => 'somāļu',
    'sog'   => 'sogdiešu',
    'son'   => 'songaju',
    'sq'    => 'albāņu',
    'sr'    => 'serbu',
    'srn'   => 'sranantogo',
    'srr'   => 'serēru',
    'ss'    => 'svatu',
    'ssa'   => "nīlas\-sahāras\ valoda",
    'st'    => 'sesoto',
    'su'    => 'sundaniešu',
    'suk'   => 'sukumu',
    'sus'   => 'susu',
    'sux'   => 'šumeru',
    'sv'    => 'zviedru',
    'sw'    => 'svahili',
    'syc'   => "klasiskā\ sīriešu",
    'syr'   => 'sīriešu',
    'ta'    => 'tamilu',
    'tai'   => "taju\ valoda",
    'te'    => 'telugu',
    'tem'   => 'temnu',
    'ter'   => 'tereno',
    'tet'   => 'tetumu',
    'tg'    => 'tadžiku',
    'th'    => 'taju',
    'ti'    => 'tigrinja',
    'tig'   => 'tigru',
    'tiv'   => 'tivu',
    'tk'    => 'turkmēņu',
    'tkl'   => 'tokelaviešu',
    'tl'    => 'tagalu',
    'tlh'   => 'klingoņu',
    'tli'   => 'tlinkitu',
    'tmh'   => 'tuaregu',
    'tn'    => 'cvanu',
    'to'    => 'tongu',
    'tog'   => "Njasas\ tongu",
    'tpi'   => 'tokpisins',
    'tr'    => 'turku',
    'trv'   => 'Taroko',
    'ts'    => 'congu',
    'tsi'   => 'cimšiāņu',
    'tt'    => 'tatāru',
    'tum'   => 'tumbuku',
    'tup'   => "tupu\ valodas",
    'tut'   => "altajiešu\ valoda",
    'tvl'   => 'tuvaliešu',
    'tw'    => 'tvī',
    'ty'    => 'taitiešu',
    'tyv'   => 'tuviešu',
    'udm'   => 'udmurtu',
    'ug'    => 'uiguru',
    'uga'   => 'ugaritiešu',
    'uk'    => 'ukraiņu',
    'umb'   => 'umbundu',
    'und'   => "nezināma\ vai\ nederīga\ valoda",
    'ur'    => 'urdu',
    'uz'    => 'uzbeku',
    'vai'   => 'vaju',
    've'    => 'vendu',
    'vi'    => 'vjetnamiešu',
    'vo'    => 'volapiks',
    'vot'   => 'votu',
    'wa'    => 'valoņu',
    'wak'   => "vakašu\ valoda",
    'wal'   => 'valamu',
    'war'   => 'varaju',
    'was'   => 'vašo',
    'wen'   => 'sorbu',
    'wo'    => 'volofu',
    'xal'   => 'kalmiku',
    'xh'    => 'khosu',
    'yao'   => 'jao',
    'yap'   => 'japiešu',
    'yi'    => 'jidišs',
    'yo'    => 'jorubu',
    'ypk'   => "jupiku\ valoda",
    'za'    => 'džuanu',
    'zap'   => 'sapoteku',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenagu',
    'zh'    => 'ķīniešu',
    'znd'   => 'zandē',
    'zu'    => 'zulu',
    'zun'   => 'zunju',
    'zxx'   => "Bez\ lingvistiska\ satura",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::lv::name_to_code = (
    'abhāzu'                                    => 'ab',
    'adangmu'                                    => 'ada',
    'adigu'                                      => 'ady',
    'afrihili'                                   => 'afh',
    'afrikandu'                                  => 'af',
    'afroaziātuvaloda'                          => 'afa',
    'afāru'                                     => 'aa',
    'aimaru'                                     => 'ay',
    'ainu'                                       => 'ain',
    'akadiešu'                                  => 'akk',
    'akanu'                                      => 'ak',
    'albāņu'                                   => 'sq',
    'aleutu'                                     => 'ale',
    'algonkinuvaloda'                            => 'alg',
    'altajiešuvaloda'                           => 'tut',
    'amharu'                                     => 'am',
    'angika'                                     => 'anp',
    'angliskākreoliskāvaipidžinvaloda'        => 'cpe',
    'angļu'                                     => 'en',
    'angļuasv'                                  => 'en_us',
    'apačuvaloda'                               => 'apa',
    'aragoniešu'                                => 'an',
    'aramiešu'                                  => 'arc',
    'arapahu'                                    => 'arp',
    'araukāņu'                                 => 'arn',
    'aravaku'                                    => 'arw',
    'armēņu'                                   => 'hy',
    'aromūnu'                                   => 'rup',
    'arābu'                                     => 'ar',
    'asamiešu'                                  => 'as',
    'astūriešu'                                => 'ast',
    'atapaskuvaloda'                             => 'ath',
    'atsam'                                      => 'cch',
    'augšsorbu'                                 => 'hsb',
    'austrijasvācu'                             => 'de_at',
    'austronēziešuvaloda'                      => 'map',
    'austrumfrīzu'                              => 'frs',
    'austrāliešuvaloda'                        => 'aus',
    'austrālijasangļu'                         => 'en_au',
    'avadhu'                                     => 'awa',
    'avesta'                                     => 'ae',
    'avāru'                                     => 'av',
    'azerbaidžāņu'                            => 'az',
    'ačinu'                                     => 'ace',
    'ačolu'                                     => 'ach',
    'baliešu'                                   => 'ban',
    'baltkrievu'                                 => 'be',
    'baltuvaloda'                                => 'bat',
    'bambaru'                                    => 'bm',
    'bamilekuvaloda'                             => 'bai',
    'bandu'                                      => 'bad',
    'bantu'                                      => 'bnt',
    'basku'                                      => 'eu',
    'basu'                                       => 'bas',
    'bataku'                                     => 'btk',
    'baznīcslāvu'                              => 'cu',
    'baškīru'                                  => 'ba',
    'bedžu'                                     => 'bej',
    'beludžu'                                   => 'bal',
    'bembu'                                      => 'bem',
    'bengāļu'                                  => 'bn',
    'berberu'                                    => 'ber',
    'bezlingvistiskasatura'                      => 'zxx',
    'bhodžpūru'                                => 'bho',
    'bidayuhvaloda'                              => 'day',
    'biharu'                                     => 'bh',
    'bikolu'                                     => 'bik',
    'bilinu'                                     => 'byn',
    'binu'                                       => 'bin',
    'birmiešu'                                  => 'my',
    'bišlamā'                                  => 'bi',
    'blissymbols'                                => 'zbl',
    'bosniešu'                                  => 'bs',
    'bradžiešu'                                => 'bra',
    'brazīlijasportugāļu'                     => 'pt_br',
    'bretoņu'                                   => 'br',
    'britishenglish'                             => 'en_gb',
    'bugu'                                       => 'bug',
    'bulgāru'                                   => 'bg',
    'burjatu'                                    => 'bua',
    'centrālamerikasindiāņuvaloda'            => 'cai',
    'cimšiāņu'                                => 'tsi',
    'congu'                                      => 'ts',
    'cvanu'                                      => 'tn',
    'dakotu'                                     => 'dak',
    'dargu'                                      => 'dar',
    'dažādasvalodas'                           => 'mis',
    'delavēru'                                  => 'del',
    'dienvidaltajiešu'                          => 'alt',
    'dienvidamerikasindiāņuvaloda'             => 'sai',
    'dienvidndebelu'                             => 'nr',
    'dienvidsāmu'                               => 'sma',
    'dinku'                                      => 'din',
    'diūlu'                                     => 'dyu',
    'dogribu'                                    => 'dgr',
    'dogru'                                      => 'doi',
    'dravīduvaloda'                             => 'dra',
    'dualu'                                      => 'dua',
    'dzongke'                                    => 'dz',
    'dāņu'                                     => 'da',
    'džagatajs'                                 => 'chg',
    'džuanu'                                    => 'za',
    'efiku'                                      => 'efi',
    'ekadžuku'                                  => 'eka',
    'elamiešu'                                  => 'elx',
    'erzju'                                      => 'myv',
    'esperanto'                                  => 'eo',
    'evondu'                                     => 'ewo',
    'evu'                                        => 'ee',
    'fangu'                                      => 'fan',
    'fantu'                                      => 'fat',
    'feniķiešu'                                => 'phn',
    'fidžiešu'                                 => 'fj',
    'filipīniešu'                              => 'fil',
    'filipīniešuvaloda'                        => 'phi',
    'flāmu'                                     => 'nl_be',
    'fonu'                                       => 'fon',
    'franciskākreoliskāvaipidžinvaloda'       => 'cpf',
    'franču'                                    => 'fr',
    'friūlu'                                    => 'fur',
    'fulu'                                       => 'ff',
    'fēru'                                      => 'fo',
    'ga'                                         => 'gaa',
    'gajo'                                       => 'gay',
    'galisiešu'                                 => 'gl',
    'gandu'                                      => 'lg',
    'gbaju'                                      => 'gba',
    'gonduvalodas'                               => 'gon',
    'gorontalu'                                  => 'gor',
    'gotu'                                       => 'got',
    'grebo'                                      => 'grb',
    'grenlandiešu'                              => 'kl',
    'grieķu'                                    => 'el',
    'gruzīnu'                                   => 'ka',
    'gudžaratu'                                 => 'gu',
    'gvaranu'                                    => 'gn',
    'gēlu'                                      => 'gd',
    'gēzu'                                      => 'gez',
    'haidu'                                      => 'hai',
    'haitiešu'                                  => 'ht',
    'hausu'                                      => 'ha',
    'havajiešu'                                 => 'haw',
    'hereru'                                     => 'hz',
    'hetu'                                       => 'hit',
    'hiligainonu'                                => 'hil',
    'himačali'                                  => 'him',
    'hindi'                                      => 'hi',
    'hirimotu'                                   => 'ho',
    'hmongu'                                     => 'hmn',
    'hojsanuvaloda'                              => 'khi',
    'holandiešu'                                => 'nl',
    'horvātu'                                   => 'hr',
    'hotaniešu'                                 => 'kho',
    'hupu'                                       => 'hup',
    'ibanu'                                      => 'iba',
    'ibēriešuportugāļu'                      => 'pt_pt',
    'ibēriešuspāņu'                          => 'es_es',
    'ido'                                        => 'io',
    'idžbu'                                     => 'ijo',
    'igauņu'                                    => 'et',
    'igbo'                                       => 'ig',
    'iloku'                                      => 'ilo',
    'inarisāmu'                                 => 'smn',
    'indoeiropiešuvaloda'                       => 'ine',
    'indonēziešu'                              => 'id',
    'indoāriešuvaloda'                         => 'inc',
    'ingušu'                                    => 'inh',
    'interlingva'                                => 'ia',
    'interlingve'                                => 'ie',
    'inupiaku'                                   => 'ik',
    'inuītu'                                    => 'iu',
    'irokēzu'                                   => 'chr',
    'irokēzuvaloda'                             => 'iro',
    'irāņuvalodas'                             => 'ira',
    'itāliešu'                                 => 'it',
    'ivrits'                                     => 'he',
    'jakutu'                                     => 'sah',
    'jao'                                        => 'yao',
    'japiešu'                                   => 'yap',
    'japāņu'                                   => 'ja',
    'jaunnorvēģu'                              => 'nn',
    'javiešu'                                   => 'jv',
    'jidišs'                                    => 'yi',
    'jju'                                        => 'kaj',
    'jorubu'                                     => 'yo',
    'jupikuvaloda'                               => 'ypk',
    'jūdarābu'                                 => 'jrb',
    'jūdpersiešu'                              => 'jpr',
    'kabardiešu'                                => 'kbd',
    'kabilu'                                     => 'kab',
    'kadu'                                       => 'cad',
    'kalmiku'                                    => 'xal',
    'kambu'                                      => 'kam',
    'kannadu'                                    => 'kn',
    'kanuru'                                     => 'kr',
    'kanādasangļu'                             => 'en_ca',
    'kanādasfranču'                            => 'fr_ca',
    'karakalpaku'                                => 'kaa',
    'karačajuunbalkāru'                        => 'krc',
    'karenu'                                     => 'kar',
    'karēļu'                                   => 'krl',
    'karību'                                    => 'car',
    'katalāņu'                                 => 'ca',
    'kaukāziešuvaloda'                         => 'cau',
    'kazahu'                                     => 'kk',
    'kačinu'                                    => 'kac',
    'kašmiriešu'                               => 'ks',
    'kašubu'                                    => 'csb',
    'kečvu'                                     => 'qu',
    'khasu'                                      => 'kha',
    'khmeru'                                     => 'km',
    'khosu'                                      => 'xh',
    'kikuju'                                     => 'ki',
    'kimbundu'                                   => 'kmb',
    'kirgīzu'                                   => 'ky',
    'kiribatiešu'                               => 'gil',
    'kiņaruanda'                                => 'rw',
    'klasiskānevaru'                            => 'nwc',
    'klasiskāsīriešu'                         => 'syc',
    'klingoņu'                                  => 'tlh',
    'komiešu'                                   => 'kv',
    'kongu'                                      => 'kg',
    'konkanu'                                    => 'kok',
    'koptu'                                      => 'cop',
    'korejiešu'                                 => 'ko',
    'korniešu'                                  => 'kw',
    'korsikāņu'                                => 'co',
    'koru'                                       => 'kfo',
    'kosrājiešu'                               => 'kos',
    'kpellu'                                     => 'kpe',
    'kreoliskāvaipidžinvaloda'                 => 'crp',
    'krievu'                                     => 'ru',
    'krimastatāru'                              => 'crh',
    'krī'                                       => 'cr',
    'krīku'                                     => 'mus',
    'krū'                                       => 'kro',
    'kumiku'                                     => 'kum',
    'kurdu'                                      => 'ku',
    'kuruhu'                                     => 'kru',
    'kutenaju'                                   => 'kut',
    'kučinu'                                    => 'gwi',
    'kušītuvaloda'                             => 'cus',
    'kvaņamu'                                   => 'kj',
    'kāvi'                                      => 'kaw',
    'ladino'                                     => 'lad',
    'lambu'                                      => 'lam',
    'landu'                                      => 'lah',
    'laosiešu'                                  => 'lo',
    'latviešu'                                  => 'lv',
    'latīņu'                                   => 'la',
    'lejassorbu'                                 => 'dsb',
    'lejasvācu'                                 => 'nds',
    'lezgīnu'                                   => 'lez',
    'lietuviešu'                                => 'lt',
    'limburgiešu'                               => 'li',
    'lingala'                                    => 'ln',
    'lozu'                                       => 'loz',
    'ložbans'                                   => 'jbo',
    'lubakatanga'                                => 'lu',
    'lubalulva'                                  => 'lua',
    'luisenu'                                    => 'lui',
    'luksemburgiešu'                            => 'lb',
    'luleosāmu'                                 => 'smj',
    'lundu'                                      => 'lun',
    'luo'                                        => 'luo',
    'lušeju'                                    => 'lus',
    'maduriešu'                                 => 'mad',
    'magahiešu'                                 => 'mag',
    'maijuvaloda'                                => 'myn',
    'maithili'                                   => 'mai',
    'makasaru'                                   => 'mak',
    'malagasu'                                   => 'mg',
    'malajalu'                                   => 'ml',
    'malajiešu'                                 => 'ms',
    'maldīviešu'                               => 'dv',
    'maltiešu'                                  => 'mt',
    'mandaru'                                    => 'mdr',
    'mandingu'                                   => 'man',
    'mandžūru'                                 => 'mnc',
    'manipūru'                                  => 'mni',
    'manobuvaloda'                               => 'mno',
    'maoru'                                      => 'mi',
    'maratu'                                     => 'mr',
    'mariešu'                                   => 'chm',
    'marvaru'                                    => 'mwr',
    'masaju'                                     => 'mas',
    'maķedoniešu'                              => 'mk',
    'mendu'                                      => 'men',
    'meniešu'                                   => 'gv',
    'mikmaku'                                    => 'mic',
    'minangkabavu'                               => 'min',
    'mirandiešu'                                => 'mwl',
    'mohauku'                                    => 'moh',
    'mokšu'                                     => 'mdf',
    'moldāvu'                                   => 'mo',
    'mongoļu'                                   => 'mn',
    'mongu'                                      => 'lol',
    'monkhmeruvaloda'                            => 'mkh',
    'morisyen'                                   => 'mfe',
    'mosu'                                       => 'mos',
    'munduvaloda'                                => 'mun',
    'mākslīgāvaloda'                          => 'art',
    'māršaliešu'                              => 'mh',
    'nauruiešu'                                 => 'na',
    'navahu'                                     => 'nv',
    'navatlu'                                    => 'nah',
    'ndongu'                                     => 'ng',
    'neapoliešu'                                => 'nap',
    'nepāliešu'                                => 'ne',
    'nevaru'                                     => 'new',
    'nezināmavainederīgavaloda'                => 'und',
    'nigēriešukordofāņuvaloda'               => 'nic',
    'niuāņu'                                   => 'niu',
    'njasastongu'                                => 'tog',
    'njasu'                                      => 'nia',
    'nko'                                        => 'nqo',
    'nogaju'                                     => 'nog',
    'norvēģu'                                  => 'no',
    'norvēģubukmols'                           => 'nb',
    'nzemu'                                      => 'nzi',
    'nīlassahārasvaloda'                       => 'ssa',
    'nūbiešuvalodas'                           => 'nub',
    'odžibvu'                                   => 'oj',
    'oksitāņu'                                 => 'oc',
    'orisiešu'                                  => 'or',
    'oromu'                                      => 'om',
    'osetīnu'                                   => 'os',
    'otomuvaloda'                                => 'oto',
    'palaviešu'                                 => 'pau',
    'pampanganu'                                 => 'pam',
    'pandžabu'                                  => 'pa',
    'pangasinanu'                                => 'pag',
    'papjamento'                                 => 'pap',
    'papuasuvaloda'                              => 'paa',
    'pehlevi'                                    => 'pal',
    'persiešu'                                  => 'fa',
    'ponapiešu'                                 => 'pon',
    'portugāliskāskreoliskāsvaipidžinvaloda' => 'cpp',
    'portugāļu'                                => 'pt',
    'poļu'                                      => 'pl',
    'prākritavaloda'                            => 'pra',
    'puštu'                                     => 'ps',
    'pāli'                                      => 'pi',
    'radžastāņu'                              => 'raj',
    'rapanuju'                                   => 'rap',
    'rarotongiešu'                              => 'rar',
    'retoromāņu'                               => 'rm',
    'rietumfrīzu'                               => 'fy',
    'romāņuvaloda'                             => 'roa',
    'rumāņu'                                   => 'ro',
    'rundu'                                      => 'rn',
    'sališuvaloda'                              => 'sal',
    'samoāņu'                                  => 'sm',
    'samārijasaramiešu'                        => 'sam',
    'sandavu'                                    => 'sad',
    'sangu'                                      => 'sg',
    'sanskrits'                                  => 'sa',
    'santalu'                                    => 'sat',
    'sapoteku'                                   => 'zap',
    'sardīniešu'                               => 'sc',
    'sasaku'                                     => 'sas',
    'sebuāņu'                                  => 'ceb',
    'selkupu'                                    => 'sel',
    'semītuvaloda'                              => 'sem',
    'senangļu'                                  => 'ang',
    'senaugšvācu'                              => 'goh',
    'senfranču'                                 => 'fro',
    'sengrieķu'                                 => 'grc',
    'sennorvēģu'                               => 'non',
    'senpersu'                                   => 'peo',
    'senprovansiešu'                            => 'pro',
    'senīru'                                    => 'sga',
    'serbu'                                      => 'sr',
    'serbuhorvātu'                              => 'sh',
    'serēru'                                    => 'srr',
    'sesoto'                                     => 'st',
    'sicīliešu'                                => 'scn',
    'sidamu'                                     => 'sid',
    'siksiku'                                    => 'bla',
    'sindhu'                                     => 'sd',
    'singāļu'                                  => 'si',
    'sinotibetiešuvaloda'                       => 'sit',
    'sičuaņasji'                               => 'ii',
    'siūvalodas'                                => 'sio',
    'skoltsāmu'                                 => 'sms',
    'skotu'                                      => 'sco',
    'sleivu'                                     => 'den',
    'slovāku'                                   => 'sk',
    'slovēņu'                                  => 'sl',
    'slāvu'                                     => 'sla',
    'sogdiešu'                                  => 'sog',
    'somu'                                       => 'fi',
    'somugruvaloda'                              => 'fiu',
    'somāļu'                                   => 'so',
    'songaju'                                    => 'son',
    'soninku'                                    => 'snk',
    'sorbu'                                      => 'wen',
    'spāņu'                                    => 'es',
    'sranantogo'                                 => 'srn',
    'sukumu'                                     => 'suk',
    'sundaniešu'                                => 'su',
    'susu'                                       => 'sus',
    'svahili'                                    => 'sw',
    'svatu'                                      => 'ss',
    'sāmuvaloda'                                => 'smi',
    'sīriešu'                                  => 'syr',
    'tadžiku'                                   => 'tg',
    'tagalu'                                     => 'tl',
    'taitiešu'                                  => 'ty',
    'taju'                                       => 'th',
    'tajuvaloda'                                 => 'tai',
    'tamilu'                                     => 'ta',
    'taroko'                                     => 'trv',
    'tatāru'                                    => 'tt',
    'telugu'                                     => 'te',
    'temnu'                                      => 'tem',
    'tereno'                                     => 'ter',
    'tetumu'                                     => 'tet',
    'tibetiešu'                                 => 'bo',
    'tigrinja'                                   => 'ti',
    'tigru'                                      => 'tig',
    'tivu'                                       => 'tiv',
    'tlinkitu'                                   => 'tli',
    'tokelaviešu'                               => 'tkl',
    'tokpisins'                                  => 'tpi',
    'tongu'                                      => 'to',
    'tuaregu'                                    => 'tmh',
    'tumbuku'                                    => 'tum',
    'tupuvalodas'                                => 'tup',
    'turkmēņu'                                 => 'tk',
    'turku'                                      => 'tr',
    'turkuosmaņu'                               => 'ota',
    'tuvaliešu'                                 => 'tvl',
    'tuviešu'                                   => 'tyv',
    'tvī'                                       => 'tw',
    'tyap'                                       => 'kcg',
    'udmurtu'                                    => 'udm',
    'ugaritiešu'                                => 'uga',
    'uiguru'                                     => 'ug',
    'ukraiņu'                                   => 'uk',
    'umbundu'                                    => 'umb',
    'ungāru'                                    => 'hu',
    'urdu'                                       => 'ur',
    'uzbeku'                                     => 'uz',
    'vairākasvalodas'                           => 'mul',
    'vaju'                                       => 'vai',
    'vakašuvaloda'                              => 'wak',
    'valamu'                                     => 'wal',
    'valoņu'                                    => 'wa',
    'varaju'                                     => 'war',
    'vašo'                                      => 'was',
    'važāžu'                                  => 'osa',
    'velsiešu'                                  => 'cy',
    'vendu'                                      => 've',
    'vidusangļu'                                => 'enm',
    'vidusaugšvācu'                            => 'gmh',
    'vidusfranču'                               => 'frm',
    'vidusholandiešu'                           => 'dum',
    'vidusīru'                                  => 'mga',
    'vjetnamiešu'                               => 'vi',
    'volapiks'                                   => 'vo',
    'volofu'                                     => 'wo',
    'votu'                                       => 'vot',
    'vācu'                                      => 'de',
    'zandē'                                     => 'znd',
    'zaza'                                       => 'zza',
    'zenagu'                                     => 'zen',
    'ziemeļamerikasindiāņuvaloda'             => 'nai',
    'ziemeļfrīzu'                              => 'frr',
    'ziemeļndebelu'                             => 'nd',
    'ziemeļsotu'                                => 'nso',
    'ziemeļsāmu'                               => 'se',
    'zulu'                                       => 'zu',
    'zunju'                                      => 'zun',
    'zviedru'                                    => 'sv',
    'zīmjuvalodas'                              => 'sgn',
    'čamiešuvaloda'                            => 'cmc',
    'čamorru'                                   => 'ch',
    'čehu'                                      => 'cs',
    'čečenu'                                   => 'ce',
    'čibču'                                    => 'chb',
    'čigānu'                                   => 'rom',
    'činukužargons'                            => 'chn',
    'čipevaianu'                                => 'chp',
    'čičeva'                                   => 'ny',
    'čoktavu'                                   => 'cho',
    'čuvašu'                                   => 'cv',
    'čūku'                                     => 'chk',
    'ēģiptiešu'                               => 'egy',
    'ģermāņuvalodas'                          => 'gem',
    'īru'                                       => 'ga',
    'īslandiešu'                               => 'is',
    'ķeltuvaloda'                               => 'cel',
    'ķīniešu'                                 => 'zh',
    'ņamvezu'                                   => 'nym',
    'ņankolu'                                   => 'nyn',
    'ņoru'                                      => 'nyo',
    'Šveicesaugšvācu'                         => 'de_ch',
    'Šveicesfranču'                            => 'fr_ch',
    'Šveicesvācu'                              => 'gsw',
    'šanu'                                      => 'shn',
    'šejenu'                                    => 'chy',
    'šonu'                                      => 'sn',
    'šumeru'                                    => 'sux',
);

1;
