BEGIN {
    # Okay, so some people wanting to check out the latest and greatest
    # version from github is getting stuck not knowing what M::I modules
    # to install. So do the check here
    my @modules = qw(
        inc::Module::Install
        Module::Install::AuthorTests
        Module::Install::ReadmeFromPod
        Module::Install::TestTarget
        Module::Install::XSUtil
    );

    my @missing;
    foreach my $module (@modules) {
        eval "require $module";
        push @missing, $module if $@;
    }
    if (@missing) {
        print STDERR <<EOM;

**** Missing Developer Tools! ****

Whoa there, you don't have the required modules to run this Makefile.PL!
This probably means you cloned the repository from github (if you
encounter this from a tarball uploaded to CPAN, it's a bug, so please
report it).

If you are running from a cloned git repository, install the following
modules first:
EOM
        foreach my $module (@missing) {
            $module =~ s/^inc:://;
            print "    * $module\n";
        }
        print STDERR <<EOM;
and try again.

While you're at it, install these modules as they are needed to run
the tests:

    * Test::Exception (at least 0.29)
    * Test::Requires
    * Test::TCP

EOM
        exit 0;
    }
    Module::Install->import;
}

use File::Spec;

name 'ZeroMQ';

{ # M::I is silly about multiple authors:
    my $mainpm = 'lib/ZeroMQ.pm';
    name_from $mainpm;
    version_from $mainpm;
    perl_version_from $mainpm;
    license_from $mainpm;
    abstract_from $mainpm;
    readme_from $mainpm;
    author 'Daisuke Maki <daisuke@endeworks.jp>';
    author 'Steffen Mueller <smueller@cpan.org>';
}

test_requires 'Test::TCP';
test_requires 'Test::Requires';
test_requires 'Test::Exception' => '0.29';
recommends 'JSON' => '2.00';
use_xshelper '-clean';

use_ppport;
cc_warnings;
if ($ENV{INCLUDES}) {
    cc_include_paths split/\s+/, $ENV{INCLUDES};
}
if ($ENV{LIBS}) {
    cc_libs $ENV{LIBS} . ' -lzmq';
}
cc_src_paths 'xs';
cc_assert_lib 'zmq';

default_test_target 
    env => {
        LC_ALL => 'C'
    }
;
author_tests 'xt';
WriteAll;

if ($Module::Install::AUTHOR) {
    write_constants_file( File::Spec->catfile('xs', 'const-xs.inc') );
    write_typemap( File::Spec->catfile('xs', 'typemap') );
}

sub write_constants_file {
    my $file = shift;

    my $header = $ENV{ZMQ_H} || '/usr/local/include/zmq.h';

    open( my $in, '<', $header ) or
        die "Could not open file $header for reading: $!";

    open( my $out, '>', $file ) or
        die "Could not open file $file for writing: $!";
    print $out
        "# Do NOT edit this file! This file was automatically generated\n",
        "# by Makefile.PL on @{[scalar localtime]}. If you want to\n",
        "# regenerate it, remove this file and re-run Makefile.PL\n",
        "\n",
        "IV\n",
        "_constant()\n",
        "    ALIAS:\n",
    ;


    while (my $ln = <$in>) {
        if ($ln =~ /^\#define\s+(ZMQ_[A-Z0-9_]+)\s+/) {
            print $out "        $1 = $1\n";
        }
    }
    close $in;
    print $out
        "    CODE:\n",
        "        RETVAL = ix;\n",
        "    OUTPUT:\n",
        "        RETVAL\n"
    ;
    close $out;
}

sub write_typemap {
    my $file = shift;

    my @perl_types = qw(
        ZeroMQ::Raw::Context
        ZeroMQ::Raw::Socket
        ZeroMQ::Raw::Message
    );

    open( my $out, '>', $file ) or
        die "Could not open $file for writing: $!";

    my (@decl, @input, @output);
    foreach my $perl_type (@perl_types) {
        my $c_type = $perl_type;
        $c_type =~ s/::/_/g;
        $c_type =~ s/^ZeroMQ_/PerlZMQ_/;
        my $typemap_type = 'T_' . uc $c_type;

        push @decl, "$c_type* $typemap_type";
        push @input, <<EOM;
$typemap_type
    {
        MAGIC *mg;
        \$var = NULL;
        if (sv_isobject(\$arg)) {
            mg = ${c_type}_mg_find(aTHX_ SvRV(\$arg), &${c_type}_vtbl);
            if (mg) {
                \$var = ($c_type *) mg->mg_ptr;
            }
        }

        if (\$var == NULL)
            croak(\\"Invalid $perl_type object (perhaps you've already freed it?)\\");
    }
EOM
        push @output, <<EOM;
$typemap_type
        if (!\$var)          /* if null */
            SvOK_off(\$arg); /* then return as undef instead of reaf to undef */
        else {
            /* setup \$arg as a ref to a blessed hash hv */
            MAGIC *mg;
            HV *hv = newHV();
            const char *classname = \\"$perl_type\\";
            /* take (sub)class name to use from class_sv if appropriate */
            if (SvMAGICAL(class_sv))
                mg_get(class_sv);

            if (SvOK( class_sv ) && sv_derived_from(class_sv, classname ) ) {
                if(SvROK(class_sv) && SvOBJECT(SvRV(class_sv))) {
                    classname = sv_reftype(SvRV(class_sv), TRUE);
                } else {
                    classname = SvPV_nolen(class_sv);
                }
            }

            sv_setsv(\$arg, sv_2mortal(newRV_noinc((SV*)hv)));
            (void)sv_bless(\$arg, gv_stashpv(classname, TRUE));
            mg = sv_magicext((SV*)hv, NULL, PERL_MAGIC_ext, &${c_type}_vtbl, (char*) \$var, 0);
            mg->mg_flags |= MGf_DUP;
        }
EOM
    }

    print $out
        "# Do NOT edit this file! This file was automatically generated\n",
        "# by Makefile.PL on @{[scalar localtime]}. If you want to\n",
        "# regenerate it, remove this file and re-run Makefile.PL\n",
        "\n"
    ;
    print $out join( "\n",
        "TYPEMAP\n",
        join("\n", @decl), 
        "\n",
        "INPUT\n",
        join("\n", @input),
        "\n",
        "OUTPUT\n",
        join("\n", @output),
        "\n",
    );

    close $out;
}