package Net::SSLLabs::Simulation;

use strict;
use warnings;
use Net::SSLLabs::SimClient();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    $self->{client} = Net::SSLLabs::SimClient->new( $self->{client} );
    return $self;
}

sub client {
    my ($self) = @_;
    return $self->{client};
}

sub error_code {
    my ($self) = @_;
    return $self->{errorCode};
}

sub attempts {
    my ($self) = @_;
    return $self->{attempts};
}

sub protocol_id {
    my ($self) = @_;
    return $self->{protocolId};
}

sub suite_id {
    my ($self) = @_;
    return $self->{suiteId};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Simulation - Simulation object

=head1 METHODS

=head2 new

a new C<Net::SSLLabs::Simulation> object, accepts a JSON object as it's parameter.

=head2 client

instance of L<Net::SSLLabs::SimClient|Net::SSLLabs::SimClient>.

=head2 error_code

zero if handshake was successful, 1 if it was not.

=head2 attempts

always 1 with the current implementation.

=head2 protocol_id

Negotiated protocol ID.

=head2 suite_id

Negotiated suite ID.

