package Net::SSLLabs::Protocol;

use strict;
use warnings;

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    return $self;
}

sub id {
    my ($self) = @_;
    return $self->{id};
}

sub name {
    my ($self) = @_;
    return $self->{name};
}

sub version {
    my ($self) = @_;
    return $self->{version};
}

sub v2_suites_disabled {
    my ($self) = @_;
    return $self->{v2SuitesDisabled};
}

sub q {
    my ($self) = @_;
    return $self->{q};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Protocol - Protocol object

=head1 METHODS

=head2 new

a new C<Net::SSLLabs::Protocol> object, accepts a JSON object as it's parameter.

=head2 id

protocol version number, e.g. 0x0303 for TLS 1.2

=head2 name

protocol name, i.e. SSL or TLS.

=head2 version

protocol version, e.g. 1.2 (for TLS)

=head2 v2_suites_disabled

some servers have SSLv2 protocol enabled, but with all SSLv2 cipher suites disabled. In that case, this field is set to true.

=head2 q

0 if the protocol is insecure, null otherwise
