package Net::SSLLabs::Key;

use strict;
use warnings;

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    return $self;
}

sub strength {
    my ($self) = @_;
    return $self->{strength};
}

sub debian_flaw {
    my ($self) = @_;
    return $self->{debianFlaw} ? 1 : 0;
}

sub alg {
    my ($self) = @_;
    return $self->{alg};
}

sub size {
    my ($self) = @_;
    return $self->{size};
}

sub q {
    my ($self) = @_;
    return $self->{q};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Key - Key object

=head1 METHODS

=head2 new

a new C<Net::SSLLabs::Key> object, accepts a JSON object as it's parameter.

=head2 size

key size, e.g., 1024 or 2048 for RSA and DSA, or 256 bits for EC.

=head2 strength

key size expressed in RSA bits.

=head2 alg

key algorithm; possible values: RSA, DSA, and EC.

=head2 debian_flaw

true if we suspect that the key was generated using a weak random number generator (detected via a blacklist database)

=head2 q

0 if key is insecure, null otherwise

