# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::MN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210309172132;

my $formatters = [
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[12]1',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[57-9]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[12]2[1-3]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [12](?:
              27|
              3[2-8]|
              4[2-68]|
              5[1-4689]
            )[0-3]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          [12]2[1-3]\\d{5,6}|
          7(?:
            0[0-5]\\d|
            128
          )\\d{4}|
          (?:
            [12](?:
              1|
              27
            )|
            5[368]
          )\\d{6}|
          [12](?:
            3[2-8]|
            4[2-68]|
            5[1-4689]
          )\\d{6,7}
        ',
                'geographic' => '
          [12]2[1-3]\\d{5,6}|
          7(?:
            0[0-5]\\d|
            128
          )\\d{4}|
          (?:
            [12](?:
              1|
              27
            )|
            5[368]
          )\\d{6}|
          [12](?:
            3[2-8]|
            4[2-68]|
            5[1-4689]
          )\\d{6,7}
        ',
                'mobile' => '
          (?:
            83[01]|
            920
          )\\d{5}|
          (?:
            5[05]|
            8[05689]|
            9[013-9]
          )\\d{6}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '',
                'toll_free' => '',
                'voip' => '
          712[0-79]\\d{4}|
          7(?:
            1[013-9]|
            [5-8]\\d
          )\\d{5}
        '
              };
my %areanames = ();
$areanames{en} = {"97613452", "Selenge\,\ Bulgan",
"97624444", "Bayanlig\,\ Bayankhongor",
"97623855", "Ulaan\-Uul\,\ Khuvsgul",
"97623743", "Sharingol\,\ Darkhan\-Uul",
"97624851", "Tugrug\,\ Govi\-Altai",
"97615442", "Shivee\-Govi\,\ Govisumber",
"97623247", "Guchin\-Us\,\ Uvurkhangai",
"97622742", "Argalant\,\ Tuv",
"97614248", "Nogoonnnuur\,\ Bayan\-Ulgii",
"97625845", "Gurvanzagal\,\ Dornod",
"97615947", "Deren\,\ Dundgovi",
"97612745", "Bayan\,\ Tuv",
"97625346", "Manlai\,\ Umnugovi",
"97624451", "Buutsagaan\,\ Bayankhongor",
"97625657", "Tsenkhermandal\,\ Khentii",
"97615842", "Bayantumen\,\ Dornod",
"97623455", "Khishig\-Undur\,\ Bulgan",
"97624844", "Bugant\,\ Govi\-Altai",
"97614648", "Ider\,\ Zavkhan",
"97623356", "Tsenkher\,\ Arkhangai",
"97613852", "Tosontsengel\,\ Khuvsgul",
"97623647", "Mandal\,\ Selenge",
"97615944", "Gurvansaikhan\,\ Dundgovi",
"97625241", "Airag\,\ Dornogovi",
"97625654", "Murun\,\ Khentii",
"97613848", "Rashaant\,\ Khuvsgul",
"97624847", "Jargalan\,\ Govi\-Altai",
"97614652", "Otgon\,\ Zavkhan",
"97623251", "Naariinteel\,\ Uvurkhangai",
"97623644", "Yereu\,\ Selenge",
"97625254", "Erdene\,\ Dornogovi",
"97624655", "Tudevtei\,\ Zavkhan",
"97615951", "Undurshil\,\ Dundgovi",
"97613448", "Orkhon\,\ Bulgan",
"97625641", "Batnorov\,\ Khentii",
"97623353", "Khashaat\,\ Arkhangai",
"97624447", "Bayantsagaan\,\ Bayankhongor",
"97623244", "Bayan\-Undur\,\ Uvurkhangai",
"97624559", "Tsagaankhairkhan\,\ Uvs",
"976122", "Bagakhangai",
"97622758", "Zaamar\,\ Tuv",
"97614252", "Ulaankhus\,\ Bayan\-Ulgii",
"97623651", "Saikhan\,\ Selenge",
"97625343", "Bulgan\,\ Umnugovi",
"97624649", "Ikh\-Uul\,\ Zavkhan",
"9761462", "Uliastal\ city\,\ Zavkhan",
"97625653", "Jargaltkhaan\,\ Khentii",
"97623341", "Battsengel\,\ Arkhangai",
"97623541", "Jargalant\,\ Orkhon",
"97615943", "Govi\-Ugtaal\,\ Dundgovi",
"97615145", "Naran\,\ Sukhbaatar",
"97624545", "Zuungovi\,\ Uvs",
"97624446", "Bayan\-Undur\,\ Bayankhongor",
"97625351", "Khanbogd\,\ Umnugovi",
"97623643", "Bayangol\,\ Selenge",
"97624345", "Durgun\,\ Khovd",
"97625142", "Bayandelger\,\ Sukhbaatar",
"97614542", "Bukhmurun\,\ Uvs",
"97623354", "Khotont\,\ Arkhangai",
"97624846", "Delger\,\ Govi\-Altai",
"9761422", "Ulgii\,\ Bayan\-Ulgii",
"97624249", "Sagsai\,\ Bayan\-Ulgii",
"97614342", "Bulgan\,\ Khovd",
"97625253", "Huvsgul\,\ Dornogovi",
"97625344", "Gurvan\ tes\,\ Umnugovi",
"97623243", "Bayangol\,\ Uvurkhangai",
"97612759", "Lun\,\ Tuv",
"97623646", "Zuunburen\,\ Selenge",
"97623357", "Tsetserleg\,\ Arkhangai",
"97624443", "Bayangovi\,\ Bayankhongor",
"97614558", "Khyargas\,\ Uvs",
"97623449", "Rashaant\,\ Bulgan",
"9761342", "Bulgan\ city\,\ Bulgan",
"97625656", "Umnudelger\,\ Khentii",
"97625347", "Noyon\,\ Umnugovi",
"97612765", "Ugtaal\,\ Tuv",
"97615946", "Delgertsogt\,\ Dundgovi",
"97622762", "Undurshereet\,\ Tuv",
"97623849", "Renchinlkhumbe\,\ Khuvsgul",
"9761382", "Murun\ city\,\ Khuvsgul",
"97623246", "Burd\,\ Uvurkhangai",
"97624843", "Biger\,\ Govi\-Altai",
"97615854", "Chuluunkhoroot\,\ Dornod",
"97615948", "Luus\,\ Dundgovi",
"97613451", "Saikhan\,\ Bulgan",
"97614556", "Tes\,\ Uvs",
"97613844", "Burentogtokh\,\ Khuvsgul",
"97614455", "Jinst\,\ Bayankhongor",
"97614647", "Zavkhanmandal\,\ Zavkhan",
"97624852", "Khaluun\,\ Govi\-Altai",
"97615441", "Bayantal\,\ Govisumber",
"97614356", "Chandmani\,\ Khovd",
"97623648", "Orkhon\,\ Selenge",
"97622741", "Altaanbulag\,\ Tuv",
"97613863", "Chaandmani\-Undur\,\ Khuvsgul",
"97615841", "Bayandun\,\ Dornod",
"97624452", "Galuut\,\ Bayankhongor",
"97614855", "Tseel\,\ Govi\-Altai",
"97613444", "Buregkhangai\,\ Bulgan",
"97623248", "Zuil\,\ Uvurkhangai",
"97614247", "Deluun\,\ Bayan\-Ulgii",
"97613851", "Tarialan\,\ Khuvsgul",
"97622754", "Bornuur\,\ Tuv",
"9762372", "Darkhan\ city\,\ Darkhan\-Uul",
"97625153", "Erdenetsagaan\,\ Sukhbaatar",
"97614553", "Sagili\,\ Uvs",
"97613655", "Hushaat\,\ Selenge",
"97613447", "Mogod\,\ Bulgan",
"97614353", "Uench\,\ Khovd",
"97624448", "Bogd\,\ Bayankhongor",
"9762532", "Dalanzadgad\,\ Umnugovi",
"97614663", "Shiluustei\,\ Zavkhan",
"97625242", "Altanshiree\,\ Dornogovi",
"97615349", "Savrai\,\ Umnugovi",
"97615645", "Bayan\-Ovoo\,\ Khentii",
"97614244", "Bugat\,\ Bayan\-Ulgii",
"97614651", "Numrug\,\ Zavkhan",
"97621", "Ulaanbaatar",
"97622757", "Jargalant\,\ Tuv",
"97625955", "Erdenedalai\,\ Dundgovi",
"97623252", "Ulziit\,\ Uvurkhangai",
"97613359", "Erdenemandal\,\ Arkhangai",
"97625642", "Batshireet\,\ Khentii",
"97615952", "Saikhan\-Ovoo\,\ Dundgovi",
"97613255", "Tugrug\,\ Uvurkhangai",
"97614251", "Tolbo\,\ Bayan\-Ulgii",
"97613847", "Ikh\-Uul\,\ Khuvsgul",
"97623652", "Sant\,\ Selenge",
"97624848", "Taishir\,\ Govi\-Altai",
"97614644", "Bayankhairkhan\,\ Zavkhan",
"97615245", "Zamiin\-Uud\,\ Dornogovi",
"97614664", "Erdenekhaijkhan\,\ Zavkhan",
"97614354", "Khovd\,\ Khovd",
"97613249", "Zuunbayan\-Ulaan\,\ Uvurkhangai",
"97623342", "Bulgan\,\ Arkhangai",
"9762322", "Arvaikheer\ city\,\ Uvurkhangai",
"97613846", "Jargalant\,\ Khuvsgul",
"97614554", "Tarialan\,\ Uvs",
"97614243", "Bayannuur\,\ Bayan\-Ulgii",
"976121", "Baganuur",
"97625352", "Khankhongor\,\ Umnugovi",
"97614341", "Altai\,\ Khovd",
"9762362", "Sukhbaatar\ city\,\ Selenge",
"97613649", "Orkhontuul\,\ Selenge",
"97622756", "Delgerkhaan\,\ Tuv",
"97614541", "Baruunturuun\,\ Uvs",
"97625141", "Asgat\,\ Sukhbaatar",
"97615355", "Tsogttsetsii\,\ Umnugovi",
"97614643", "Bayantest\,\ Zavkhan",
"97613446", "Dashinchilen\,\ Bulgan",
"97613345", "Ugii\-Nuur\,\ Arkhangai",
"9761592", "Mandalgovi\ city\,\ Dundgovi",
"97625949", "Ulziit\,\ Dundgovi",
"97614246", "Buyant\,\ Bayan\-Ulgii",
"9762482", "Altai\ city\,\ Govi\-Altai",
"97614849", "Tonkhil\,\ Govi\-Altai",
"97615853", "Choibalsan\,\ Dornod",
"97613843", "Bayanzurkh\,\ Khuvsgul",
"97622761", "Mungunmorit\,\ Tuv",
"97614357", "Erdeneburen\,\ Khovd",
"97613443", "Bugat\,\ Bulgan",
"97623358", "Chuluut\,\ Arkhangai",
"97614646", "Durvuljin\,\ Zavkhan",
"97614557", "Khovd\,\ Uvs",
"97613864", "Shine\-Ider\,\ Khuvsgul",
"97625348", "Nomgon\,\ Umnugovi",
"9762442", "Bayankhongor\ city\,\ Bayankhongor",
"97622753", "Bayanchandmani\,\ Tuv",
"97614449", "Bumbugur\,\ Bayankhongor",
"97623864", "Shine\-Ider\,\ Khuvsgul",
"97624557", "Khovd\,\ Uvs",
"97613358", "Chuluut\,\ Arkhangai",
"97624646", "Durvuljin\,\ Zavkhan",
"97624357", "Erdeneburen\,\ Khovd",
"97612761", "Mungunmorit\,\ Tuv",
"97623443", "Bugat\,\ Bulgan",
"97624449", "Bumbugur\,\ Bayankhongor",
"9761442", "Bayankhongor\ city\,\ Bayankhongor",
"97612753", "Bayanchandmani\,\ Tuv",
"97615348", "Nomgon\,\ Umnugovi",
"97625853", "Choibalsan\,\ Dornod",
"97624849", "Tonkhil\,\ Govi\-Altai",
"97624246", "Buyant\,\ Bayan\-Ulgii",
"9761482", "Altai\ city\,\ Govi\-Altai",
"97623843", "Bayanzurkh\,\ Khuvsgul",
"97625355", "Tsogt\-Tsetsii\,\ Umnugovi",
"97615141", "Asgat\,\ Sukhbaatar",
"97624541", "Baruunturuun\,\ Uvs",
"97623649", "Orkhontuul\,\ Selenge",
"97612756", "Delgerkhaan\,\ Tuv",
"9761362", "Sukhbaatar\ city\,\ Selenge",
"97624341", "Altai\,\ Khovd",
"97615949", "Ulziit\,\ Dundgovi",
"97623345", "Ugii\-Nuur\,\ Arkhangai",
"9762592", "Mandalgovi\ city\,\ Dundgovi",
"97623446", "Dashinchilen\,\ Bulgan",
"97624643", "Bayantest\,\ Zavkhan",
"97624554", "Tarialan\,\ Uvs",
"97623846", "Jargalant\,\ Khuvsgul",
"9761322", "Arvaikheer\ city\,\ Uvurkhangai",
"97623249", "Zuunbayan\-Ulaan\,\ Uvurkhangai",
"97613342", "Bulgan\,\ Arkhangai",
"97624354", "Khovd\,\ Khovd",
"97624664", "Erdenekhaijkhan\,\ Zavkhan",
"97615352", "Khankhongor\,\ Umnugovi",
"97624243", "Bayannuur\,\ Bayan\-Ulgii",
"976221", "Baganuur",
"97623255", "Tugrug\,\ Uvurkhangai",
"97625952", "Saikhan\-Ovoo\,\ Dundgovi",
"97615642", "Batshireet\,\ Khentii",
"97625245", "Zamiin\-Uud\,\ Dornogovi",
"97624644", "Bayankhairkhan\,\ Zavkhan",
"97614848", "Taishir\,\ Govi\-Altai",
"97623847", "Ikh\-Uul\,\ Khuvsgul",
"97613652", "Sant\,\ Selenge",
"97624251", "Tolbo\,\ Bayan\-Ulgii",
"97615242", "Altanshiree\,\ Dornogovi",
"97625349", "Savrai\,\ Umnugovi",
"9761532", "Dalanzadgad\,\ Umnugovi",
"97624663", "Shiluustei\,\ Zavkhan",
"97614448", "Bogd\,\ Bayankhongor",
"97624353", "Uench\,\ Khovd",
"97623447", "Mogod\,\ Bulgan",
"97623655", "Hushaat\,\ Selenge",
"97615153", "Erdenetsagaan\,\ Sukhbaatar",
"97624553", "Sagili\,\ Uvs",
"97613252", "Ulziit\,\ Uvurkhangai",
"97623359", "Erdenemandal\,\ Arkhangai",
"97615955", "Erdenedalai\,\ Dundgovi",
"97612757", "Jargalant\,\ Tuv",
"97611", "Ulaanbaatar",
"97624651", "Numrug\,\ Zavkhan",
"97624244", "Bugat\,\ Bayan\-Ulgii",
"97625645", "Bayan\-Ovoo\,\ Khentii",
"97623444", "Buregkhangai\,\ Bulgan",
"97624855", "Tseel\,\ Govi\-Altai",
"97625841", "Bayandun\,\ Dornod",
"97614452", "Galuut\,\ Bayankhongor",
"97623863", "Chaandmani\-Undur\,\ Khuvsgul",
"9761372", "Darkhan\ city\,\ Darkhan\-Uul",
"97612754", "Bornuur\,\ Tuv",
"97623851", "Tarialan\,\ Khuvsgul",
"97624247", "Deluun\,\ Bayan\-Ulgii",
"97613248", "Zuil\,\ Uvurkhangai",
"97623451", "Saikhan\,\ Bulgan",
"97625948", "Luus\,\ Dundgovi",
"97625854", "Chuluunkhoroot\,\ Dornod",
"97612741", "Altaanbulag\,\ Tuv",
"97613648", "Orkhon\,\ Selenge",
"97624356", "Chandmani\,\ Khovd",
"97614852", "Khaluun\,\ Govi\-Altai",
"97625441", "Bayantal\,\ Govisumber",
"97624647", "Zavkhanmandal\,\ Zavkhan",
"97624455", "Jinst\,\ Bayankhongor",
"97624556", "Tes\,\ Uvs",
"97623844", "Burentogtokh\,\ Khuvsgul",
"97613246", "Burd\,\ Uvurkhangai",
"9762382", "Murun\ city\,\ Khuvsgul",
"97613849", "Renchinlkhumbe\,\ Khuvsgul",
"97612762", "Undurshereet\,\ Tuv",
"97614843", "Biger\,\ Govi\-Altai",
"97624558", "Khyargas\,\ Uvs",
"97613357", "Tsetserleg\,\ Arkhangai",
"97614443", "Bayangovi\,\ Bayankhongor",
"97613646", "Zuunburen\,\ Selenge",
"97622759", "Lun\,\ Tuv",
"97625946", "Delgertsogt\,\ Dundgovi",
"97622765", "Ugtaal\,\ Tuv",
"97615347", "Noyon\,\ Umnugovi",
"97615656", "Umnudelger\,\ Khentii",
"9762342", "Bulgan\ city\,\ Bulgan",
"97613449", "Rashaant\,\ Bulgan",
"97615253", "Huvsgul\,\ Dornogovi",
"97614249", "Sagsai\,\ Bayan\-Ulgii",
"97624342", "Bulgan\,\ Khovd",
"97614846", "Delger\,\ Govi\-Altai",
"9762422", "Ulgii\,\ Bayan\-Ulgii",
"97613354", "Khotont\,\ Arkhangai",
"97624542", "Bukhmurun\,\ Uvs",
"97615142", "Bayandelger\,\ Sukhbaatar",
"97613243", "Bayangol\,\ Uvurkhangai",
"97615344", "Gurvan\ tes\,\ Umnugovi",
"97625943", "Govi\-Ugtaal\,\ Dundgovi",
"97613541", "Jargalant\,\ Orkhon",
"97615653", "Jargaltkhaan\,\ Khentii",
"97613341", "Battsengel\,\ Arkhangai",
"9762462", "Uliastal\ city\,\ Zavkhan",
"97614649", "Ikh\-Uul\,\ Zavkhan",
"97614345", "Durgun\,\ Khovd",
"97613643", "Bayangol\,\ Selenge",
"97615351", "Khanbogd\,\ Umnugovi",
"97614446", "Bayan\-Undur\,\ Bayankhongor",
"97614545", "Zuungovi\,\ Uvs",
"97625145", "Naran\,\ Sukhbaatar",
"97614447", "Bayantsagaan\,\ Bayankhongor",
"97613353", "Khashaat\,\ Arkhangai",
"97615641", "Batnorov\,\ Khentii",
"97623448", "Orkhon\,\ Bulgan",
"97625951", "Undurshil\,\ Dundgovi",
"97614655", "Tudevtei\,\ Zavkhan",
"97615254", "Erdene\,\ Dornogovi",
"97615343", "Bulgan\,\ Umnugovi",
"97613651", "Saikhan\,\ Selenge",
"97612758", "Zaamar\,\ Tuv",
"97624252", "Ulaankhus\,\ Bayan\-Ulgii",
"976222", "Bagakhangai",
"97614559", "Tsagaankhairkhan\,\ Uvs",
"97613244", "Bayan\-Undur\,\ Uvurkhangai",
"97615654", "Murun\,\ Khentii",
"97615241", "Airag\,\ Dornogovi",
"97625944", "Gurvansaikhan\,\ Dundgovi",
"97613644", "Yereu\,\ Selenge",
"97613251", "Naariinteel\,\ Uvurkhangai",
"97624652", "Otgon\,\ Zavkhan",
"97614847", "Jargalan\,\ Govi\-Altai",
"97623848", "Rashaant\,\ Khuvsgul",
"97625842", "Bayantumen\,\ Dornod",
"97614451", "Buutsagaan\,\ Bayankhongor",
"97615657", "Tsenkhermandal\,\ Khentii",
"97615346", "Manlai\,\ Umnugovi",
"97625947", "Deren\,\ Dundgovi",
"97622745", "Bayan\,\ Tuv",
"97613647", "Mandal\,\ Selenge",
"97623852", "Tosontsengel\,\ Khuvsgul",
"97613356", "Tsenkher\,\ Arkhangai",
"97624648", "Ider\,\ Zavkhan",
"97614844", "Bugant\,\ Govi\-Altai",
"97613455", "Khishig\-Undur\,\ Bulgan",
"97613743", "Sharingol\,\ Darkhan\-Uul",
"97613855", "Ulaan\-Uul\,\ Khuvsgul",
"97614444", "Bayanlig\,\ Bayankhongor",
"97623452", "Selenge\,\ Bulgan",
"97615845", "Gurvanzagal\,\ Dornod",
"97624248", "Nogoonnnuur\,\ Bayan\-Ulgii",
"97612742", "Argalant\,\ Tuv",
"97613247", "Guchin\-Us\,\ Uvurkhangai",
"97614851", "Tugrug\,\ Govi\-Altai",
"97625442", "Shivee\-Govi\,\ Govisumber",
"97623253", "Sant\,\ Uvurkhangai",
"97625354", "Tsogt\-Ovoo\,\ Umnugovi",
"97624856", "Chandmani\,\ Govi\-Altai",
"97614352", "Myangad\,\ Khovd",
"97625243", "Dalanjargalan\,\ Dornogovi",
"97614662", "Tsetsen\-Uul\,\ Zavkhan",
"97625152", "Halzan\,\ Sukhbaatar",
"97614552", "Undurkhangai\,\ Uvs",
"97623344", "Ikh\-Tamir\,\ Arkhangai",
"976123", "Nalaikh",
"97624355", "Tsetseg\,\ Khovd",
"97624665", "Yaruu\,\ Zavkhan",
"97624555", "Turgen\,\ Uvs",
"97624456", "Zag\,\ Bayankhongor",
"97623653", "Tushig\,\ Selenge",
"97625341", "Bayandalai\,\ Umnugovi",
"97615953", "Khuld\,\ Dundgovi",
"97624659", "Tsegeenkhairkhan\,\ Zavkhan",
"97622768", "Erdenesant\,\ Tuv",
"97625643", "Bayan\-Adarga\,\ Khentii",
"97623351", "Khairkhan\,\ Arkhangai",
"97624853", "Khukhmorit\,\ Govi\-Altai",
"97625849", "Khalkhgol\,\ Dornod",
"97625246", "Ikh\-Khet\,\ Dornogovi",
"9761582", "Choibalsan\ city\,\ Dornod",
"97623865", "Erdenebulgan\,\ Khuvsgul",
"97623859", "Tsagaan\-Uul\,\ Khuvsgul",
"97623256", "Uyanga\,\ Uvurkhangai",
"97623741", "Orkhon\,\ Darkhan\-Uul",
"97624461", "Erdenetsogt\,\ Bayankhongor",
"97625646", "Bayankhutagt\,\ Khentii",
"97614548", "Naranbulag\,\ Uvs",
"97625148", "Tuvshin\-Shiree\,\ Sukhbaatar",
"9761542", "Choir\,\ Govisumber",
"97613862", "Tsetserleg\,\ Khuvsgul",
"97614348", "Mankhan\,\ Khovd",
"97623656", "Tsagaannuur\,\ Selenge",
"97612749", "Bayankhangai\,\ Tuv",
"97624453", "Gurvanbulag\,\ Bayankhongor",
"9762272", "Zuunmod\ city\,\ Tuv",
"97623347", "Undur\-Ulaan\,\ Arkhangai",
"97614658", "Urgamal\,\ Zavkhan",
"97623346", "Ulziit\,\ Arkhangai",
"97613842", "Arbulag\,\ Khuvsgul",
"97623657", "Shaamar\,\ Selenge",
"97623445", "Gurvanbulag\,\ Bulgan",
"97624854", "Tsogt\,\ Govi\-Altai",
"97624441", "Baatsagaan\,\ Bayankhongor",
"97625647", "Binder\,\ Khentii",
"97615852", "Tsagaan\-Ovoo\,\ Dornod",
"97612755", "Buren\,\ Tuv",
"97624841", "Altai\,\ Govi\-Altai",
"97623257", "Hairkhandulaan\,\ Uvurkhangai",
"97622752", "Bayantsogt\,\ Tuv",
"97624454", "Jargalant\,\ Bayankhongor",
"97623845", "Galt\,\ Khuvsgul",
"97613442", "Bayannuur\,\ Bulgan",
"97625247", "Mandakh\,\ Dornogovi",
"97624349", "Munkhkhairkhan\,\ Khovd",
"97622748", "Bayan\-Unjuul\,\ Tuv",
"97614242", "Altantsugts\,\ Bayan\-Ulgii",
"9761432", "Khovd\ city\,\ Khovd",
"97625353", "Khurmen\,\ Umnugovi",
"97623641", "Altanbulag\,\ Selenge",
"9762512", "Baruun\-Urt\ city\,\ Sukhbaatar",
"9761452", "Ulaangom\ city\,\ Uvs",
"97623254", "Taragt\,\ Uvurkhangai",
"97615149", "Tumentsogt\,\ Sukhbaatar",
"97624549", "Ulgii\,\ Uvs",
"97624457", "Ulziit\,\ Bayankhongor",
"97625651", "Darkhan\,\ Khentii",
"97623343", "Jargalant\,\ Arkhangai",
"97625244", "Delgerekh\,\ Dornogovi",
"97624645", "Bulnai\,\ Zavkhan",
"97615941", "Adaatsag\,\ Dundgovi",
"97623654", "Khuder\,\ Selenge",
"97613858", "Tsagaannuur\,\ Khuvsgul",
"97624857", "Sharga\,\ Govi\-Altai",
"97614642", "Asgat\,\ Zavkhan",
"97623241", "Baruun\ Bayan\-Ulaan\,\ Uvurkhangai",
"97624245", "Bulgan\,\ Bayan\-Ulgii",
"97625644", "Bayanmunkh\,\ Khentii",
"97615848", "Sereglen\,\ Dornod",
"97615954", "Tsagaandelger\,\ Dundgovi",
"97625251", "Ulaanbadrakh\,\ Dornogovi",
"97613355", "Tsakhirt\,\ Arkhangai",
"97614653", "Santmargad\,\ Zavkhan",
"97613456", "Khutag\-Undur\,\ Bulgan",
"9762562", "Undurkhaan\ city\,\ Khentii",
"97615649", "Dadal\,\ Khentii",
"97625151", "Uulbayan\,\ Sukhbaatar",
"97614551", "Umnugovi\,\ Uvs",
"97615345", "Mandal\-Ovoo\,\ Umnugovi",
"97622767", "Erdene\,\ Tuv",
"97614351", "Must\,\ Khovd",
"97614661", "Tsagaanchuluut\,\ Zavkhan",
"97622746", "Bayandelger\,\ Tuv",
"97614253", "Tsengel\,\ Bayan\-Ulgii",
"97615249", "Saikhandulaan\,\ Dornogovi",
"97625342", "Bayan\-Ovoo\,\ Umnugovi",
"9762522", "Sainshand\ city\,\ Dornogovi",
"97615846", "Dashbalbar\,\ Dornod",
"97613259", "Khujirt\,\ Uvurkhangai",
"97623352", "Khahgai\,\ Arkhangai",
"97613856", "Khankh\,\ Khuvsgul",
"97625144", "Munkhkhaan\,\ Sukhbaatar",
"97614544", "Zavkhan\,\ Uvs",
"97614344", "Darvi\,\ Khovd",
"97622743", "Arhust\,\ Tuv",
"97614459", "Shjnejinst\,\ Bayankhongor",
"97614547", "Malchin\,\ Uvs",
"97625147", "Sukhbaatar\,\ Sukhbaatar",
"97623742", "Khongor\,\ Darkhan\-Uul",
"97614347", "Zereg\,\ Khovd",
"97613453", "Teshig\,\ Bulgan",
"97614656", "Telmen\,\ Zavkhan",
"97623348", "Tariat\,\ Arkhangai",
"97613853", "Tumurbulag\,\ Khuvsgul",
"97613861", "Tsagaan\-Uur\,\ Khuvsgul",
"97615843", "Bayan\-Uul\,\ Dornod",
"97622764", "Sergelen\,\ Tuv",
"97622744", "Batsumber\,\ Tuv",
"97623258", "Kharkhorin\,\ Uvurkhangai",
"97613841", "Alag\-Erdene\,\ Khuvsgul",
"97614845", "Darvi\,\ Govi\-Altai",
"97613454", "Khangal\,\ Bulgan",
"97625248", "Urgun\,\ Dornogovi",
"97624442", "Bayanbulag\,\ Bayankhongor",
"97615851", "Khulunbuyir\,\ Dornod",
"97614657", "Tes\,\ Zavkhan",
"97624842", "Bayan\-Uul\,\ Govi\-Altai",
"97614346", "Duut\,\ Khovd",
"97622751", "Bayantsagaan\,\ Tuv",
"97625146", "Ongon\,\ Sukhbaatar",
"97614546", "Zuunkhangai\,\ Uvs",
"97613854", "Tunel\,\ Khuvsgul",
"97614445", "Bayan\-Ovoo\,\ Bayankhongor",
"97622763", "Sumber\,\ Tuv",
"97613441", "Bayanagt\,\ Bulgan",
"97625648", "Galshir\,\ Khentii",
"97615844", "Bulgan\,\ Dornod",
"97614654", "Songino\,\ Zavkhan",
"97614241", "Altai\,\ Bayan\-Ulgii",
"97623642", "Baruunburen\,\ Selenge",
"97613857", "Khatgal\,\ Khuvsgul",
"97624858", "Erdene\,\ Govi\-Altai",
"97615942", "Bayanjargalan\,\ Dundgovi",
"97613245", "Bogd\,\ Uvurkhangai",
"97625652", "Delgerkhaan\,\ Khentii",
"97615847", "Matad\,\ Dornod",
"97614641", "Aldarkhaan\,\ Zavkhan",
"97622766", "Tseel\,\ Tuv",
"9762332", "Tsetserleg\ city\,\ Arkhangai",
"97625945", "Delgerkhangai\,\ Dundgovi",
"97622747", "Bayanjargal\,\ Tuv",
"97613349", "Tuvshruulekh\,\ Arkhangai",
"97623242", "Batulzii\,\ Uvurkhangai",
"97615655", "Norovlin\,\ Khentii",
"9762352", "Erdenet\ city\,\ Orkhon",
"97614343", "Buyant\,\ Khovd",
"97624458", "Khureemaral\,\ Bayankhongor",
"97625252", "Khatanbulag\,\ Dornogovi",
"97625143", "Dariganga\,\ Sukhbaatar",
"97614543", "Davst\,\ Uvs",
"97613645", "Javkhlant\,\ Selenge",
"9761352", "Erdenet\ city\,\ Orkhon",
"97625655", "Norovlin\,\ Khentii",
"97623349", "Tuvshruulekh\,\ Arkhangai",
"97613242", "Bat\-Ulzii\,\ Uvurkhangai",
"97615945", "Delgerkhangai\,\ Dundgovi",
"9761332", "Tsetserleg\ city\,\ Arkhangai",
"97612747", "Bayanjargal\,\ Tuv",
"97612766", "Tseel\,\ Tuv",
"97624641", "Aldarkhaan\,\ Zavkhan",
"97623645", "Javkhlant\,\ Selenge",
"97624543", "Davst\,\ Uvs",
"97615143", "Dariganga\,\ Sukhbaatar",
"97615252", "Khatanbulag\,\ Dornogovi",
"97614458", "Khureemaral\,\ Bayankhongor",
"97624343", "Buyant\,\ Khovd",
"97614858", "Erdene\,\ Govi\-Altai",
"97623857", "Khatgal\,\ Khuvsgul",
"97613642", "Baruunburen\,\ Selenge",
"97624241", "Altai\,\ Bayan\-Ulgii",
"97624654", "Songino\,\ Zavkhan",
"97615652", "Delgerkhaan\,\ Khentii",
"97625847", "Matad\,\ Dornod",
"97623245", "Bogd\,\ Uvurkhangai",
"97625942", "Bayanjargalan\,\ Dundgovi",
"97624445", "Bayan\-Ovoo\,\ Bayankhongor",
"97623854", "Tunel\,\ Khuvsgul",
"97624546", "Zuunkhangai\,\ Uvs",
"97615146", "Ongon\,\ Sukhbaatar",
"97612751", "Bayantsagaan\,\ Tuv",
"97624346", "Duut\,\ Khovd",
"97614842", "Bayan\-Uul\,\ Govi\-Altai",
"97624657", "Tes\,\ Zavkhan",
"97625844", "Bulgan\,\ Dornod",
"97615648", "Galshir\,\ Khentii",
"97612763", "Sumber\,\ Tuv",
"97623441", "Bayanagt\,\ Bulgan",
"97623841", "Alag\-Erdene\,\ Khuvsgul",
"97613258", "Kharkhorin\,\ Uvurkhangai",
"97612744", "Batsumber\,\ Tuv",
"97614442", "Bayanbulag\,\ Bayankhongor",
"97625851", "Khulunbuyir\,\ Dornod",
"97615248", "Urgun\,\ Dornogovi",
"97623454", "Khangal\,\ Bulgan",
"97624845", "Darvi\,\ Govi\-Altai",
"97623853", "Tumurbulag\,\ Khuvsgul",
"97612764", "Sergelen\,\ Tuv",
"97625843", "Bayan\-Uul\,\ Dornod",
"97623861", "Tsagaan\-Uur\,\ Khuvsgul",
"97624459", "Shjnejinst\,\ Bayankhongor",
"97612743", "Arhust\,\ Tuv",
"97624656", "Telmen\,\ Zavkhan",
"97613348", "Tariat\,\ Arkhangai",
"97624347", "Zereg\,\ Khovd",
"97623453", "Teshig\,\ Bulgan",
"97613742", "Khongor\,\ Darkhan\-Uul",
"97624547", "Malchin\,\ Uvs",
"97615147", "Sukhbaatar\,\ Sukhbaatar",
"9761522", "Sainshand\ city\,\ Dornogovi",
"97625846", "Dashbalbar\,\ Dornod",
"97625249", "Saikhandulaan\,\ Dornogovi",
"97615342", "Bayan\-Ovoo\,\ Umnugovi",
"97624253", "Tsengel\,\ Bayan\-Ulgii",
"97624344", "Darvi\,\ Khovd",
"97615144", "Munkhkhaan\,\ Sukhbaatar",
"97624544", "Zavkhan\,\ Uvs",
"97623856", "Khankh\,\ Khuvsgul",
"97623259", "Khujirt\,\ Uvurkhangai",
"97613352", "Khahgai\,\ Arkhangai",
"97625649", "Dadal\,\ Khentii",
"9761562", "Undurkhaan\ city\,\ Khentii",
"97623456", "Khutag\-Undur\,\ Bulgan",
"97624653", "Santmargad\,\ Zavkhan",
"97623355", "Tsakhirt\,\ Arkhangai",
"97612746", "Bayandelger\,\ Tuv",
"97624661", "Tsagaanchuluut\,\ Zavkhan",
"97612767", "Erdene\,\ Tuv",
"97624351", "Must\,\ Khovd",
"97625345", "Mandal\-Ovoo\,\ Umnugovi",
"97624551", "Umnugovi\,\ Uvs",
"97615151", "Uulbayan\,\ Sukhbaatar",
"97613241", "Baruun\ Bayan\-Ulaan\,\ Uvurkhangai",
"97624642", "Asgat\,\ Zavkhan",
"97614857", "Sharga\,\ Govi\-Altai",
"97623858", "Tsagaannuur\,\ Khuvsgul",
"97613654", "Khuder\,\ Selenge",
"97615251", "Ulaanbadrakh\,\ Dornogovi",
"97625954", "Tsagaandelger\,\ Dundgovi",
"97625848", "Sereglen\,\ Dornod",
"97615644", "Bayanmunkh\,\ Khentii",
"97614245", "Bulgan\,\ Bayan\-Ulgii",
"97625149", "Tumentsogt\,\ Sukhbaatar",
"97614549", "Ulgii\,\ Uvs",
"9762452", "Ulaangom\ city\,\ Uvs",
"9761512", "Baruun\-Urt\ city\,\ Sukhbaatar",
"97613254", "Taragt\,\ Uvurkhangai",
"97613641", "Altanbulag\,\ Selenge",
"97615353", "Khurmen\,\ Umnugovi",
"9762432", "Khovd\ city\,\ Khovd",
"97612748", "Bayan\-Unjuul\,\ Tuv",
"97624242", "Altantsugts\,\ Bayan\-Ulgii",
"97614349", "Munkhkhairkhan\,\ Khovd",
"97625941", "Adaatsag\,\ Dundgovi",
"97614645", "Bulnai\,\ Zavkhan",
"97615244", "Delgerekh\,\ Dornogovi",
"97615651", "Darkhan\,\ Khentii",
"97614457", "Ulziit\,\ Bayankhongor",
"97613343", "Jargalant\,\ Arkhangai",
"97612752", "Bayantsogt\,\ Tuv",
"97613257", "Hairkhandulaan\,\ Uvurkhangai",
"97614841", "Altai\,\ Govi\-Altai",
"97615247", "Mandakh\,\ Dornogovi",
"97623442", "Bayannuur\,\ Bulgan",
"97613845", "Galt\,\ Khuvsgul",
"97614454", "Jargalant\,\ Bayankhongor",
"97614854", "Tsogt\,\ Govi\-Altai",
"97613445", "Gurvanbulag\,\ Bulgan",
"97623842", "Arbulag\,\ Khuvsgul",
"97613657", "Shaamar\,\ Selenge",
"97624658", "Urgamal\,\ Zavkhan",
"97613346", "Ulziit\,\ Arkhangai",
"97622755", "Buren\,\ Tuv",
"97625852", "Tsagaan\-Ovoo\,\ Dornod",
"97615647", "Binder\,\ Khentii",
"97614441", "Baatsagaan\,\ Bayankhongor",
"97615646", "Bayankhutagt\,\ Khentii",
"97614461", "Erdenetsogt\,\ Bayankhongor",
"97614453", "Gurvanbulag\,\ Bayankhongor",
"9761272", "Zuunmod\ city\,\ Tuv",
"97613347", "Undur\-Ulaan\,\ Arkhangai",
"97613656", "Tsagaannuur\,\ Selenge",
"97624348", "Mankhan\,\ Khovd",
"97622749", "Bayankhangai\,\ Tuv",
"97623862", "Tsetserleg\,\ Khuvsgul",
"9762542", "Choir\,\ Govisumber",
"97624548", "Naranbulag\,\ Uvs",
"97615148", "Tuvshin\-Shiree\,\ Sukhbaatar",
"97613865", "Erdenebulgan\,\ Khuvsgul",
"97615246", "Ikh\-Khet\,\ Dornogovi",
"9762582", "Choibalsan\ city\,\ Dornod",
"97615849", "Khalkh\,\ Dornod",
"97614853", "Khukhmorit\,\ Govi\-Altai",
"97613741", "Orkhon\,\ Darkhan\-Uul",
"97613256", "Uyanga\,\ Uvurkhangai",
"97613859", "Tsagaan\-Uul\,\ Khuvsgul",
"97615341", "Bayandalai\,\ Umnugovi",
"97613653", "Tushig\,\ Selenge",
"97614456", "Zag\,\ Bayankhongor",
"97614555", "Turgen\,\ Uvs",
"97614665", "Yaruu\,\ Zavkhan",
"97614355", "Tsetseg\,\ Khovd",
"97615643", "Bayan\-Adraga\,\ Khentii",
"97613351", "Khairkhan\,\ Arkhangai",
"97612768", "Erdenesant\,\ Tuv",
"97614659", "Tsegeenkhairkhan\,\ Zavkhan",
"97625953", "Khuld\,\ Dundgovi",
"97615354", "Tsogt\-Ovoo\,\ Umnugovi",
"97613253", "Sant\,\ Uvurkhangai",
"976223", "Nalaikh",
"97613344", "Ikh\-Tamir\,\ Arkhangai",
"97615152", "Halzan\,\ Sukhbaatar",
"97624552", "Undurkhangai\,\ Uvs",
"97624662", "Tsetsen\-Uul\,\ Zavkhan",
"97615243", "Dalanjargalan\,\ Dornogovi",
"97624352", "Myangad\,\ Khovd",
"97614856", "Chandmani\,\ Govi\-Altai",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+976|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;