/*
	$Id: dbdimp.h,v 1.44 2005/08/26 01:40:06 turnstep Exp $
	
	Copyright (c) 2000-2005 PostgreSQL Global Development Group
	Portions Copyright (c) 1997-2000 Edmund Mergl
	Portions Copyright (c) 1994-1997 Tim Bunce
	
	You may distribute under the terms of either the GNU General Public
	License or the Artistic License, as specified in the Perl README file.
*/

#include "types.h"

/* Define drh implementor data structure */
struct imp_drh_st {
	dbih_drc_t com; /* MUST be first element in structure */
};

/* Define dbh implementor data structure */
struct imp_dbh_st {
	dbih_dbc_t com;            /* MUST be first element in structure */

	bool    pg_bool_tf;        /* do bools return 't'/'f'? Set by user, default is 0 */
	bool    pg_enable_utf8;    /* should we attempt to make utf8 strings? Set by user, default is 0 */
	bool    prepare_now;       /* force immediate prepares, even with placeholders. Set by user, default is 0 */
	bool    done_begin;        /* have we done a begin? (e.g. are we in a transaction?) */

	int     pg_protocol;       /* value of PQprotocolVersion, usually 0, 2, or 3 */
	int     pg_server_version; /* Server version e.g. 80100 */
	int     prepare_number;    /* internal prepared statement name modifier */
	int     copystate;         /* 0=none PGRES_COPY_IN PGRES_COPY_OUT */
	int     pg_errorlevel;     /* PQsetErrorVerbosity. Set by user, defaults to 1 */
	int     server_prepare;    /* do we want to use PQexecPrepared? 0=no 1=yes 2=smart. Can be changed by user */

	AV      *savepoints;       /* list of savepoints */
	PGconn  *conn;             /* connection structure */
	char    *sqlstate;         /* from the last result */
};


/* Each statement is broken up into segments */
struct seg_st {
	char *segment;          /* non-placeholder string segment */
	int placeholder;        /* which placeholder this points to, 0=none */
	struct ph_st *ph;       /* points to the relevant ph structure */
	struct seg_st *nextseg; /* linked lists are fun */
};
typedef struct seg_st seg_t;

/* The placeholders are also a linked list */
struct ph_st {
	char  *fooname;             /* Name if using :foo style */
	char  *value;               /* the literal passed-in value, may be binary */
	STRLEN valuelen;            /* length of the value */
	char  *quoted;              /* quoted version of the value, for PQexec only */
	STRLEN quotedlen;           /* length of the quoted value */
	bool   referenced;          /* used for PREPARE AS construction */
	bool   defaultval;          /* is it using a generic 'default' value? */
	sql_type_info_t* bind_type; /* type information for this placeholder */
	struct ph_st *nextph;       /* more linked list goodness */
};
typedef struct ph_st ph_t;

/* Define sth implementor data structure */
struct imp_sth_st {
	dbih_stc_t com;         /* MUST be first element in structure */

	int    server_prepare;   /* inherited from dbh. 3 states: 0=no 1=yes 2=smart */
	int    placeholder_type; /* which style is being used 1=? 2=$1 3=:foo */
	int    numsegs;          /* how many segments this statement has */
	int    numphs;           /* how many placeholders this statement has */
	int    numbound;         /* how many placeholders were explicitly bound by the client, not us */
	int    cur_tuple;        /* current tuple being fetched */
	int    rows;             /* number of affected rows */

	STRLEN totalsize;        /* total string length of the statement (with no placeholders)*/

  char   *statement;       /* the rewritten statement, for passing to PQexecP.. */
	char   *prepare_name;    /* name of the prepared query; NULL if not prepared */
	char   *firstword;       /* first word of the statement */

	PGresult  *result;       /* result structure from the executed query */
	sql_type_info_t **type_info; /* type of each column in result */

	seg_t  *seg;             /* linked list of segments */
	ph_t   *ph;              /* linked list of placeholders */

	bool   prepare_now;      /* prepare this statement right away, even if it has placeholders */
	bool   prepared_by_us;   /* false if {prepare_name} set directly */
	bool   onetime;          /* this statement is guaranteed not to be run again - so don't use SSP */
	bool   direct;           /* allow bypassing of the statement parsing */
	bool   is_dml;           /* is this SELECT/INSERT/UPDATE/DELETE? */
	bool   has_binary;       /* does it have one or more binary placeholders? */
};

/* Other (non-static) functions we have added to dbdimp.c */

int dbd_db_ping(SV *dbh);
int dbd_db_getfd (SV *dbh, imp_dbh_t *imp_dbh);
SV * dbd_db_pg_notifies (SV *dbh, imp_dbh_t *imp_dbh);
int pg_db_putline (SV *dbh, const char *buffer);
int pg_db_getline (SV *dbh, char *buffer, int length);
int pg_db_endcopy (SV * dbh);
void pg_db_pg_server_trace (SV *dbh, FILE *fh);
void pg_db_pg_server_untrace (SV *dbh);
int pg_db_savepoint (SV *dbh, imp_dbh_t *imp_dbh, char * savepoint);
int pg_db_rollback_to (SV *dbh, imp_dbh_t *imp_dbh, char * savepoint);
int pg_db_release (SV *dbh, imp_dbh_t *imp_dbh, char * savepoint);
unsigned int pg_db_lo_creat (SV *dbh, int mode);
int pg_db_lo_open (SV *dbh, unsigned int lobjId, int mode);
int pg_db_lo_close (SV *dbh, int fd);
int pg_db_lo_read (SV *dbh, int fd, char *buf, size_t len);
int pg_db_lo_write (SV *dbh, int fd, char *buf, size_t len);
int pg_db_lo_lseek (SV *dbh, int fd, int offset, int whence);
int pg_db_lo_tell (SV *dbh, int fd);
int pg_db_lo_unlink (SV *dbh, unsigned int lobjId);
unsigned int pg_db_lo_import (SV *dbh, char *filename);
int pg_db_lo_export (SV *dbh, unsigned int lobjId, char *filename);
int pg_quickexec (SV *dbh, const char *sql);

/* end of dbdimp.h */

