package Bio::FastParsers::Blast::Xml::Hsp;
# ABSTRACT: NCBI BLAST DTD-derived internal class
$Bio::FastParsers::Blast::Xml::Hsp::VERSION = '0.180470';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);



# private attributes

has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);


# public array(s) of composed objects


# public composed object(s)


# public methods


sub align_len {
    return shift->_root->{'Hsp_align-len'}->{'value'}
}


sub bit_score {
    return shift->_root->{'Hsp_bit-score'}->{'value'}
}


sub density {
    return shift->_root->{'Hsp_density'}->{'value'}
}


sub evalue {
    return shift->_root->{'Hsp_evalue'}->{'value'}
}


sub gaps {
    return shift->_root->{'Hsp_gaps'}->{'value'}
}


sub hit_frame {
    return shift->_root->{'Hsp_hit-frame'}->{'value'}
}


sub hit_from {
    return shift->_root->{'Hsp_hit-from'}->{'value'}
}


sub hit_to {
    return shift->_root->{'Hsp_hit-to'}->{'value'}
}


sub hseq {
    return shift->_root->{'Hsp_hseq'}->{'value'}
}


sub identity {
    return shift->_root->{'Hsp_identity'}->{'value'}
}


sub midline {
    return shift->_root->{'Hsp_midline'}->{'value'}
}


sub num {
    return shift->_root->{'Hsp_num'}->{'value'}
}


sub pattern_from {
    return shift->_root->{'Hsp_pattern-from'}->{'value'}
}


sub pattern_to {
    return shift->_root->{'Hsp_pattern-to'}->{'value'}
}


sub positive {
    return shift->_root->{'Hsp_positive'}->{'value'}
}


sub qseq {
    return shift->_root->{'Hsp_qseq'}->{'value'}
}


sub query_frame {
    return shift->_root->{'Hsp_query-frame'}->{'value'}
}


sub query_from {
    return shift->_root->{'Hsp_query-from'}->{'value'}
}


sub query_to {
    return shift->_root->{'Hsp_query-to'}->{'value'}
}


sub score {
    return shift->_root->{'Hsp_score'}->{'value'}
}


# public aliases


sub expect {
    return shift->evalue
}

# pseudo-aliases

use Const::Fast;
const my $NEGFRAME => qr{\A -}xms;


sub hit_strand {
    my $self = shift;
    return $self->hit_frame =~ $NEGFRAME ? -1 : 1;
}


sub hit_start {
    my $self = shift;
    return $self->hit_from < $self->hit_to ? $self->hit_from
                                           : $self->hit_to;
}


sub hit_end {
    my $self = shift;
    return $self->hit_to > $self->hit_from ? $self->hit_to
                                           : $self->hit_from;
}


sub query_strand {
    my $self = shift;
    return $self->query_frame =~ $NEGFRAME ? -1 : 1;
}


sub query_start {
    my $self = shift;
    return $self->query_from < $self->query_to ? $self->query_from
                                               : $self->query_to;
}


sub query_end {  
    my $self = shift;
    return $self->query_to > $self->query_from ? $self->query_to
                                               : $self->query_from;
}


__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::FastParsers::Blast::Xml::Hsp - NCBI BLAST DTD-derived internal class

=head1 VERSION

version 0.180470

=head1 SYNOPSIS

    # see Bio::FastParsers::Blast::Xml

=head1 DESCRIPTION

This class implements the C<Hsp> level of the XML BLAST parser.

=head1 METHODS

=head2 align_len

Returns the value of the element C<<Hsp_align-len>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $align_len = $hsp->align_len;

This method does not accept any arguments.

=head2 bit_score

Returns the value of the element C<<Hsp_bit-score>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $bit_score = $hsp->bit_score;

This method does not accept any arguments.

=head2 density

Returns the value of the element C<<Hsp_density>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $density = $hsp->density;

This method does not accept any arguments.

=head2 evalue

Returns the value of the element C<<Hsp_evalue>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $evalue = $hsp->evalue;

This method does not accept any arguments.

=head2 gaps

Returns the value of the element C<<Hsp_gaps>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $gaps = $hsp->gaps;

This method does not accept any arguments.

=head2 hit_frame

Returns the value of the element C<<Hsp_hit-frame>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $hit_frame = $hsp->hit_frame;

This method does not accept any arguments.

=head2 hit_from

Returns the value of the element C<<Hsp_hit-from>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $hit_from = $hsp->hit_from;

This method does not accept any arguments.

=head2 hit_to

Returns the value of the element C<<Hsp_hit-to>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $hit_to = $hsp->hit_to;

This method does not accept any arguments.

=head2 hseq

Returns the value of the element C<<Hsp_hseq>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $hseq = $hsp->hseq;

This method does not accept any arguments.

=head2 identity

Returns the value of the element C<<Hsp_identity>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $identity = $hsp->identity;

This method does not accept any arguments.

=head2 midline

Returns the value of the element C<<Hsp_midline>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $midline = $hsp->midline;

This method does not accept any arguments.

=head2 num

Returns the value of the element C<<Hsp_num>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $num = $hsp->num;

This method does not accept any arguments.

=head2 pattern_from

Returns the value of the element C<<Hsp_pattern-from>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $pattern_from = $hsp->pattern_from;

This method does not accept any arguments.

=head2 pattern_to

Returns the value of the element C<<Hsp_pattern-to>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $pattern_to = $hsp->pattern_to;

This method does not accept any arguments.

=head2 positive

Returns the value of the element C<<Hsp_positive>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $positive = $hsp->positive;

This method does not accept any arguments.

=head2 qseq

Returns the value of the element C<<Hsp_qseq>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $qseq = $hsp->qseq;

This method does not accept any arguments.

=head2 query_frame

Returns the value of the element C<<Hsp_query-frame>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $query_frame = $hsp->query_frame;

This method does not accept any arguments.

=head2 query_from

Returns the value of the element C<<Hsp_query-from>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $query_from = $hsp->query_from;

This method does not accept any arguments.

=head2 query_to

Returns the value of the element C<<Hsp_query-to>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $query_to = $hsp->query_to;

This method does not accept any arguments.

=head2 score

Returns the value of the element C<<Hsp_score>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $score = $hsp->score;

This method does not accept any arguments.

=head2 hit_strand

Returns the strand of the hit. The strand can be either 1 or -1 depending on
the sign of the element C<<Hsp_hit-frame>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $hit_strand = $hsp->hit_strand;

This method does not accept any arguments.

=head2 hit_start

Returns the start coordinate of the hit. This value is taken either from the
element C<<Hsp_hit-from>> or from the element C<<Hsp_hit-to>> depending on
the hit orientation. The numerical value returned by this method is
guaranteed to be lower than the value returned by C<hit_end>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my ($hit_start, $hit_end) = ($hsp->hit_start, $hsp->hit_end);
    if ($hit_start < $hit_end) {    # always true
        ...
    }

This method does not accept any arguments.

=head2 hit_end

Returns the end coordinate of the hit. This value is taken either from the
element C<<Hsp_hit-to>> or from the element C<<Hsp_hit-from>> depending on
the hit orientation. The numerical value returned by this method is
guaranteed to be greater than the value returned by C<hit_start>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my ($hit_start, $hit_end) = ($hsp->hit_start, $hsp->hit_end);
    if ($hit_start < $hit_end) {    # always true
        ...
    }

This method does not accept any arguments.

=head2 query_strand

Returns the strand of the query. The strand can be either 1 or -1 depending
on the sign of the element C<<Hsp_query-frame>>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my $query_strand = $hsp->query_strand;

This method does not accept any arguments.

=head2 query_start

Returns the start coordinate of the query. This value is taken either from
the element C<<Hsp_query-from>> or from the element C<<Hsp_query-to>>
depending on the query orientation. The numerical value returned by this
method is guaranteed to be lower than the value returned by C<query_end>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my ($query_start, $query_end) = ($hsp->query_start, $hsp->query_end);
    if ($query_start < $query_end) {    # always true
        ...
    }

This method does not accept any arguments.

=head2 query_end

Returns the end coordinate of the query. This value is taken either from the
element C<<Hsp_query-to>> or from the element C<<Hsp_query-from>> depending
on the query orientation. The numerical value returned by this method is
guaranteed to be greater than the value returned by C<query_start>.

    # $hsp is a Bio::FastParsers::Blast::Xml::Hsp
    my ($query_start, $query_end) = ($hsp->query_start, $hsp->query_end);
    if ($query_start < $query_end) {    # always true
        ...
    }

This method does not accept any arguments.

=head1 ALIASES

=head2 expect

Alias for C<evalue> method. For API consistency.

=head1 AUTHOR

Denis BAURAIN <denis.baurain@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by University of Liege / Unit of Eukaryotic Phylogenomics / Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
