package OpenInteract2::SQLInstall::Page;

# $Id: Page.pm,v 1.1 2003/03/25 02:40:21 lachoy Exp $

use strict;
use base qw( OpenInteract2::SQLInstall );

my @TABLES = ( 'page.sql',
               'page_content.sql',
               'content_type.sql',
               'page_directory.sql' );

my %FILES = (
  oracle => [ 'page_oracle.sql',
              'page_content_oracle.sql',
              'content_type_oracle.sql',
              'content_type_sequence.sql',
              'page_directory_oracle.sql' ],
  pg     => [ @TABLES,
              'content_type_sequence.sql' ],
  ib     => [ 'page_interbase.sql',
              'page_content_interbase.sql',
              'content_type.sql',
              'page_directory.sql',
              'content_type_generator.sql' ],
);

sub get_structure_set {
    return 'page';
}

sub get_structure_file {
    my ( $self, $set, $type ) = @_;
    if ( $type eq 'Oracle' ) {
        return $FILES{oracle};
    }
    elsif ( $type eq 'Pg' ) {
        return $FILES{pg};
    }
    elsif ( $type eq 'InterBase' ) {
        return $FILES{ib};
    }
    else {
        return [ @TABLES ];
    }
}

sub get_security_file {
    return 'install_security.dat';
}

sub get_data_file {
    return [ 'content_types.dat',
             'page.dat',
             'page_directory.dat' ];
}

1;
